/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome.spawning;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntriesProvider;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntry;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.util.WeightedList;

public class MobSpawnHandler {
    public static final MobSpawnHandler INSTANCE = new MobSpawnHandler();
    private static final int CHUNK_GEN_SPAWN_RUNS = 128;
    private static final int SPAWN_CHUNK_MAX_RANGE = 8;
    private static final int SPAWN_CHUNK_MIN_RANGE = 1;
    private static final int MAX_SPAWN_CHUNKS_PER_AREA = 280;
    private static final int SPAWNING_ATTEMPTS_PER_CHUNK = 8;
    private static final int SPAWNING_ATTEMPTS_PER_GROUP = 32;
    private static final int MAX_SPAWNS_PER_CHUNK = 6;
    private static final int HARD_ENTITY_LIMIT = BetweenlandsConfig.MOB_SPAWNING.hardEntityLimit;
    private Set<ChunkPos> eligibleChunksForSpawning = new HashSet<ChunkPos>();
    private TObjectIntHashMap<Class<? extends Entity>> entityCounts = new TObjectIntHashMap();

    public static final float getMaxEntitiesPerSpawnChunkMultiplier() {
        return (float)BetweenlandsConfig.MOB_SPAWNING.maxEntitiesPerLoadedArea / 280.0f;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WorldServer world = DimensionManager.getWorld((int)BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId);
            if (world == null || world.field_73010_i.isEmpty()) {
                return;
            }
            if (world.func_82736_K().func_82766_b("doMobSpawning") && world.func_82737_E() % 4L == 0L) {
                this.populateWorld(world);
            }
        }
    }

    public void populateChunk(WorldServer world, int chunkX, int chunkZ) {
        if (world == null || world.field_73011_w.getDimension() != BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
            return;
        }
        if (world.func_82736_K().func_82766_b("doMobSpawning")) {
            boolean spawnHostiles = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnHostiles();
            boolean spawnAnimals = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnAnimals();
            int spawnedEntities = 0;
            spawnedEntities += this.populateChunk((World)world, new ChunkPos(chunkX, chunkZ), spawnHostiles, spawnAnimals, false, true, 1024, 60, 32, HARD_ENTITY_LIMIT, 1.0f);
        }
    }

    private void populateWorld(WorldServer world) {
        if (!(world.field_73011_w instanceof WorldProviderBetweenlands)) {
            return;
        }
        int totalWorldEntityCount = 0;
        for (Object entity : world.field_72996_f) {
            if (!(entity instanceof EntityLivingBase)) continue;
            ++totalWorldEntityCount;
        }
        if (totalWorldEntityCount >= HARD_ENTITY_LIMIT) {
            return;
        }
        this.updateSpawnerChunks(world);
        if (this.eligibleChunksForSpawning.isEmpty()) {
            return;
        }
        ArrayList<ChunkPos> spawnerChunks = new ArrayList<ChunkPos>(this.eligibleChunksForSpawning.size());
        for (ChunkPos chunkPos : this.eligibleChunksForSpawning) {
            if (!world.func_175667_e(new BlockPos(chunkPos.field_77276_a * 16, 64, chunkPos.field_77275_b * 16))) continue;
            spawnerChunks.add(chunkPos);
        }
        this.updateEntityCounts((World)world);
        int totalEligibleEntityCount = 0;
        for (int count : this.entityCounts.values()) {
            totalEligibleEntityCount += count;
        }
        int n = Math.min(HARD_ENTITY_LIMIT, (int)((float)spawnerChunks.size() * MobSpawnHandler.getMaxEntitiesPerSpawnChunkMultiplier()));
        if (totalEligibleEntityCount >= n) {
            return;
        }
        Collections.shuffle(spawnerChunks);
        boolean spawnHostiles = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnHostiles();
        boolean spawnAnimals = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnAnimals();
        float loadedAreas = (float)spawnerChunks.size() / 280.0f;
        for (ChunkPos chunkPos : spawnerChunks) {
            this.populateChunk((World)world, chunkPos, spawnHostiles, spawnAnimals, true, false, 8, 6, 32, n, loadedAreas);
        }
    }

    private int populateChunk(World world, ChunkPos chunkPos, boolean spawnHostiles, boolean spawnAnimals, boolean loadChunks, boolean ignoreRestrictions, int attemptsPerChunk, int maxSpawnsPerChunk, int attemptsPerGroup, int entityLimit, float loadedAreas) {
        int attempts = 0;
        int chunkSpawnedEntities = 0;
        block0: while (attempts++ < attemptsPerChunk && chunkSpawnedEntities < maxSpawnsPerChunk) {
            ICustomSpawnEntry spawnEntry2;
            IBlockState centerSpawnBlockState;
            BlockPos spawnPos = this.getRandomSpawnPosition(world, chunkPos);
            Biome biome = world.func_180494_b(spawnPos);
            if (world.field_73012_v.nextFloat() > biome.func_76741_f() || !(biome instanceof ICustomSpawnEntriesProvider) || (centerSpawnBlockState = world.func_180495_p(spawnPos)).func_185915_l()) continue;
            int totalBaseWeight = 0;
            int totalWeight = 0;
            List<ICustomSpawnEntry> biomeSpawns = ((ICustomSpawnEntriesProvider)biome).getCustomSpawnEntries();
            ArrayList<ICustomSpawnEntry> possibleSpawns = new ArrayList<ICustomSpawnEntry>();
            for (ICustomSpawnEntry spawnEntry2 : biomeSpawns) {
                if (spawnEntry2.isHostile() && !spawnHostiles || !spawnEntry2.isHostile() && !spawnAnimals) continue;
                totalBaseWeight += spawnEntry2.getBaseWeight();
                possibleSpawns.add(spawnEntry2);
                spawnEntry2.update(world, spawnPos);
                totalWeight += spawnEntry2.getWeight();
            }
            if (possibleSpawns.isEmpty()) continue;
            WeightedList weightedPossibleSpawns = new WeightedList();
            weightedPossibleSpawns.addAll(possibleSpawns);
            weightedPossibleSpawns.recalculateWeight();
            spawnEntry2 = (ICustomSpawnEntry)weightedPossibleSpawns.getRandomItem(world.field_73012_v);
            if (spawnEntry2 == null) continue;
            int dynamicLimitBase = (int)((double)entityLimit / (double)totalBaseWeight * (double)spawnEntry2.getBaseWeight());
            int dynamicLimit = (int)((double)entityLimit / (double)totalWeight * (double)spawnEntry2.getWeight());
            int spawnEntityCount = this.entityCounts.get(spawnEntry2.getEntityType());
            if (spawnEntityCount >= Math.max(dynamicLimit, dynamicLimitBase) || spawnEntry2.getWorldLimit() >= 0 && spawnEntityCount >= spawnEntry2.getWorldLimit()) continue;
            int desiredGroupSize = spawnEntry2.getMinGroupSize() + world.field_73012_v.nextInt(spawnEntry2.getMaxGroupSize() - spawnEntry2.getMinGroupSize() + 1);
            double groupCheckRadius = spawnEntry2.getSpawnCheckRadius();
            int csx = MathHelper.func_76128_c((double)((double)spawnPos.func_177958_n() - groupCheckRadius)) >> 4;
            int cex = MathHelper.func_76128_c((double)((double)spawnPos.func_177958_n() + groupCheckRadius)) >> 4;
            int csz = MathHelper.func_76128_c((double)((double)spawnPos.func_177952_p() - groupCheckRadius)) >> 4;
            int cez = MathHelper.func_76128_c((double)((double)spawnPos.func_177952_p() + groupCheckRadius)) >> 4;
            for (int cx = csx; cx <= cex; ++cx) {
                for (int cz = csz; cz <= cez; ++cz) {
                    if (world.func_72863_F().func_186026_b(cx, cz) == null && (cx != chunkPos.field_77276_a || cz != chunkPos.field_77275_b)) continue block0;
                }
            }
            double groupSpawnRadius = spawnEntry2.getGroupSpawnRadius();
            Class<? extends EntityLiving> entityType = spawnEntry2.getEntityType();
            boolean checkExistingGroups = spawnEntry2.shouldCheckExistingGroups();
            if (checkExistingGroups) {
                List foundGroupEntities = world.func_72872_a(entityType, new AxisAlignedBB((double)spawnPos.func_177958_n() - groupCheckRadius, (double)spawnPos.func_177956_o() - spawnEntry2.getSpawnCheckRangeY(), (double)spawnPos.func_177952_p() - groupCheckRadius, (double)spawnPos.func_177958_n() + groupCheckRadius, (double)spawnPos.func_177956_o() + spawnEntry2.getSpawnCheckRangeY(), (double)spawnPos.func_177952_p() + groupCheckRadius));
                for (Entity foundGroupEntity : foundGroupEntities) {
                    if (!(foundGroupEntity.func_70011_f((double)spawnPos.func_177958_n(), foundGroupEntity.field_70163_u + ((double)spawnPos.func_177956_o() - foundGroupEntity.field_70163_u) / spawnEntry2.getSpawnCheckRangeY() * groupCheckRadius, (double)spawnPos.func_177952_p()) <= groupCheckRadius)) continue;
                    --desiredGroupSize;
                }
            }
            if (desiredGroupSize <= 0) continue;
            int groupSpawnedEntities = 0;
            int groupSpawnAttempts = 0;
            int maxGroupSpawnAttempts = attemptsPerGroup + desiredGroupSize * 2;
            BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
            BetweenlandsWorldStorage.BiomeSpawnEntriesData spawnEntriesData = null;
            long lastSpawn = -1L;
            if (worldStorage != null) {
                spawnEntriesData = worldStorage.getBiomeSpawnEntriesData(biome);
                lastSpawn = spawnEntriesData.getLastSpawn(spawnEntry2);
            }
            if (!ignoreRestrictions && lastSpawn >= 0L) {
                int adjustedInterval = (int)((float)spawnEntry2.getSpawningInterval() / loadedAreas);
                if (spawnEntriesData != null && world.func_82737_E() - lastSpawn < (long)adjustedInterval) continue;
            }
            IEntityLivingData groupData = null;
            while (groupSpawnAttempts++ < maxGroupSpawnAttempts && groupSpawnedEntities < desiredGroupSize) {
                IBlockState surfaceBlockState;
                IBlockState spawnBlockState;
                boolean inChunk;
                BlockPos entitySpawnPos = this.getRandomSpawnPosition(world, spawnPos, MathHelper.func_76128_c((double)groupSpawnRadius));
                boolean bl = inChunk = entitySpawnPos.func_177958_n() >> 4 == chunkPos.field_77276_a && entitySpawnPos.func_177952_p() >> 4 == chunkPos.field_77275_b;
                if (!loadChunks && !inChunk || world.func_184137_a((double)entitySpawnPos.func_177958_n(), (double)entitySpawnPos.func_177956_o(), (double)entitySpawnPos.func_177952_p(), 24.0, false) != null || (spawnBlockState = world.func_180495_p(entitySpawnPos)).func_185915_l()) continue;
                int spawnSegmentY = entitySpawnPos.func_177956_o() / 16;
                Chunk spawnChunk = world.func_175726_f(entitySpawnPos);
                ClassInheritanceMultiMap[] entityLists = spawnChunk.func_177429_s();
                int chunkEntityCount = 0;
                for (int l = 0; l < entityLists.length; ++l) {
                    int subChunkEntityCount = 0;
                    for (Entity entity : entityLists[l]) {
                        if (entity.getClass() != spawnEntry2.getEntityType()) continue;
                        ++subChunkEntityCount;
                        ++chunkEntityCount;
                    }
                    if (l == spawnSegmentY && spawnEntry2.getSubChunkLimit() >= 0 && subChunkEntityCount < spawnEntry2.getSubChunkLimit()) continue;
                }
                if (spawnEntry2.getChunkLimit() >= 0 && chunkEntityCount >= spawnEntry2.getChunkLimit() || !spawnEntry2.canSpawn(world, spawnChunk, entitySpawnPos, spawnBlockState, surfaceBlockState = spawnChunk.func_186032_a(entitySpawnPos.func_177958_n() - spawnChunk.field_76635_g * 16, entitySpawnPos.func_177956_o() - 1, entitySpawnPos.func_177952_p() - spawnChunk.field_76647_h * 16))) continue;
                double sx = (double)entitySpawnPos.func_177958_n() + 0.5;
                double sy = entitySpawnPos.func_177956_o();
                double sz = (double)entitySpawnPos.func_177952_p() + 0.5;
                float yaw = world.field_73012_v.nextFloat() * 360.0f;
                EntityLiving newEntity = spawnEntry2.createEntity(world);
                if (newEntity == null) continue;
                newEntity.func_70012_b(sx, sy, sz, yaw, 0.0f);
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)newEntity, (World)world, (float)((float)sx), (float)((float)sy), (float)((float)sz), null);
                if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !newEntity.func_70601_bi() || !newEntity.func_70058_J())) continue;
                ++groupSpawnedEntities;
                ++chunkSpawnedEntities;
                NBTTagCompound entityNBT = newEntity.getEntityData();
                entityNBT.func_74757_a("naturallySpawned", true);
                world.func_72838_d((Entity)newEntity);
                if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)newEntity, (World)world, (float)((float)sx), (float)((float)sy), (float)((float)sz), null)) {
                    groupData = newEntity.func_180482_a(world.func_175649_E(new BlockPos(sx, sy, sz)), groupData);
                }
                spawnEntry2.onSpawned((EntityLivingBase)newEntity);
                if (groupSpawnedEntities < ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)newEntity)) continue;
                break;
            }
            if (spawnEntriesData == null || ignoreRestrictions || groupSpawnedEntities <= 0) continue;
            spawnEntriesData.setLastSpawn(spawnEntry2, world.func_82737_E());
        }
        return chunkSpawnedEntities;
    }

    private BlockPos getRandomSpawnPosition(World world, ChunkPos chunkPos) {
        Chunk chunk = world.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
        int x = chunkPos.field_77276_a * 16 + world.field_73012_v.nextInt(16);
        int z = chunkPos.field_77275_b * 16 + world.field_73012_v.nextInt(16);
        int y = Math.min(world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1), 256);
        return new BlockPos(x, y, z);
    }

    private BlockPos getRandomSpawnPosition(World world, BlockPos centerPos, int radius) {
        return new BlockPos(centerPos.func_177958_n() + world.field_73012_v.nextInt(radius * 2) - radius, MathHelper.func_76125_a((int)(centerPos.func_177956_o() + world.field_73012_v.nextInt(4) - 2), (int)1, (int)world.func_72800_K()), centerPos.func_177952_p() + world.field_73012_v.nextInt(radius * 2) - radius);
    }

    private void updateSpawnerChunks(WorldServer world) {
        this.eligibleChunksForSpawning.clear();
        HashMap<ChunkPos, Boolean> eligibleChunks = new HashMap<ChunkPos, Boolean>();
        for (EntityPlayer entityPlayer : world.field_73010_i) {
            if (entityPlayer.func_175149_v()) continue;
            int cx = MathHelper.func_76128_c((double)(entityPlayer.field_70165_t / 16.0));
            int cz = MathHelper.func_76128_c((double)(entityPlayer.field_70161_v / 16.0));
            for (int xo = -8; xo <= 8; ++xo) {
                for (int zo = -8; zo <= 8; ++zo) {
                    PlayerChunkMapEntry playerchunkmapentry;
                    boolean isBorder = Math.abs(xo) > 1 || Math.abs(zo) > 1;
                    ChunkPos chunkpos = new ChunkPos(xo + cx, zo + cz);
                    if (!world.func_175723_af().func_177730_a(chunkpos) || (playerchunkmapentry = world.func_184164_w().func_187301_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) == null || !playerchunkmapentry.func_187274_e()) continue;
                    if (!isBorder) {
                        eligibleChunks.put(chunkpos, false);
                        continue;
                    }
                    if (eligibleChunks.containsKey(chunkpos)) continue;
                    eligibleChunks.put(chunkpos, true);
                }
            }
        }
        for (Map.Entry entry : eligibleChunks.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            this.eligibleChunksForSpawning.add((ChunkPos)entry.getKey());
        }
    }

    private void updateEntityCounts(World world) {
        this.entityCounts.clear();
        for (ChunkPos chunkPos : this.eligibleChunksForSpawning) {
            ClassInheritanceMultiMap[] entityLists;
            if (world.func_72863_F().func_186026_b(chunkPos.field_77276_a, chunkPos.field_77275_b) == null) continue;
            Chunk chunk = world.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
            for (ClassInheritanceMultiMap entityList : entityLists = chunk.func_177429_s()) {
                for (Entity entity : entityList) {
                    if (!(entity instanceof EntityLivingBase)) continue;
                    this.entityCounts.adjustOrPutValue(entity.getClass(), 1, 1);
                }
            }
        }
    }

    public static class BLSpawnEntry
    implements ICustomSpawnEntry {
        private final Class<? extends EntityLiving> entityType;
        private final Constructor<? extends EntityLiving> entityCtor;
        private final short baseWeight;
        private short weight;
        private boolean hostile = false;
        private int subChunkLimit = -1;
        private int chunkLimit = -1;
        private int worldLimit = -1;
        private int minGroupSize = 1;
        private int maxGroupSize = 1;
        private double spawnCheckRadius = 16.0;
        private double spawnCheckRangeY = 6.0;
        private double groupSpawnRadius = 6.0;
        private int spawningInterval = 0;
        public final ResourceLocation id;

        public BLSpawnEntry(Class<? extends EntityLiving> entityType) {
            this(-1, entityType, 100);
        }

        public BLSpawnEntry(Class<? extends EntityLiving> entityType, short weight) {
            this(-1, entityType, weight);
        }

        public BLSpawnEntry(int id, Class<? extends EntityLiving> entityType) {
            this(id, entityType, 100);
        }

        public BLSpawnEntry(int id, Class<? extends EntityLiving> entityType, short weight) {
            this.id = new ResourceLocation("thebetweenlands", String.valueOf(id));
            this.entityType = entityType;
            try {
                this.entityCtor = this.entityType.getConstructor(World.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException("Can't find or access entity constructor (World) of entity: " + entityType.getName());
            }
            this.weight = weight;
            this.baseWeight = weight;
        }

        @Override
        public ResourceLocation getID() {
            return this.id;
        }

        @Override
        public boolean isSaved() {
            return !"-1".equals(this.id.func_110623_a());
        }

        @Override
        public boolean canSpawn(World world, Chunk chunk, BlockPos pos, IBlockState blockState, IBlockState surfaceBlockState) {
            return surfaceBlockState.func_185915_l();
        }

        @Override
        public void update(World world, BlockPos pos) {
        }

        @Override
        public final short getWeight() {
            return this.weight;
        }

        @Override
        public final BLSpawnEntry setWeight(short weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public final BLSpawnEntry setSpawningInterval(int interval) {
            this.spawningInterval = interval;
            return this;
        }

        @Override
        public final int getSpawningInterval() {
            return this.spawningInterval;
        }

        @Override
        public final short getBaseWeight() {
            return this.baseWeight;
        }

        @Override
        public final BLSpawnEntry setGroupSize(int min, int max) {
            if (max < min) {
                throw new RuntimeException("Maximum group size cannot be smaller than minimum group size!");
            }
            this.minGroupSize = min;
            this.maxGroupSize = max;
            return this;
        }

        @Override
        public final int getMaxGroupSize() {
            return this.maxGroupSize;
        }

        @Override
        public final int getMinGroupSize() {
            return this.minGroupSize;
        }

        @Override
        public final int getChunkLimit() {
            return this.chunkLimit;
        }

        @Override
        public final BLSpawnEntry setChunkLimit(int limit) {
            this.chunkLimit = limit;
            return this;
        }

        @Override
        public final int getWorldLimit() {
            return this.worldLimit;
        }

        @Override
        public final BLSpawnEntry setWorldLimit(int limit) {
            this.worldLimit = limit;
            return this;
        }

        @Override
        public final int getSubChunkLimit() {
            return this.subChunkLimit;
        }

        @Override
        public final BLSpawnEntry setSubChunkLimit(int limit) {
            this.subChunkLimit = limit;
            return this;
        }

        @Override
        public final BLSpawnEntry setHostile(boolean hostile) {
            this.hostile = hostile;
            return this;
        }

        @Override
        public final boolean isHostile() {
            return this.hostile;
        }

        @Override
        public final BLSpawnEntry setSpawnCheckRadius(double radius) {
            this.spawnCheckRadius = radius;
            return this;
        }

        @Override
        public final double getSpawnCheckRadius() {
            return this.spawnCheckRadius;
        }

        @Override
        public final BLSpawnEntry setSpawnCheckRangeY(double y) {
            this.spawnCheckRangeY = y;
            return this;
        }

        @Override
        public final double getSpawnCheckRangeY() {
            return this.spawnCheckRangeY;
        }

        @Override
        public final BLSpawnEntry setGroupSpawnRadius(double radius) {
            this.groupSpawnRadius = radius;
            return this;
        }

        @Override
        public final double getGroupSpawnRadius() {
            return this.groupSpawnRadius;
        }

        @Override
        public boolean shouldCheckExistingGroups() {
            return true;
        }

        @Override
        public EntityLiving createEntity(World world) {
            try {
                return this.entityCtor.newInstance(world);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public final Class<? extends EntityLiving> getEntityType() {
            return this.entityType;
        }

        @Override
        public void onSpawned(EntityLivingBase entity) {
        }
    }
}

