/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntry;
import thebetweenlands.common.entity.mobs.EntityAngler;
import thebetweenlands.common.entity.mobs.EntityBlindCaveFish;
import thebetweenlands.common.entity.mobs.EntityBloodSnail;
import thebetweenlands.common.entity.mobs.EntityBoulderSprite;
import thebetweenlands.common.entity.mobs.EntityChiromaw;
import thebetweenlands.common.entity.mobs.EntityDragonFly;
import thebetweenlands.common.entity.mobs.EntityFirefly;
import thebetweenlands.common.entity.mobs.EntityFrog;
import thebetweenlands.common.entity.mobs.EntityGecko;
import thebetweenlands.common.entity.mobs.EntityLeech;
import thebetweenlands.common.entity.mobs.EntityLurker;
import thebetweenlands.common.entity.mobs.EntityMireSnail;
import thebetweenlands.common.entity.mobs.EntitySiltCrab;
import thebetweenlands.common.entity.mobs.EntitySporeling;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.entity.mobs.EntityWight;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.biome.spawning.spawners.BetweenstoneCaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.CaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.GreeblingSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SporelingSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SwampHagCaveSpawnEntry;
import thebetweenlands.common.world.gen.biome.decorator.BiomeDecoratorPatchyIslands;
import thebetweenlands.common.world.gen.biome.feature.AlgaeFeature;
import thebetweenlands.common.world.gen.biome.feature.SiltBeachFeature;

public class BiomePatchyIslands
extends BiomeBetweenlands {
    public BiomePatchyIslands() {
        super(new ResourceLocation("thebetweenlands", "patchy_islands"), new Biome.BiomeProperties("Patchy Islands").func_185398_c(118.75f).func_185400_d(4.75f).func_185402_a(1589792).func_185410_a(0.8f).func_185395_b(0.9f));
        this.setWeight(20);
        this.getBiomeGenerator().setDecorator(new BiomeDecoratorPatchyIslands(this)).addFeature(new SiltBeachFeature()).addFeature(new AlgaeFeature());
        this.setFoliageColors(2082413, 44412);
        this.setSecondaryFoliageColors(2082365, -1);
    }

    @Override
    public void addTypes() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER});
    }

    @Override
    protected void addSpawnEntries(List<ICustomSpawnEntry> entries) {
        super.addSpawnEntries(entries);
        entries.add(new SurfaceSpawnEntry(0, EntityDragonFly.class, 35).setCanSpawnOnWater(true).setGroupSize(1, 3).setSpawnCheckRadius(64.0).setSpawningInterval(400));
        entries.add(new SurfaceSpawnEntry(1, EntityFirefly.class, 60).setCanSpawnOnWater(true).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(2, EntityMireSnail.class, 60).setGroupSize(1, 5).setSpawnCheckRadius(32.0).setSpawningInterval(1000));
        entries.add(new SurfaceSpawnEntry(3, EntityFrog.class, 32).setCanSpawnOnWater(true).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(1000));
        entries.add(new CaveSpawnEntry(4, EntityBlindCaveFish.class, 30).setCanSpawnInWater(true).setGroupSize(3, 5).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(5, EntityGecko.class, 40).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(600));
        entries.add(new SporelingSpawnEntry(6, EntitySporeling.class, 80).setGroupSize(2, 5).setSpawnCheckRadius(32.0));
        entries.add(new GreeblingSpawnEntry(20, 20).setGroupSize(1, 3).setSpawnCheckRadius(64.0).setGroupSpawnRadius(4.0).setSpawningInterval(24000));
        entries.add(new SurfaceSpawnEntry(7, EntityLurker.class, 35).setCanSpawnInWater(true).setHostile(true).setSpawnCheckRadius(16.0));
        entries.add(new SurfaceSpawnEntry(8, EntityAngler.class, 45).setCanSpawnInWater(true).setHostile(true).setGroupSize(1, 3));
        entries.add(new CaveSpawnEntry(9, EntityAngler.class, 35).setCanSpawnInWater(true).setHostile(true).setGroupSize(1, 3));
        entries.add(new SurfaceSpawnEntry(10, EntitySwampHag.class, 90).setHostile(true));
        entries.add(new SwampHagCaveSpawnEntry(11, 80).setHostile(true).setSpawnCheckRadius(24.0).setGroupSize(1, 3));
        entries.add(new SurfaceSpawnEntry(12, EntityWight.class, 16).setHostile(true).setSpawnCheckRadius(64.0).setSpawnCheckRangeY(16.0).setSpawningInterval(6000));
        entries.add(new CaveSpawnEntry(13, EntityWight.class, 18).setHostile(true).setSpawnCheckRadius(64.0));
        entries.add(new SurfaceSpawnEntry(14, EntitySiltCrab.class, 50).setSurfacePredicate((Predicate<IBlockState>)((Predicate)state -> state.func_177230_c() == BlockRegistry.SILT)).setHostile(true).setGroupSize(2, 8).setSpawnCheckRadius(32.0).setSpawnCheckRangeY(16.0).setSpawningInterval(1000));
        entries.add(new SurfaceSpawnEntry(15, EntityBloodSnail.class, 30).setHostile(true).setSpawnCheckRadius(32.0).setSpawningInterval(1000));
        entries.add(new SurfaceSpawnEntry(16, EntityLeech.class, 35).setHostile(true).setSpawnCheckRadius(24.0).setSpawningInterval(1000));
        entries.add(new SurfaceSpawnEntry(17, EntityChiromaw.class, 40).setHostile(true).setSpawnCheckRadius(30.0));
        entries.add(new CaveSpawnEntry(18, EntityChiromaw.class, 60).setHostile(true).setSpawnCheckRadius(20.0).setGroupSize(1, 3));
        entries.add(new BetweenstoneCaveSpawnEntry(19, EntityBoulderSprite.class, 60).setHostile(true).setSpawnCheckRadius(16.0).setSpawnCheckRangeY(8.0));
    }
}

