/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.container.BlockBLFurnace;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public class TileEntityBLFurnace
extends TileEntityBasicInventory
implements ISidedInventory,
ITickable {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1, 3};
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;
    private String customName;

    public TileEntityBLFurnace() {
        super(4, "sulfur_furnace");
    }

    public static boolean isItemFlux(ItemStack itemstack) {
        return itemstack.func_77973_b() == ItemRegistry.ITEMS_MISC && itemstack.func_77952_i() == ItemMisc.EnumItemMisc.LIMESTONE_FLUX.getID();
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.size();
    }

    @Override
    public boolean func_191420_l() {
        return this.inventory.size() <= 0;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(slot)).func_190916_E() <= amount) {
                ItemStack itemstack = (ItemStack)this.inventory.get(slot);
                this.inventory.set(slot, (Object)ItemStack.field_190927_a);
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.inventory.get(slot)).func_77979_a(amount);
            if (((ItemStack)this.inventory.get(slot)).func_190916_E() == 0) {
                this.inventory.set(slot, (Object)ItemStack.field_190927_a);
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) {
            ItemStack itemstack = (ItemStack)this.inventory.get(slot);
            this.inventory.set(slot, (Object)ItemStack.field_190927_a);
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_70299_a(int slot, @Nonnull ItemStack itemstack) {
        this.inventory.set(slot, (Object)itemstack);
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.furnace_bl";
    }

    @Override
    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void getStackDisplayName(String name) {
        this.customName = name;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.furnaceBurnTime = nbt.func_74765_d("BurnTime");
        this.furnaceCookTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)this.inventory.get(1)));
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbt.func_74777_a("CookTime", (short)this.furnaceCookTime);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        return nbt;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int count) {
        return this.furnaceCookTime * count / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int remainingTime) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * remainingTime / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_73660_a() {
        boolean isBurning = this.furnaceBurnTime > 0;
        boolean isDirty = false;
        if (this.furnaceBurnTime > 0) {
            this.furnaceBurnTime = Math.max(0, this.furnaceBurnTime - 1);
        } else if (this.furnaceBurnTime < 0) {
            this.furnaceBurnTime = 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime != 0 || !((ItemStack)this.inventory.get(1)).func_190926_b() && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
                if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)this.inventory.get(1)));
                    if (this.furnaceBurnTime > 0) {
                        isDirty = true;
                        if (!((ItemStack)this.inventory.get(1)).func_190926_b()) {
                            ((ItemStack)this.inventory.get(1)).func_190918_g(1);
                            if (((ItemStack)this.inventory.get(1)).func_190916_E() == 0) {
                                this.inventory.set(1, (Object)((ItemStack)this.inventory.get(1)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(1)));
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == 200) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                        isDirty = true;
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
            }
            if (isBurning != this.furnaceBurnTime > 0) {
                isDirty = true;
                BlockBLFurnace.setState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (isDirty) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.inventory.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.inventory.get(2)).func_77969_a(itemstack)) {
            return false;
        }
        int result = ((ItemStack)this.inventory.get(2)).func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= ((ItemStack)this.inventory.get(2)).func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.inventory.get(0));
            if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
                this.inventory.set(2, (Object)itemstack.func_77946_l());
            } else if (((ItemStack)this.inventory.get(2)).func_77973_b() == itemstack.func_77973_b()) {
                ((ItemStack)this.inventory.get(2)).func_190917_f(itemstack.func_190916_E());
            }
            if (ItemRegistry.isIngotFromOre((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(2)) && !((ItemStack)this.inventory.get(3)).func_190926_b()) {
                boolean useFlux;
                boolean bl = useFlux = this.field_145850_b.field_73012_v.nextInt(3) == 0;
                if (useFlux && ((ItemStack)this.inventory.get(2)).func_190916_E() + 1 <= this.func_70297_j_() && ((ItemStack)this.inventory.get(2)).func_190916_E() + 1 <= ((ItemStack)this.inventory.get(2)).func_77976_d()) {
                    ((ItemStack)this.inventory.get(2)).func_190917_f(1);
                }
                ((ItemStack)this.inventory.get(3)).func_190918_g(1);
                if (((ItemStack)this.inventory.get(3)).func_190916_E() <= 0) {
                    this.inventory.set(3, (Object)ItemStack.field_190927_a);
                }
            }
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            if (((ItemStack)this.inventory.get(0)).func_190916_E() <= 0) {
                this.inventory.set(0, (Object)ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot != 2 && (slot == 1 ? TileEntityFurnace.func_145954_b((ItemStack)itemstack) : slot != 3 || TileEntityBLFurnace.isItemFlux(itemstack));
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing direction) {
        return this.func_94041_b(slot, itemstack);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || slot != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
    }
}

