/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import thebetweenlands.common.registries.BlockRegistry;

public class FluidRegistry {
    public static final FluidMultipleBlocks SWAMP_WATER = (FluidMultipleBlocks)new FluidMultipleBlocks("swamp_water", new ResourceLocation("thebetweenlands:fluids/swamp_water_still"), new ResourceLocation("thebetweenlands:fluids/swamp_water_flowing")).setDensity(1000).setViscosity(1000);
    public static final Fluid STAGNANT_WATER = new Fluid("stagnant_water", new ResourceLocation("thebetweenlands:fluids/stagnant_water_still"), new ResourceLocation("thebetweenlands:fluids/stagnant_water_flowing")).setDensity(1000).setViscosity(1000);
    public static final Fluid TAR = new Fluid("tar", new ResourceLocation("thebetweenlands:fluids/tar_still"), new ResourceLocation("thebetweenlands:fluids/tar_flowing")).setDensity(2000).setViscosity(2000).setTemperature(330);
    public static final Fluid RUBBER = new Fluid("rubber", new ResourceLocation("thebetweenlands:fluids/rubber_still"), new ResourceLocation("thebetweenlands:fluids/rubber_flowing")).setDensity(1200).setViscosity(1500);
    public static final List<Fluid> REGISTERED_FLUIDS = new ArrayList<Fluid>();

    private FluidRegistry() {
    }

    public static void preInit() {
        try {
            for (Field f : FluidRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Fluid)) continue;
                Fluid fluid = (Fluid)obj;
                net.minecraftforge.fluids.FluidRegistry.registerFluid((Fluid)fluid);
                net.minecraftforge.fluids.FluidRegistry.addBucketForFluid((Fluid)fluid);
                REGISTERED_FLUIDS.add((Fluid)obj);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void init() {
        SWAMP_WATER.setOriginalBlock(BlockRegistry.SWAMP_WATER);
    }

    public static class FluidMultipleBlocks
    extends Fluid {
        public FluidMultipleBlocks(String fluidName, ResourceLocation still, ResourceLocation flowing) {
            super(fluidName, still, flowing);
        }

        public Fluid setBlock(Block block) {
            return this;
        }

        public Fluid setOriginalBlock(Block block) {
            this.block = block;
            return this;
        }
    }
}

