/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thebetweenlands.api.recipes.ICompostBinRecipe;

public class CompostRecipe
implements ICompostBinRecipe {
    public static final List<ICompostBinRecipe> RECIPES = new ArrayList<ICompostBinRecipe>();
    private ItemStack input;
    private int compostAmount;
    private int compostTime;

    public CompostRecipe(int compostAmount, int compostTime, ItemStack input) {
        this.compostAmount = compostAmount;
        this.compostTime = compostTime;
        this.input = input;
    }

    public CompostRecipe(int compostAmount, int compostTime, Item input) {
        this.compostAmount = compostAmount;
        this.compostTime = compostTime;
        this.input = new ItemStack(input, 1, Short.MAX_VALUE);
    }

    public static void addRecipe(ICompostBinRecipe recipe) {
        RECIPES.add(recipe);
    }

    public static void addRecipe(int compostAmount, int compostTime, ItemStack stack) {
        RECIPES.add(new CompostRecipe(compostAmount, compostTime, stack));
    }

    public static void addRecipe(int compostAmount, int compostTime, Item compostItem) {
        RECIPES.add(new CompostRecipe(compostAmount, compostTime, compostItem));
    }

    public static void removeRecipe(ICompostBinRecipe recipe) {
        RECIPES.remove(recipe);
    }

    public static Item getItem(Block block) {
        return Item.func_150898_a((Block)block);
    }

    public static ICompostBinRecipe getCompostRecipe(ItemStack stack) {
        for (ICompostBinRecipe compostRecipe : RECIPES) {
            if (!compostRecipe.matchesInput(stack)) continue;
            return compostRecipe;
        }
        return null;
    }

    @Override
    public boolean matchesInput(ItemStack stack) {
        return this.input.func_77952_i() == Short.MAX_VALUE ? this.input.func_77973_b() == stack.func_77973_b() : this.input.func_77973_b() == stack.func_77973_b() && this.input.func_77952_i() == stack.func_77952_i();
    }

    @Override
    public int getCompostAmount(ItemStack stack) {
        return this.compostAmount;
    }

    @Override
    public int getCompostingTime(ItemStack stack) {
        return this.compostTime;
    }

    public ItemStack getInput() {
        return this.input;
    }
}

