/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Random;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;

public class LootConditionSharedPool
implements LootCondition {
    private final LootCondition[] conditions;

    public LootConditionSharedPool(LootCondition[] conditions) {
        this.conditions = conditions;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        return !LootConditionManager.func_186638_a((LootCondition[])this.conditions, (Random)rand, (LootContext)context);
    }

    public static boolean isSharedPool(Random rand, LootContext context, List<LootCondition> conditions) {
        for (LootCondition condition : conditions) {
            if (!(condition instanceof LootConditionSharedPool) || !LootConditionManager.func_186638_a((LootCondition[])((LootConditionSharedPool)condition).conditions, (Random)rand, (LootContext)context)) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<LootConditionSharedPool> {
        public Serializer() {
            super(new ResourceLocation("thebetweenlands", "shared_pool"), LootConditionSharedPool.class);
        }

        public void serialize(JsonObject json, LootConditionSharedPool value, JsonSerializationContext context) {
            if (value.conditions.length > 0) {
                json.add("conditions", context.serialize((Object)value.conditions));
            }
        }

        public LootConditionSharedPool deserialize(JsonObject json, JsonDeserializationContext context) {
            LootCondition[] conditions = json.has("conditions") ? (LootCondition[])JsonUtils.func_188174_a((JsonObject)json, (String)"conditions", (JsonDeserializationContext)context, LootCondition[].class) : new LootCondition[]{};
            return new LootConditionSharedPool(conditions);
        }
    }
}

