/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.shields;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.item.tools.ItemBLShield;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;

public class ItemSwatShield
extends ItemBLShield {
    public ItemSwatShield(Item.ToolMaterial material) {
        super(material);
        this.func_185043_a(new ResourceLocation("charging"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack && (ItemSwatShield.this.getRemainingChargeTicks(stack, entityIn) > 0 || ItemSwatShield.this.isPreparingCharge(stack, entityIn)) ? 1.0f : 0.0f;
            }
        });
    }

    public void setPreparingCharge(ItemStack stack, EntityLivingBase user, boolean charging) {
        user.getEntityData().func_74757_a("thebetweenlands.shield.charging", charging);
    }

    public boolean isPreparingCharge(ItemStack stack, EntityLivingBase user) {
        return user.getEntityData().func_74767_n("thebetweenlands.shield.charging");
    }

    public void setPreparingChargeTicks(ItemStack stack, EntityLivingBase user, int ticks) {
        user.getEntityData().func_74768_a("thebetweenlands.shield.chargingTicks", ticks);
    }

    public int getPreparingChargeTicks(ItemStack stack, EntityLivingBase user) {
        return user.getEntityData().func_74762_e("thebetweenlands.shield.chargingTicks");
    }

    public void setRemainingChargeTicks(ItemStack stack, EntityLivingBase user, int ticks) {
        user.getEntityData().func_74768_a("thebetweenlands.shield.remainingRunningTicks", ticks);
    }

    public int getRemainingChargeTicks(ItemStack stack, EntityLivingBase user) {
        return user.getEntityData().func_74762_e("thebetweenlands.shield.remainingRunningTicks");
    }

    public int getChargeTime(ItemStack stack, EntityLivingBase user, int preparingTicks) {
        float strength = MathHelper.func_76131_a((float)((float)this.getPreparingChargeTicks(stack, user) / 20.0f - 0.2f), (float)0.0f, (float)1.0f);
        return (int)(strength * strength * (float)this.getMaxChargeTime(stack, user));
    }

    public int getMaxChargeTime(ItemStack stack, EntityLivingBase user) {
        return 80;
    }

    public void onEnemyRammed(ItemStack stack, EntityLivingBase user, EntityLivingBase enemy, Vec3d rammingDir) {
        enemy.func_70653_a((Entity)user, 6.0f, -rammingDir.field_72450_a, -rammingDir.field_72449_c);
        if (user instanceof EntityPlayer) {
            enemy.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)user)), 10.0f);
            if (user instanceof EntityPlayerMP) {
                AdvancementCriterionRegistry.SWAT_SHIELD.trigger((EntityPlayerMP)user, enemy);
            }
        } else {
            enemy.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)user), 10.0f);
        }
    }

    public void onChargingUpdate(ItemStack stack, EntityLivingBase user) {
        if (user.field_70122_E && !user.func_70093_af()) {
            Vec3d dir = user.func_70040_Z();
            dir = new Vec3d(dir.field_72450_a, 0.0, dir.field_72449_c).func_72432_b();
            user.field_70159_w += dir.field_72450_a * 0.35;
            user.field_70179_y += dir.field_72449_c * 0.35;
            if (user instanceof EntityPlayer) {
                ((EntityPlayer)user).func_71024_bL().func_75113_a(0.15f);
            }
        }
        if (Math.sqrt(user.field_70159_w * user.field_70159_w + user.field_70179_y * user.field_70179_y) > 0.2) {
            Vec3d moveDir = new Vec3d(user.field_70159_w, user.field_70181_x, user.field_70179_y).func_72432_b();
            List targets = user.field_70170_p.func_175647_a(EntityLivingBase.class, user.func_174813_aQ().func_186662_g(1.0), e -> e != user);
            for (EntityLivingBase target : targets) {
                this.onEnemyRammed(stack, user, target, moveDir);
            }
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        boolean preparing = this.isPreparingCharge(stack, user);
        int runningTicks = this.getRemainingChargeTicks(stack, user);
        if (preparing && runningTicks <= 0) {
            this.setPreparingChargeTicks(stack, user, this.getPreparingChargeTicks(stack, user) + 1);
        }
        if (preparing && !user.func_70093_af() && runningTicks <= 0) {
            this.setRemainingChargeTicks(stack, user, this.getChargeTime(stack, user, this.getPreparingChargeTicks(stack, user)));
            this.setPreparingChargeTicks(stack, user, 0);
            this.setPreparingCharge(stack, user, false);
        } else if (!preparing && user.func_70093_af()) {
            this.setRemainingChargeTicks(stack, user, 0);
            this.setPreparingChargeTicks(stack, user, 0);
            this.setPreparingCharge(stack, user, true);
        }
        if (runningTicks > 0) {
            this.onChargingUpdate(stack, user);
            this.setRemainingChargeTicks(stack, user, --runningTicks);
            if (runningTicks == 0) {
                user.func_184597_cx();
            }
        }
        super.onUsingTick(stack, user, count);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
        this.setPreparingChargeTicks(stack, entityLiving, 0);
        this.setRemainingChargeTicks(stack, entityLiving, 0);
        this.setPreparingCharge(stack, entityLiving, false);
        if (entityLiving instanceof EntityPlayerMP) {
            AdvancementCriterionRegistry.SWAT_SHIELD.revert((EntityPlayerMP)entityLiving);
        }
    }

    @Override
    public boolean canBlockDamageSource(ItemStack stack, EntityLivingBase attacked, EnumHand hand, DamageSource source) {
        if (this.getRemainingChargeTicks(stack, attacked) > 0 && source.func_76364_f() != null) {
            return true;
        }
        return super.canBlockDamageSource(stack, attacked, hand, source);
    }

    @Override
    public float getBlockedDamage(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        if (this.getRemainingChargeTicks(stack, attacked) > 0) {
            return 0.0f;
        }
        return super.getBlockedDamage(stack, attacked, damage, source);
    }

    @Override
    public float getDefenderKnockbackMultiplier(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        if (this.getRemainingChargeTicks(stack, attacked) > 0) {
            return 0.0f;
        }
        return super.getDefenderKnockbackMultiplier(stack, attacked, damage, source);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onUpdateFov(FOVUpdateEvent event) {
        ItemSwatShield swatShield;
        ItemStack activeItem = event.getEntity().func_184607_cu();
        if (!activeItem.func_190926_b() && activeItem.func_77973_b() instanceof ItemSwatShield && (swatShield = (ItemSwatShield)activeItem.func_77973_b()).isPreparingCharge(activeItem, (EntityLivingBase)event.getEntity())) {
            int preparingTicks = swatShield.getPreparingChargeTicks(activeItem, (EntityLivingBase)event.getEntity());
            float progress = Math.min((float)swatShield.getChargeTime(activeItem, (EntityLivingBase)event.getEntity(), preparingTicks) / (float)swatShield.getMaxChargeTime(activeItem, (EntityLivingBase)event.getEntity()), 1.0f);
            event.setNewfov(1.0f - progress * 0.25f);
        }
    }
}

