/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import thebetweenlands.api.aspect.AspectItem;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.herblore.book.Page;
import thebetweenlands.common.herblore.book.widgets.AspectItemSlideShowWidget;
import thebetweenlands.common.herblore.book.widgets.AspectSlideShowWidget;
import thebetweenlands.common.herblore.book.widgets.AspectWidget;
import thebetweenlands.common.herblore.book.widgets.ButtonWidget;
import thebetweenlands.common.herblore.book.widgets.ItemWidget;
import thebetweenlands.common.herblore.book.widgets.ManualWidgetBase;
import thebetweenlands.common.herblore.book.widgets.text.FormatTags;
import thebetweenlands.common.herblore.book.widgets.text.TextContainer;
import thebetweenlands.common.herblore.book.widgets.text.TextWidget;
import thebetweenlands.common.herblore.elixir.ElixirRecipe;
import thebetweenlands.common.herblore.elixir.ElixirRecipes;
import thebetweenlands.common.herblore.elixir.effects.ElixirEffect;
import thebetweenlands.common.recipe.misc.PestleAndMortarRecipe;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.TranslationHelper;

public class PageCreators {
    public static ArrayList<Page> pageCreatorButtons(ArrayList<Page> pages, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        int pageAmount = pages.size();
        int times = 0;
        while (pageAmount > 0) {
            ArrayList<Page> pagesTemp = new ArrayList<Page>();
            pagesTemp.addAll(pages.subList(7 * times, pageAmount > 7 ? 7 + 7 * times : 7 * times + pageAmount));
            int height = 0;
            ArrayList<ButtonWidget> widgets = new ArrayList<ButtonWidget>();
            for (Page page : pagesTemp) {
                widgets.add(new ButtonWidget(15, 10 + height, page));
                height += 20;
            }
            newPages.add(new Page("index" + times, (ArrayList)widgets.clone(), false, manualType));
            widgets.clear();
            pagesTemp.clear();
            pageAmount -= 7;
            ++times;
        }
        return newPages;
    }

    public static ArrayList<Page> TextPages(int x, int y, String unlocalizedName, String pageName, boolean isHidden, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        String text = TranslationHelper.translateToLocal(unlocalizedName, new Object[0]);
        TextContainer textContainer = PageCreators.parseTextContainer(new TextContainer(116.0, 144.0, text, Minecraft.func_71410_x().field_71466_p));
        for (int i = 0; i < textContainer.getPages().size(); ++i) {
            newPages.add(new Page(pageName, isHidden, manualType, new TextWidget(x, y, unlocalizedName, i)));
        }
        return newPages;
    }

    public static ArrayList<Page> AspectPages(IAspectType aspect, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        int height = 0;
        ArrayList<ManualWidgetBase> widgets = new ArrayList<ManualWidgetBase>();
        widgets.add(new AspectWidget(18, 12, aspect, 1.0f));
        widgets.add(new TextWidget(38, 14, "<font:custom>" + aspect.getName() + "</font>", true));
        widgets.add(new TextWidget(18, 12 + (height += 24), "manual." + aspect.getName().toLowerCase() + ".description"));
        TextContainer textContainer = PageCreators.parseTextContainer(new TextContainer(112.0, 144.0, TranslationHelper.translateToLocal("manual." + aspect.getName().toLowerCase() + ".description", new Object[0]), Minecraft.func_71410_x().field_71466_p));
        height = (int)((double)height + (textContainer.getPages().get((int)0).getSegments().get((int)(textContainer.getPages().get((int)0).getSegments().size() - 1)).y + 18.0));
        if (height + 18 + 16 < 152) {
            widgets.add(new TextWidget(18, 12 + height, "manual.aspect.found.in"));
            widgets.add(new AspectItemSlideShowWidget(18, 12 + (height += 16), aspect));
            height += 18;
        } else {
            newPages.add(new Page(aspect.getName().toLowerCase(), widgets, false, manualType).setParent().setAspect(aspect).setLocalizedPageName(aspect.getName()));
            widgets.add(new TextWidget(18, 12 + height, "manual.aspect.found.in"));
            widgets.add(new AspectItemSlideShowWidget(18, 12 + (height += 16), aspect));
            height += 18;
        }
        if (height + 10 + 18 < 152) {
            widgets.add(new TextWidget(18, 12 + height, "manual.aspect.used.in"));
            height += 10;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ElixirRecipe recipe : ElixirRecipes.getFromAspect(aspect)) {
                items.add(ItemRegistry.ELIXIR.getElixirItem(recipe.positiveElixir, recipe.baseDuration, 1, 0));
                items.add(ItemRegistry.ELIXIR.getElixirItem(recipe.negativeElixir, recipe.baseDuration, 1, 1));
            }
            widgets.add(new AspectItemSlideShowWidget(18, 12 + height, items));
            height += 18;
        } else {
            if (newPages.size() > 0) {
                newPages.add(new Page(aspect.getName().toLowerCase(), widgets, false, manualType).setAspect(aspect).setLocalizedPageName(aspect.getName()));
            } else {
                newPages.add(new Page(aspect.getName().toLowerCase(), widgets, false, manualType).setParent().setAspect(aspect).setLocalizedPageName(aspect.getName()));
            }
            widgets.add(new TextWidget(18, 12 + height, "manual.aspect.used.in"));
            height += 10;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ElixirRecipe recipe : ElixirRecipes.getFromAspect(aspect)) {
                items.add(ItemRegistry.ELIXIR.getElixirItem(recipe.positiveElixir, recipe.baseDuration, 1, 0));
                items.add(ItemRegistry.ELIXIR.getElixirItem(recipe.negativeElixir, recipe.baseDuration, 1, 1));
            }
            widgets.add(new AspectItemSlideShowWidget(18, 12 + height, items));
            height += 18;
        }
        if (widgets.size() > 0) {
            if (newPages.size() > 0) {
                newPages.add(new Page(aspect.getName().toLowerCase(), widgets, false, manualType).setAspect(aspect).setLocalizedPageName(aspect.getName()));
            } else {
                newPages.add(new Page(aspect.getName().toLowerCase(), widgets, false, manualType).setParent().setAspect(aspect).setLocalizedPageName(aspect.getName()));
            }
        }
        return newPages;
    }

    public static List<Page> AspectItemPages(AspectItem item, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        int height = 0;
        ItemStack itemStack = item.getOriginal();
        ItemStack pestleAndMortarInput = PestleAndMortarRecipe.getInput(itemStack);
        ArrayList<ManualWidgetBase> widgets = new ArrayList<ManualWidgetBase>();
        widgets.add(new ItemWidget(18, 12, itemStack, 1.0f));
        if (!pestleAndMortarInput.func_190926_b()) {
            widgets.add(new ItemWidget(118, 12, PageCreators.getStacks(pestleAndMortarInput), 1.0f));
        }
        widgets.add(new TextWidget(38, 16, itemStack.func_82833_r(), true).setWidth(70));
        widgets.add(new TextWidget(18, 12 + (height += 28), "manual." + itemStack.func_77977_a() + ".description"));
        TextContainer textContainer = PageCreators.parseTextContainer(new TextContainer(112.0, 144.0, TranslationHelper.translateToLocal("manual." + itemStack.func_77977_a() + ".description", new Object[0]), Minecraft.func_71410_x().field_71466_p));
        height = (int)((double)height + (18.0 + textContainer.getPages().get((int)0).getSegments().get((int)(textContainer.getPages().get((int)0).getSegments().size() - 1)).y));
        widgets.add(new TextWidget(18, 12 + height, "manual.has.aspects"));
        widgets.add(new AspectSlideShowWidget(18, 12 + (height += 18), itemStack));
        Page itemPage = new Page(itemStack.func_77977_a().toLowerCase().replace(" ", ""), widgets, true, manualType).setParent().addItem(itemStack).setLocalizedPageName(itemStack.func_82833_r());
        if (!pestleAndMortarInput.func_190926_b()) {
            itemPage.addItems(PageCreators.getStacks(pestleAndMortarInput));
        }
        newPages.add(itemPage);
        return newPages;
    }

    private static List<ItemStack> getStacks(ItemStack input) {
        NonNullList stacks = NonNullList.func_191196_a();
        if (input != null && !input.func_190926_b() && input.func_77960_j() == Short.MAX_VALUE) {
            NonNullList list = NonNullList.func_191196_a();
            input.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, list);
            stacks.addAll(list);
        } else {
            stacks.add(input);
        }
        return stacks;
    }

    public static ArrayList<Page> elixirPages(ItemStack item, Item manualType, ElixirEffect effect) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        int height = 0;
        ArrayList<ManualWidgetBase> widgets = new ArrayList<ManualWidgetBase>();
        widgets.add(new ItemWidget(18, 12, item, 1.0f));
        widgets.add(new TextWidget(38, 14, item.func_82833_r(), true));
        height += 32;
        TextContainer textContainer = new TextContainer(115.0, 130.0, TranslationHelper.translateToLocal("manual." + item.func_77977_a() + ".description", new Object[0]), Minecraft.func_71410_x().field_71466_p);
        textContainer = PageCreators.parseTextContainer(textContainer);
        Page temp = null;
        if (textContainer.getPages().size() > 1) {
            widgets.add(new TextWidget(15, height, "manual." + item.func_77977_a() + ".description", 0, 115, 130));
            newPages.add(new Page(item.func_77977_a().toLowerCase().replace(" ", ""), (ArrayList)widgets.clone(), false, manualType).setParent().setLocalizedPageName(item.func_82833_r()).addItem(item));
            widgets.clear();
            widgets.add(new TextWidget(15, 14, "manual." + item.func_77977_a() + ".description", 1, 115, 130));
            if (ElixirRecipes.getFromEffect(effect) != null && ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects != null) {
                if (textContainer.getPages().get((int)1).getSegments().get((int)(textContainer.getPages().get((int)1).getSegments().size() - 1)).y + 38.0 < 142.0) {
                    widgets.add(new AspectSlideShowWidget(18, (int)(textContainer.getPages().get((int)1).getSegments().get((int)(textContainer.getPages().get((int)1).getSegments().size() - 1)).y + 22.0), ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects));
                } else {
                    temp = new Page(item.func_77977_a().toLowerCase().replace(" ", ""), false, manualType, new AspectSlideShowWidget(15, 12, ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects));
                }
            }
            newPages.add(new Page(item.func_77977_a().toLowerCase().replace(" ", ""), widgets, false, manualType).setLocalizedPageName(item.func_82833_r()).addItem(item));
            if (temp != null) {
                newPages.add(temp);
            }
        } else {
            widgets.add(new TextWidget(15, height, "manual." + item.func_77977_a() + ".description", 0, 115, 1130));
            if (ElixirRecipes.getFromEffect(effect) != null && ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects != null) {
                if (height + 24 < 142) {
                    widgets.add(new AspectSlideShowWidget(18, height + (int)(textContainer.getPages().get((int)0).getSegments().get((int)(textContainer.getPages().get((int)0).getSegments().size() - 1)).y + 8.0), ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects));
                } else {
                    temp = new Page(item.func_77977_a().toLowerCase().replace(" ", ""), false, manualType, new AspectSlideShowWidget(15, 12, ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects));
                }
            }
            newPages.add(new Page(item.func_77977_a().toLowerCase().replace(" ", ""), widgets, false, manualType).setParent().setLocalizedPageName(item.func_82833_r()).addItem(item));
            if (temp != null) {
                newPages.add(temp);
            }
        }
        return newPages;
    }

    private static TextContainer parseTextContainer(TextContainer textContainer) {
        textContainer.setCurrentScale(1.0f).setCurrentColor(0x808080);
        textContainer.registerTag(new FormatTags.TagNewLine());
        textContainer.registerTag(new FormatTags.TagScale(1.0f));
        textContainer.registerTag(new FormatTags.TagColor(0x808080));
        textContainer.registerTag(new FormatTags.TagTooltip("N/A"));
        textContainer.registerTag(new FormatTags.TagSimple("bold", TextFormatting.BOLD));
        textContainer.registerTag(new FormatTags.TagSimple("obfuscated", TextFormatting.OBFUSCATED));
        textContainer.registerTag(new FormatTags.TagSimple("italic", TextFormatting.ITALIC));
        textContainer.registerTag(new FormatTags.TagSimple("strikethrough", TextFormatting.STRIKETHROUGH));
        textContainer.registerTag(new FormatTags.TagSimple("underline", TextFormatting.UNDERLINE));
        textContainer.registerTag(new FormatTags.TagPagelink());
        textContainer.registerTag(new FormatTags.TagRainbow());
        try {
            textContainer.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return textContainer;
    }
}

