/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.item.IDecayFood;
import thebetweenlands.common.capability.decay.DecayStats;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.GameruleRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class PlayerDecayHandler {
    public static boolean isDecayEnabled() {
        return GameruleRegistry.getGameRuleBooleanValue("blDecay") && BetweenlandsConfig.GENERAL.useDecay;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START && player.hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) {
            IDecayCapability capability = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
            DecayStats stats = capability.getDecayStats();
            IAttributeInstance attr = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (attr != null) {
                int prevDecayMaxHealth;
                int currentMaxHealth = (int)attr.func_111125_b();
                int decayMaxHealth = (int)(capability.getMaxPlayerHealth(stats.getDecayLevel()) / 2.0f) * 2;
                int healthDiff = decayMaxHealth - (prevDecayMaxHealth = (int)(capability.getMaxPlayerHealth(stats.getPrevDecayLevel()) / 2.0f) * 2);
                if (healthDiff != 0) {
                    int newHealth = Math.max(currentMaxHealth + healthDiff, 6);
                    healthDiff = newHealth - currentMaxHealth;
                    healthDiff = Math.min(healthDiff, capability.getRemovedHealth());
                    attr.func_111128_a((double)(currentMaxHealth + healthDiff));
                    if ((double)player.func_110143_aJ() > attr.func_111126_e()) {
                        player.func_70606_j((float)attr.func_111126_e());
                    }
                    capability.setRemovedHealth(capability.getRemovedHealth() - healthDiff);
                }
            }
            if (capability.isDecayEnabled()) {
                int decay = stats.getDecayLevel();
                if (decay >= 16) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40, 2, true, false));
                    player.field_70747_aH = 0.001f;
                } else if (decay >= 13) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40, 1, true, false));
                    player.field_70747_aH = 0.002f;
                } else if (decay >= 10) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40, 0, true, false));
                }
                if (!event.player.func_184218_aH()) {
                    EnumDifficulty difficulty = player.field_70170_p.func_175659_aa();
                    float decayBaseSpeed = PlayerDecayHandler.getDecayBaseSpeed(difficulty);
                    float decaySpeed = 0.0f;
                    if (player.field_70140_Q - player.field_70141_P > 0.0f) {
                        decaySpeed += (player.field_70140_Q - player.field_70141_P) * 4.0f * decayBaseSpeed;
                    }
                    BetweenlandsWorldStorage storage = BetweenlandsWorldStorage.forWorld(player.field_70170_p);
                    if (storage.getEnvironmentEventRegistry().heavyRain.isActive() && player.field_70170_p.func_175678_i(player.func_180425_c())) {
                        decaySpeed += decayBaseSpeed;
                    }
                    if (player.func_70090_H()) {
                        decaySpeed += decayBaseSpeed * 2.75f;
                    }
                    if (decaySpeed > 0.0f) {
                        stats.addDecayAcceleration(decaySpeed);
                    }
                }
            }
            if (PlayerDecayHandler.isDecayEnabled()) {
                stats.onUpdate(player);
            } else {
                stats.setDecayLevel(0);
                stats.setDecaySaturationLevel(1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        EntityPlayer player;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) {
            IDecayCapability capability = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
            float decayBaseSpeed = PlayerDecayHandler.getDecayBaseSpeed(player.field_70170_p.func_175659_aa());
            capability.getDecayStats().addDecayAcceleration(decayBaseSpeed * 60.0f);
        }
    }

    public static float getDecayBaseSpeed(EnumDifficulty difficulty) {
        switch (difficulty) {
            case PEACEFUL: {
                return 0.0f;
            }
            case EASY: {
                return 0.0025f;
            }
            default: {
                return 0.0033f;
            }
            case HARD: 
        }
        return 0.005f;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP && player.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityProperties(player.func_145782_y(), (Collection)ImmutableList.of((Object)player.func_110148_a(SharedMonsterAttributes.field_111267_a))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onUseItemTick(LivingEntityUseItemEvent.Tick event) {
        EntityPlayer player;
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && event.getDuration() <= 1 && !event.getItem().func_190926_b() && event.getItem().func_77973_b() instanceof IDecayFood && event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) {
            IDecayCapability capability = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
            IDecayFood food = (IDecayFood)event.getItem().func_77973_b();
            capability.getDecayStats().addStats(-food.getDecayHealAmount(event.getItem()), food.getDecayHealSaturation(event.getItem()));
        }
    }

    @SubscribeEvent
    public static void onStartUsingItem(LivingEntityUseItemEvent.Start event) {
        if (!event.getItem().func_190926_b() && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            boolean isDecayFood = event.getItem().func_77973_b() instanceof IDecayFood;
            if (isDecayFood) {
                boolean canEatFood = player.func_71024_bL().func_75121_c() && event.getItem().func_77973_b() instanceof ItemFood && ((ItemFood)event.getItem().func_77973_b()).func_150905_g(event.getItem()) > 0;
                boolean canEatDecayFood = false;
                if (player.hasCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) {
                    IDecayCapability capability = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
                    boolean bl = canEatDecayFood = capability.getDecayStats().getDecayLevel() > 0;
                }
                if (!canEatFood && !canEatDecayFood) {
                    event.setDuration(-1);
                    event.setCanceled(true);
                }
            }
        }
    }
}

