/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.rowboat;

import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.rowboat.ShipSide;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.network.serverbound.MessageRow;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.CubicBezier;
import thebetweenlands.util.Mat4d;
import thebetweenlands.util.MathUtils;
import thebetweenlands.util.Matrix;
import thebetweenlands.util.OpenSimplexNoise;
import thebetweenlands.util.Quat;

public class EntityWeedwoodRowboat
extends EntityBoat
implements IEntityAdditionalSpawnData {
    private static final CubicBezier DEVIATION_DRAG = new CubicBezier(0.9f, 0.0f, 1.0f, 0.6f);
    private static final CubicBezier SPEED_WAVE_POWER = new CubicBezier(0.0f, 1.0f, 0.0f, 1.0f);
    private static final EnumMap<ShipSide, DataParameter<Float>> ROW_PROGRESS = ShipSide.newEnumMap(DataParameter.class, EntityWeedwoodRowboat.defineId(DataSerializers.field_187193_c), EntityWeedwoodRowboat.defineId(DataSerializers.field_187193_c));
    private static final DataParameter<Boolean> IS_TARRED = EntityWeedwoodRowboat.defineId(DataSerializers.field_187198_h);
    public static final float OAR_ROTATION_SCALE = -28.0f;
    public static final float ROW_PROGRESS_PERIOD = (float)Math.PI * 2 / Math.abs(-28.0f);
    private static final float OAR_LENGTH = 2.5f;
    private static final float BLADE_LENGTH = 0.75f;
    private static final float LOOM_LENGTH = 1.75f;
    private static final float RESTING_ROW_PROGRESS = ROW_PROGRESS_PERIOD * 0.05f;
    private static final int FORCE_SETTLE_DURATION = 10;
    private static final Quat UP = Quat.fromAxisAngle(0.0, 1.0, 0.0, 0.0);
    private static final OpenSimplexNoise WAVE_RNG = new OpenSimplexNoise(6354L);
    private static final EnumMap<ShipSide, SoundEvent> SOUND_ROW = ShipSide.newEnumMap(SoundEvent.class, new SoundEvent[]{SoundRegistry.ROWBOAT_ROW_STARBOARD, SoundRegistry.ROWBOAT_ROW_PORT});
    private static final EnumMap<ShipSide, SoundEvent> SOUND_ROW_START = ShipSide.newEnumMap(SoundEvent.class, new SoundEvent[]{SoundRegistry.ROWBOAT_ROW_START_STARBOARD, SoundRegistry.ROWBOAT_ROW_START_PORT});
    private EnumMap<ShipSide, Float> rowForce = ShipSide.newEnumMap(Float.TYPE, new Float[0]);
    private EnumMap<ShipSide, Integer> rowTime = ShipSide.newEnumMap(Integer.TYPE, 10, 10);
    private EnumMap<ShipSide, Float> prevRowProgress = ShipSide.newEnumMap(Float.TYPE, Float.valueOf(RESTING_ROW_PROGRESS), Float.valueOf(RESTING_ROW_PROGRESS));
    private EnumMap<ShipSide, Float> rowProgress = ShipSide.newEnumMap(Float.TYPE, Float.valueOf(RESTING_ROW_PROGRESS), Float.valueOf(RESTING_ROW_PROGRESS));
    private EnumMap<ShipSide, Boolean> oarState = ShipSide.newEnumMap(Boolean.TYPE, new Boolean[0]);
    private EnumMap<ShipSide, Boolean> oarInAir = ShipSide.newEnumMap(Boolean.TYPE, new Boolean[0]);
    private EnumMap<ShipSide, Float> prevOarXWavePull = ShipSide.newEnumMap(Float.TYPE, new Float[0]);
    private EnumMap<ShipSide, Float> prevOarZWavePull = ShipSide.newEnumMap(Float.TYPE, new Float[0]);
    private EnumMap<ShipSide, Float> oarXWavePull = ShipSide.newEnumMap(Float.TYPE, new Float[0]);
    private EnumMap<ShipSide, Float> oarZWavePull = ShipSide.newEnumMap(Float.TYPE, new Float[0]);
    private float drag;
    private float submergeTicks;
    private int inWaterTicks;
    private float rotationalVelocity;
    private double serverX;
    private double serverY;
    private double serverZ;
    private float boatYaw;
    private float boatPitch;
    private int serverT;
    private boolean prevOarStrokeLeft;
    private boolean prevOarStrokeRight;
    private ShipSide synchronizer = ShipSide.STARBOARD;
    private Quat prevRotation = Quat.fromAxisAngle(0.0, 1.0, 0.0, 0.0);
    private Quat rotation = new Quat(this.prevRotation);
    private double prevWaveHeight;
    private double waveHeight;
    private float prevPilotPower;
    private float pilotPower;

    public EntityWeedwoodRowboat(World world) {
        super(world);
        this.func_70105_a(2.0f, 0.9f);
    }

    public EntityWeedwoodRowboat(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ROW_PROGRESS.get((Object)ShipSide.STARBOARD), (Object)Float.valueOf(RESTING_ROW_PROGRESS));
        this.field_70180_af.func_187214_a(ROW_PROGRESS.get((Object)ShipSide.PORT), (Object)Float.valueOf(RESTING_ROW_PROGRESS));
        this.field_70180_af.func_187214_a(IS_TARRED, (Object)false);
    }

    public double func_70042_X() {
        return this.getWaveHeight(1.0f);
    }

    public Item func_184455_j() {
        return ItemRegistry.WEEDWOOD_ROWBOAT;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.getItem();
    }

    public ItemStack getItem() {
        ItemStack stack = new ItemStack(this.func_184455_j());
        NBTTagCompound attrs = new NBTTagCompound();
        this.func_70014_b(attrs);
        if (attrs.func_186856_d() > 0) {
            stack.func_77983_a("attributes", (NBTBase)attrs);
        }
        return stack;
    }

    public void setIsTarred(boolean isTarred) {
        this.field_70180_af.func_187227_b(IS_TARRED, (Object)isTarred);
    }

    public boolean isTarred() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_TARRED);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184442_a(boolean starboard, boolean port, boolean forward, boolean backward) {
        this.oarState.put(ShipSide.STARBOARD, starboard);
        this.oarState.put(ShipSide.PORT, port);
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int t, boolean teleport) {
        this.serverX = x;
        this.serverY = y;
        this.serverZ = z;
        this.boatYaw = yaw;
        this.boatPitch = pitch;
        this.serverT = 10;
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.field_70165_t = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        this.field_70163_u = y;
        this.field_70161_v = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        pitch = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f);
        this.field_70177_z = yaw;
        this.field_70125_A = pitch;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        double delta = this.field_70126_B - yaw;
        if (delta < -180.0) {
            this.field_70126_B += 360.0f;
        }
        if (delta >= 180.0) {
            this.field_70126_B -= 360.0f;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_70101_b(yaw, pitch);
    }

    public void setOarStates(boolean starboard, boolean port, float progressStarboard, float progressPort) {
        this.func_184445_a(port, starboard);
        this.setRowProgress(ShipSide.STARBOARD, progressStarboard);
        this.setRowProgress(ShipSide.PORT, progressPort);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().isEmpty();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean creative;
            if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(10);
            this.func_70266_a(this.func_70271_g() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = creative = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (creative || this.func_70271_g() > 20.0f) {
                if (!creative && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.func_70099_a(this.getItem(), 0.0f);
                }
                this.func_70106_y();
            }
        }
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemMisc.EnumItemMisc.TAR_DRIP.isItemOf(stack) && !this.isTarred()) {
            if (!this.field_70170_p.field_72995_K) {
                this.setIsTarred(true);
                stack.func_190918_g(1);
                this.func_184185_a(SoundRegistry.TAR_BEAST_STEP, 0.9f + this.field_70146_Z.nextFloat() * 0.1f, 0.6f + this.field_70146_Z.nextFloat() * 0.15f);
            }
        } else if (!this.field_70170_p.field_72995_K && !player.func_70093_af()) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    protected void func_184231_a(double y, boolean onGround, IBlockState state, BlockPos pos) {
        if (onGround) {
            if (this.field_70143_R > 0.0f) {
                state.func_177230_c().func_180658_a(this.field_70170_p, pos, (Entity)this, this.field_70143_R);
            }
            this.field_70143_R = 0.0f;
        } else if (y < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - y);
        }
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.field_70170_p.field_72995_K && this.func_184179_bs() == passenger) {
            TheBetweenlands.proxy.onPilotEnterWeedwoodRowboat(passenger);
        }
    }

    protected void func_184225_p(Entity passenger) {
        if (this.field_70170_p.field_72995_K && this.func_184179_bs() == passenger) {
            TheBetweenlands.proxy.onPilotExitWeedwoodRowboat(this, passenger);
        }
        super.func_184225_p(passenger);
    }

    public void func_70071_h_() {
        double pow = 1.0f - SPEED_WAVE_POWER.eval(MathHelper.func_76133_a((double)((this.field_70165_t - this.field_70169_q) * (this.field_70165_t - this.field_70169_q) + (this.field_70161_v - this.field_70166_s) * (this.field_70161_v - this.field_70166_s))));
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.func_70268_h() > 0) {
            this.func_70265_b(this.func_70268_h() - 1);
        }
        if (this.func_70271_g() > 0.0f) {
            this.func_70266_a(this.func_70271_g() - 1.0f);
        }
        this.tickLerp();
        if (this.field_70170_p.field_72995_K) {
            this.updateClientOarProgress(ShipSide.STARBOARD);
            this.updateClientOarProgress(ShipSide.PORT);
        }
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().size() == 0 || !(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
                this.func_184445_a(false, false);
            }
            this.applyForces();
        }
        boolean left = this.getAppropriateOarState(ShipSide.STARBOARD);
        boolean right = this.getAppropriateOarState(ShipSide.PORT);
        this.updateRowForce(ShipSide.STARBOARD, left, this.prevOarStrokeLeft);
        this.updateRowForce(ShipSide.PORT, right, this.prevOarStrokeRight);
        this.updatePilotPull();
        this.prevOarStrokeLeft = left;
        this.prevOarStrokeRight = right;
        this.prevRotation = new Quat(this.rotation);
        this.prevWaveHeight = this.waveHeight;
        this.prevOarXWavePull.put(ShipSide.STARBOARD, this.oarXWavePull.get((Object)ShipSide.STARBOARD));
        this.prevOarXWavePull.put(ShipSide.PORT, this.oarXWavePull.get((Object)ShipSide.PORT));
        this.prevOarZWavePull.put(ShipSide.STARBOARD, this.oarZWavePull.get((Object)ShipSide.STARBOARD));
        this.prevOarZWavePull.put(ShipSide.PORT, this.oarZWavePull.get((Object)ShipSide.PORT));
        if (this.field_70171_ac) {
            this.hitWaves(pow);
            ++this.inWaterTicks;
        } else {
            this.rotation.interpolate(UP, 0.175);
            this.waveHeight -= this.waveHeight * (double)0.6f;
            if (this.waveHeight < (double)0.001f) {
                this.waveHeight = 0.0;
            }
            this.inWaterTicks = 0;
        }
        if (this.func_184186_bw()) {
            Vec3d motion = null;
            if (this.field_70170_p.field_72995_K) {
                motion = this.applyRowForce();
            }
            this.field_70177_z += this.rotationalVelocity;
            if (this.field_70170_p.field_72995_K) {
                if (motion != null) {
                    this.updateMotion(motion);
                }
                TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageRow(this.oarState.get((Object)ShipSide.STARBOARD), this.oarState.get((Object)ShipSide.PORT), this.rowProgress.get((Object)ShipSide.STARBOARD).floatValue(), this.rowProgress.get((Object)ShipSide.PORT).floatValue()));
            }
            float rotationLeft = this.getAppropriateRowProgress(ShipSide.STARBOARD);
            float rotationRight = this.getAppropriateRowProgress(ShipSide.PORT);
            this.returnOarToResting(ShipSide.STARBOARD, rotationLeft);
            this.returnOarToResting(ShipSide.PORT, rotationRight);
            this.synchronizeOars();
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        this.func_145775_I();
        if (this.field_70171_ac) {
            if (this.field_70170_p.field_72995_K) {
                this.animateHullWaterInteraction();
                this.animateOars();
            } else {
                this.createSoundFX();
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(0.2, 0.05, 0.2)).forEach(arg_0 -> ((EntityWeedwoodRowboat)this).func_70108_f(arg_0));
        }
        this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
        this.field_70126_B = MathUtils.adjustAngleForInterpolation(this.field_70177_z, this.field_70126_B);
    }

    private void hitWaves(double pow) {
        double wz;
        double wx;
        double mag;
        double strength;
        double t = (double)this.field_70170_p.func_82737_E() * 0.03;
        double roughness = 0.15 * pow * (this.inWaterTicks < 20 ? (double)this.inWaterTicks / 20.0 : 1.0);
        double scale = 0.5;
        double x = this.field_70165_t;
        double z = this.field_70161_v;
        Matrix mat = new Matrix();
        mat.rotate(this.rotation);
        mat.rotate(-this.field_70177_z * ((float)Math.PI / 180), 0.0, 1.0, 0.0);
        Vec3d posFront = mat.transform(new Vec3d(0.0, 0.0, 0.75));
        Vec3d posStarboard = mat.transform(new Vec3d(0.435, 0.0, -0.5));
        Vec3d posPort = mat.transform(new Vec3d(-0.435, 0.0, 0.5));
        double sx0 = posFront.field_72450_a;
        double sz0 = posFront.field_72449_c;
        double sx1 = posStarboard.field_72450_a;
        double sz1 = posStarboard.field_72449_c;
        double sx2 = posPort.field_72450_a;
        double sz2 = posPort.field_72449_c;
        double sy0 = WAVE_RNG.eval((x + sx0) * scale, t, (z + sz0) * scale) * roughness;
        double sy1 = WAVE_RNG.eval((x + sx1) * scale, t, (z + sz1) * scale) * roughness;
        double sy2 = WAVE_RNG.eval((x + sx2) * scale, t, (z + sz2) * scale) * roughness;
        Vec3d s0 = new Vec3d(sx0 * scale, sy0, sz0 * scale);
        Vec3d s1 = new Vec3d(sx1 * scale, sy1, sz1 * scale);
        Vec3d s2 = new Vec3d(sx2 * scale, sy2, sz2 * scale);
        Vec3d normal = s2.func_178788_d(s1).func_72431_c(s0.func_178788_d(s1)).func_72432_b();
        Vec3d yAxis = new Vec3d(0.0, 1.0, 0.0);
        double angle = Math.acos(Math.max(Math.min(normal.func_72430_b(yAxis), 1.0), -1.0));
        Vec3d axis = normal.func_72431_c(yAxis).func_72432_b();
        Quat wave = Quat.fromAxisAngle(axis.field_72450_a, axis.field_72448_b, axis.field_72449_c, -angle * 0.4);
        this.rotation.interpolate(wave, 0.2);
        Vec3d point = new Vec3d(0.0, roughness, 0.0);
        this.waveHeight = point.func_178788_d((Vec3d)normal.func_186678_a((double)point.func_178788_d((Vec3d)s0).func_72430_b((Vec3d)normal))).field_72448_b;
        this.pullOarByWave(ShipSide.STARBOARD, normal);
        this.pullOarByWave(ShipSide.PORT, normal);
        if (!this.isTarred() && this.func_184186_bw() && (strength = (mag = Math.sqrt((wx = normal.field_72450_a) * wx + (wz = normal.field_72449_c) * wz)) / Math.min((1.0 - normal.field_72448_b) * 1.8 * roughness, 0.00125)) > 0.0) {
            this.field_70159_w += wx / strength;
            this.field_70179_y += wz / strength;
            double dir = Math.atan2(wz, wx) * (double)57.29578f;
            this.rotationalVelocity = (float)((double)this.rotationalVelocity + Math.signum(MathUtils.modularDelta((double)this.field_70177_z, dir - 90.0, 360.0)) * Math.min((1.0 - normal.field_72448_b) * 60.0 * roughness, roughness));
        }
    }

    private void updatePilotPull() {
        this.prevPilotPower = this.pilotPower;
        int timeStarboard = this.rowTime.get((Object)ShipSide.STARBOARD);
        int timePort = this.rowTime.get((Object)ShipSide.PORT);
        if (timeStarboard > 20 && timePort > 20 && this.getAppropriateOarState(ShipSide.STARBOARD) && this.getAppropriateOarState(ShipSide.PORT) && this.getAppropriateRowProgress(ShipSide.STARBOARD) == this.getAppropriateRowProgress(ShipSide.PORT)) {
            if (this.pilotPower < 1.0f) {
                this.pilotPower += 0.2f;
                if (this.pilotPower > 1.0f) {
                    this.pilotPower = 1.0f;
                }
            }
        } else if (this.pilotPower > 0.0f) {
            this.pilotPower -= 0.16f;
            if (this.pilotPower < 0.0f) {
                this.pilotPower = 0.0f;
            }
        }
    }

    private void pullOarByWave(ShipSide side, Vec3d normal) {
        Vec3d oar = this.getOarVector(side);
        Vec3d of = new Vec3d(oar.field_72450_a, 0.0, oar.field_72449_c);
        Vec3d nf = new Vec3d(normal.field_72450_a, 0.0, normal.field_72449_c);
        float angle = nf.func_72433_c() < 1.0E-12 ? 0.0f : (float)Math.acos(Math.max(Math.min(nf.func_72430_b(of) / (nf.func_72433_c() * of.func_72433_c()), 1.0), -1.0));
        float align = MathUtils.linearTransformf(angle, 0.0f, (float)Math.PI, 1.0f, 0.0f);
        float yaw = (float)Math.atan2(-normal.field_72449_c, -normal.field_72450_a) - (this.field_70177_z - 90.0f) * ((float)Math.PI / 180);
        float pitch = (float)Math.acos(Math.max(Math.min(normal.func_72430_b(of), 1.0), -1.0));
        float x = this.oarXWavePull.get((Object)side).floatValue();
        this.oarXWavePull.put(side, Float.valueOf(x + (MathHelper.func_76131_a((float)(yaw * align * (float)nf.func_72433_c() * 2.0f), (float)-0.3f, (float)0.3f) - x) * 0.7f * (float)nf.func_72433_c()));
        float z = this.oarZWavePull.get((Object)side).floatValue();
        this.oarZWavePull.put(side, Float.valueOf(z + ((pitch - 1.5707964f) * (1.0f - align) * (this.getOarElevation(side) + 1.0f) / 2.0f - z) * 0.4f));
    }

    private void updateClientOarProgress(ShipSide side) {
        this.prevRowProgress.put(side, this.rowProgress.get((Object)side));
        if (!this.isUserSteering()) {
            this.rowProgress.put(side, Float.valueOf(this.getServerRowProgress(side)));
        }
    }

    private void returnOarToResting(ShipSide side, float preApplyValue) {
        if (this.getRowForce(side) == 0.0f) {
            float value = this.getAppropriateRowProgress(side);
            if (value != RESTING_ROW_PROGRESS) {
                float dist = RESTING_ROW_PROGRESS - value;
                if (dist < 0.0f) {
                    dist += ROW_PROGRESS_PERIOD;
                }
                if ((double)dist < 1.0E-4 && preApplyValue < RESTING_ROW_PROGRESS) {
                    value = RESTING_ROW_PROGRESS;
                } else {
                    float increment = dist * 0.085f;
                    if (increment > 0.005f) {
                        increment = 0.005f;
                    }
                    value += increment;
                }
            }
            this.setRowProgress(side, value);
        }
    }

    private void synchronizeOars() {
        float value;
        if (this.getRowForce(this.synchronizer) == 0.0f) {
            return;
        }
        ShipSide desynced = this.synchronizer.getOpposite();
        if (this.getRowForce(desynced) == 0.0f) {
            return;
        }
        float target = this.getAppropriateRowProgress(this.synchronizer);
        if (Math.abs(target - (value = this.getAppropriateRowProgress(desynced))) < 1.0E-6f) {
            return;
        }
        if (target < value) {
            this.synchronizer = desynced;
            return;
        }
        if ((value += 0.0045f) > target) {
            value = target;
        }
        this.setRowProgress(desynced, value);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            Matrix mat = new Matrix();
            double pelvis = 0.75;
            mat.translate(0.0, pelvis - 1.5, 0.0);
            mat.rotate(this.rotation);
            mat.translate(0.0, 1.5, 0.0);
            mat.rotate(-this.field_70177_z * ((float)Math.PI / 180), 0.0, 1.0, 0.0);
            mat.translate(0.0, this.func_70042_X() - pelvis, 0.2625);
            Vec3d point = mat.transform(Vec3d.field_186680_a);
            passenger.func_70107_b(this.field_70165_t + point.field_72450_a, this.field_70163_u + point.field_72448_b, this.field_70161_v + point.field_72449_c);
            passenger.field_70177_z += this.rotationalVelocity;
            passenger.func_70034_d(passenger.func_70079_am() + this.rotationalVelocity);
            this.func_184454_a(passenger);
        }
    }

    protected void func_184454_a(Entity entity) {
        entity.func_181013_g(MathHelper.func_76142_g((float)(this.field_70177_z - 180.0f)));
        float delta = MathHelper.func_76142_g((float)(entity.field_70177_z - this.field_70177_z - 180.0f));
        float clamped = MathHelper.func_76131_a((float)delta, (float)-135.0f, (float)135.0f);
        entity.field_70126_B += clamped - delta;
        entity.field_70177_z = entity.field_70177_z + clamped - delta;
        entity.func_70034_d(entity.field_70177_z);
    }

    private void tickLerp() {
        if (this.serverT <= 0 || this.isUserSteering()) {
            return;
        }
        double dx = this.field_70165_t - this.serverX;
        double dy = this.field_70163_u - this.serverY;
        double dz = this.field_70161_v - this.serverZ;
        if (dx * dx + dy * dy + dz * dz > 100.0) {
            this.func_70107_b(this.serverX, this.serverY, this.serverZ);
            this.func_70101_b(this.boatYaw, this.boatPitch);
            this.serverT = 0;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70126_B = this.field_70177_z;
        } else {
            double x = this.field_70165_t + (this.serverX - this.field_70165_t) / (double)this.serverT;
            double y = this.field_70163_u + (this.serverY - this.field_70163_u) / (double)this.serverT;
            double z = this.field_70161_v + (this.serverZ - this.field_70161_v) / (double)this.serverT;
            this.field_70177_z += MathHelper.func_76142_g((float)(this.boatYaw - this.field_70177_z)) / (float)this.serverT;
            this.field_70125_A += (this.boatPitch - this.field_70125_A) / (float)this.serverT;
            --this.serverT;
            this.func_70107_b(x, y, z);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    private void applyForces() {
        float bobBase = 0.1f;
        float buoyancy = 0.0f;
        BlockPos pos = new BlockPos((Entity)this);
        IBlockState blockAt = this.field_70170_p.func_180495_p(pos);
        IBlockState blockAbove = this.field_70170_p.func_180495_p(pos.func_177984_a());
        if (EntityWeedwoodRowboat.isWater(blockAt) && !EntityWeedwoodRowboat.isWater(blockAbove)) {
            float y = (float)pos.func_177956_o() + EntityWeedwoodRowboat.getLiquidHeight(blockAt, this.field_70170_p, pos) + this.field_70131_O;
            buoyancy = (y - (float)this.func_174813_aQ().field_72338_b - 0.55f) / this.field_70131_O;
            this.drag = 0.9875f;
            this.submergeTicks = 0.0f;
        } else if (EntityWeedwoodRowboat.isWater(blockAt) && EntityWeedwoodRowboat.isWater(blockAbove)) {
            buoyancy = 1.25f;
            this.drag = 0.975f;
            this.submergeTicks += 1.0f;
        } else if (blockAt.func_185904_a() == Material.field_151579_a) {
            IBlockState blockBellow = this.field_70170_p.func_180495_p(pos.func_177977_b());
            this.drag = EntityWeedwoodRowboat.isWater(blockBellow) ? 0.95f : (blockBellow.func_185904_a().func_76230_c() ? 0.35f : 1.0f);
        }
        float motionRawAngle = (float)Math.atan2(this.field_70179_y, this.field_70159_w);
        float motionAngle = MathHelper.func_76142_g((float)(motionRawAngle * 57.29578f + 180.0f));
        float deviation = Math.abs(MathHelper.func_76142_g((float)(this.field_70177_z - 90.0f - motionAngle))) / 180.0f;
        this.drag *= MathUtils.linearTransformf(DEVIATION_DRAG.eval(deviation), 0.0f, 1.0f, 1.0f, 0.25f);
        this.field_70181_x -= 0.04;
        this.field_70159_w *= (double)this.drag;
        this.field_70179_y *= (double)this.drag;
        this.rotationalVelocity *= this.drag * 0.95f;
        if (buoyancy > 0.0f) {
            this.field_70181_x += (double)buoyancy * 0.06;
            this.field_70181_x *= 0.75;
        }
    }

    private Vec3d applyRowForce() {
        Vec3d currentMotion;
        Vec3d cross;
        if (this.func_184179_bs() == null || this.submergeTicks >= 25.0f) {
            return null;
        }
        Vec3d rowForce = new Vec3d(1.0, 0.0, 0.0);
        Vec3d motion = new Vec3d(0.0, 0.0, 0.0);
        Vec3d rotation = new Vec3d(0.0, 0.0, 0.0);
        float leftOarForce = this.getRowForce(ShipSide.STARBOARD);
        float rightOarForce = this.getRowForce(ShipSide.PORT);
        float forceFactor = 0.35f;
        if (leftOarForce > 0.0f) {
            this.updateRowProgress(ShipSide.STARBOARD, leftOarForce * this.getOarWaterResistance(ShipSide.STARBOARD));
            if (this.canOarsApplyForce()) {
                Vec3d leftLever = new Vec3d(0.0, 0.0, (double)(leftOarForce *= this.getOarPeriodicForceApplyment(ShipSide.STARBOARD)));
                motion = motion.func_72441_c(0.0, 0.0, (double)(leftOarForce * forceFactor));
                cross = rowForce.func_72431_c(leftLever);
                rotation = rotation.func_72441_c(cross.field_72450_a, cross.field_72448_b, cross.field_72449_c);
            }
        }
        if (rightOarForce > 0.0f) {
            this.updateRowProgress(ShipSide.PORT, rightOarForce * this.getOarWaterResistance(ShipSide.PORT));
            if (this.canOarsApplyForce()) {
                Vec3d righerLever = new Vec3d(0.0, 0.0, (double)(rightOarForce *= this.getOarPeriodicForceApplyment(ShipSide.PORT)));
                motion = motion.func_72441_c(0.0, 0.0, (double)(rightOarForce * forceFactor));
                cross = new Vec3d(-rowForce.field_72450_a, -rowForce.field_72448_b, -rowForce.field_72449_c).func_72431_c(righerLever);
                rotation = rotation.func_72441_c(cross.field_72450_a, cross.field_72448_b, cross.field_72449_c);
            }
        }
        if ((currentMotion = new Vec3d(this.field_70159_w, 0.0, this.field_70179_y)).func_72433_c() < 0.1 && rotation.field_72450_a * rotation.field_72450_a + rotation.field_72448_b * rotation.field_72448_b + rotation.field_72449_c + rotation.field_72449_c > 0.0) {
            motion = motion.func_186678_a(0.35);
            rotation = rotation.func_186678_a(1.6);
        }
        this.rotationalVelocity = (float)((double)this.rotationalVelocity + rotation.field_72448_b * 10.0);
        return motion;
    }

    private void updateMotion(Vec3d motion) {
        motion = motion.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
        this.field_70159_w += motion.field_72450_a;
        this.field_70181_x += motion.field_72448_b;
        this.field_70179_y += motion.field_72449_c;
        this.func_184445_a(this.oarState.get((Object)ShipSide.STARBOARD), this.oarState.get((Object)ShipSide.PORT));
    }

    private float getOarPeriodicForceApplyment(ShipSide side) {
        return MathUtils.linearTransformf(this.getOarElevation(side), -1.0f, 1.0f, 0.0f, 2.0f);
    }

    private float getOarWaterResistance(ShipSide side) {
        float weight = MathUtils.linearTransformf(this.getOarElevation(side), -1.0f, 1.0f, 1.0f, 0.25f);
        float velocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        float max = 0.5f;
        if (velocity > 0.5f) {
            velocity = 0.5f;
        }
        float t = velocity / 0.5f;
        return weight + (1.0f - weight) * t;
    }

    private float getOarElevation(ShipSide side) {
        return MathHelper.func_76134_b((float)(this.getAppropriateRowProgress(side) * -28.0f));
    }

    public boolean canOarsApplyForce() {
        return this.drag <= 1.0f;
    }

    public float getRowForce(ShipSide side) {
        return 0.017f * this.rowForce.get((Object)side).floatValue();
    }

    public void updateRowProgress(ShipSide side, float value) {
        this.setRowProgress(side, this.getAppropriateRowProgress(side) + value);
    }

    public float getPilotPower(float delta) {
        return this.prevPilotPower + (this.pilotPower - this.prevPilotPower) * delta;
    }

    public void updateRowForce(ShipSide side, boolean oarStroke, boolean prevOarStroke) {
        float force = this.rowForce.get((Object)side).floatValue();
        int time = this.rowTime.get((Object)side) + 1;
        if (oarStroke || time < 10) {
            if (!prevOarStroke && oarStroke && time >= 10) {
                force = 1.0f;
                time = 0;
            } else {
                force = Math.max(force - 0.05f, 0.55f);
            }
        } else {
            force = Math.max(force - 0.1f, 0.0f);
        }
        this.rowTime.put(side, time);
        this.rowForce.put(side, Float.valueOf(force));
    }

    private void animateHullWaterInteraction() {
        double motionX = this.field_70165_t - this.field_70169_q;
        double motionY = this.field_70163_u - this.field_70167_r;
        double motionZ = this.field_70161_v - this.field_70166_s;
        double velocity = Math.sqrt(motionX * motionX + motionZ * motionZ);
        if (velocity > 0.2625) {
            double vecX = Math.cos((this.field_70177_z - 90.0f) * ((float)Math.PI / 180));
            double vecZ = Math.sin((this.field_70177_z - 90.0f) * ((float)Math.PI / 180));
            int p = 0;
            while ((double)p < 1.0 + velocity * 60.0) {
                double splashZ;
                double splashX;
                double near = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                double far = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                if (this.field_70146_Z.nextBoolean()) {
                    splashX = this.field_70165_t - vecX * near * 0.8 + vecZ * far;
                    splashZ = this.field_70161_v - vecZ * near * 0.8 - vecX * far;
                } else {
                    splashX = this.field_70165_t + vecX + vecZ * near * 0.7;
                    splashZ = this.field_70161_v + vecZ - vecX * near * 0.7;
                }
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, splashX, Math.ceil(this.field_70163_u) - 0.125, splashZ, motionX, 0.01, motionZ, new int[0]);
                ++p;
            }
        }
    }

    private void animateOars() {
        double motionX = this.field_70165_t - this.field_70169_q;
        double motionZ = this.field_70161_v - this.field_70166_s;
        double motion = Math.sqrt(motionX * motionX + motionZ * motionZ);
        this.animateOar(ShipSide.STARBOARD, motion);
        this.animateOar(ShipSide.PORT, motion);
    }

    private void animateOar(ShipSide side, double motion) {
        Vec3d oarlock = this.getOarlockPosition(side);
        Vec3d oarVector = this.getOarVector(side);
        Vec3d blade = oarlock.func_72441_c(oarVector.field_72450_a * 2.5, oarVector.field_72448_b * 2.5, oarVector.field_72449_c * 2.5);
        RayTraceResult raytrace = this.field_70170_p.func_72901_a(new Vec3d(oarlock.field_72450_a, oarlock.field_72448_b, oarlock.field_72449_c), blade, true);
        boolean bladeInAir = true;
        float amountOfBladeInAir = 0.75f;
        if (raytrace != null && raytrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            float amountInAir;
            if (motion > 0.175) {
                int p = 0;
                while ((double)p < motion) {
                    float x = MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.2f, 0.2f);
                    float y = MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.2f, 0.2f);
                    float z = MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.2f, 0.2f);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, raytrace.field_72307_f.field_72450_a + (double)x, raytrace.field_72307_f.field_72448_b + (double)y, raytrace.field_72307_f.field_72449_c + (double)z, this.field_70159_w, 0.01, this.field_70179_y, new int[0]);
                    ++p;
                }
            }
            if ((amountInAir = (float)oarlock.func_72438_d(raytrace.field_72307_f)) < 1.75f) {
                bladeInAir = false;
            } else {
                amountOfBladeInAir = 2.5f - amountInAir;
            }
        }
        if (bladeInAir && this.field_70146_Z.nextFloat() < 0.4f) {
            int count = (int)(1.0 + motion * 3.0);
            for (int p = 0; p < count; ++p) {
                float point = 1.75f + this.field_70146_Z.nextFloat() * amountOfBladeInAir;
                float x = (float)(oarVector.field_72450_a * (double)point + (double)MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.1f, 0.1f));
                float y = (float)(oarVector.field_72448_b * (double)point + (double)MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.4f, -0.2f));
                float z = (float)(oarVector.field_72449_c * (double)point + (double)MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.1f, 0.1f));
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, oarlock.field_72450_a + (double)x, oarlock.field_72448_b + (double)y, oarlock.field_72449_c + (double)z, 0.0, 1.0E-8, 0.0, new int[0]);
            }
        }
    }

    private Vec3d getOarlockPosition(ShipSide side) {
        float dir = side == ShipSide.PORT ? 1.0f : -1.0f;
        Matrix mat = new Matrix();
        mat.translate(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        mat.rotate(this.rotation);
        mat.rotate(-this.field_70177_z * ((float)Math.PI / 180), 0.0, 1.0, 0.0);
        mat.translate(0.6 * (double)dir, 1.15, -0.2);
        return mat.transform(Vec3d.field_186680_a);
    }

    private Vec3d getOarVector(ShipSide side) {
        float dir = side == ShipSide.PORT ? -1.0f : 1.0f;
        float progress = this.getAppropriateRowProgress(side);
        float yaw = this.getOarRotationX(side, progress, 1.0f) * dir - (this.field_70177_z - 90.0f) * ((float)Math.PI / 180);
        float pitch = this.getOarRotationZ(side, progress, 1.0f) - 1.5707964f;
        float cosYaw = MathHelper.func_76134_b((float)(-yaw));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw));
        float cosPitch = MathHelper.func_76134_b((float)(-pitch));
        Mat4d mat = new Mat4d();
        mat.asQuaternion(this.rotation);
        return mat.transform(new Vec3d((double)(-sinYaw * cosPitch), (double)MathHelper.func_76126_a((float)pitch), (double)(cosYaw * cosPitch)));
    }

    private void createSoundFX() {
        this.createOarSoundFX(ShipSide.STARBOARD);
        this.createOarSoundFX(ShipSide.PORT);
    }

    private void createOarSoundFX(ShipSide side) {
        float amountInAir;
        double velocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        Vec3d oarlock = this.getOarlockPosition(side);
        Vec3d oarVector = this.getOarVector(side);
        Vec3d blade = oarlock.func_72441_c(oarVector.field_72450_a * 2.5, oarVector.field_72448_b * 2.5, oarVector.field_72449_c * 2.5);
        RayTraceResult raytrace = this.field_70170_p.func_72901_a(new Vec3d(oarlock.field_72450_a, oarlock.field_72448_b, oarlock.field_72449_c), blade, true);
        boolean bladeInAir = true;
        if (raytrace != null && raytrace.field_72313_a == RayTraceResult.Type.BLOCK && (amountInAir = (float)oarlock.func_72438_d(raytrace.field_72307_f)) < 1.75f) {
            boolean start;
            bladeInAir = false;
            float force = this.rowForce.get((Object)side).floatValue();
            boolean bl = start = force == 1.0f;
            if (this.oarInAir.get((Object)side).booleanValue() || start) {
                float volume = force * 0.8f + 0.2f;
                SoundEvent sound = (start ? SOUND_ROW_START : SOUND_ROW).get((Object)side);
                this.field_70170_p.func_184148_a(null, raytrace.field_72307_f.field_72450_a, raytrace.field_72307_f.field_72448_b, raytrace.field_72307_f.field_72449_c, sound, SoundCategory.NEUTRAL, volume, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
            }
        }
        this.oarInAir.put(side, bladeInAir);
    }

    public boolean func_96092_aw() {
        return this.func_184186_bw();
    }

    public boolean func_70072_I() {
        double mX = this.field_70159_w;
        double mZ = this.field_70179_y;
        if (this.field_70170_p.func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this)) {
            float volume;
            if (mX != this.field_70159_w && mZ != this.field_70179_y && this.func_184186_bw()) {
                double aX = this.field_70159_w - mX;
                double aZ = this.field_70179_y - mZ;
                double dir = Math.atan2(aZ, aX) * (double)57.29578f;
                double speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                this.rotationalVelocity = (float)((double)this.rotationalVelocity + (MathHelper.func_151237_a((double)(MathUtils.modularDelta((double)this.field_70177_z, dir - 90.0, 360.0) * Math.min(speed * 1.1, 0.3)), (double)-12.0, (double)12.0) - (double)this.rotationalVelocity) * 0.75);
            }
            if (!this.field_70171_ac && (double)(volume = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w * 0.2 + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y * 0.2)) * 0.2f) > 0.15) {
                float x;
                if (volume > 1.0f) {
                    volume = 1.0f;
                }
                this.func_184185_a(this.func_184181_aa(), volume, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                float min = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
                int i = 0;
                while ((float)i < 1.0f + this.field_70130_N * 20.0f) {
                    x = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    float z = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (double)x, (double)(min + 1.0f), this.field_70161_v + (double)z, this.field_70159_w, this.field_70181_x - (double)(this.field_70146_Z.nextFloat() * 0.2f), this.field_70179_y, new int[0]);
                    ++i;
                }
                i = 0;
                while ((float)i < 1.0f + this.field_70130_N * 20.0f) {
                    x = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    float z = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)x, (double)(min + 1.0f), this.field_70161_v + (double)z, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                    ++i;
                }
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        return this.field_70171_ac;
    }

    public void setRowProgress(ShipSide side, float progress) {
        while (progress > ROW_PROGRESS_PERIOD) {
            progress -= ROW_PROGRESS_PERIOD;
        }
        while (progress < 0.0f) {
            progress += ROW_PROGRESS_PERIOD;
        }
        if (this.isUserSteering()) {
            this.rowProgress.put(side, Float.valueOf(progress));
        } else {
            this.field_70180_af.func_187227_b(ROW_PROGRESS.get((Object)side), (Object)Float.valueOf(progress));
        }
    }

    public float getRowProgress(ShipSide side, float delta) {
        float prevProgress = this.prevRowProgress.get((Object)side).floatValue();
        float progress = this.rowProgress.get((Object)side).floatValue();
        return delta * (MathUtils.mod(progress - prevProgress + ROW_PROGRESS_PERIOD / 2.0f, ROW_PROGRESS_PERIOD) - ROW_PROGRESS_PERIOD / 2.0f) + prevProgress;
    }

    public float getServerRowProgress(ShipSide side) {
        return ((Float)this.field_70180_af.func_187225_a(ROW_PROGRESS.get((Object)side))).floatValue();
    }

    public float getAppropriateRowProgress(ShipSide side) {
        return this.isUserSteering() ? this.rowProgress.get((Object)side).floatValue() : this.getServerRowProgress(side);
    }

    public boolean getAppropriateOarState(ShipSide side) {
        return this.isUserSteering() ? this.oarState.get((Object)side).booleanValue() : this.func_184457_a(side.ordinal());
    }

    private boolean isUserSteering() {
        Entity entity = this.func_184179_bs();
        return entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175144_cb();
    }

    public float getOarRotationX(ShipSide side, float theta, float delta) {
        return MathHelper.func_76126_a((float)(theta * -28.0f)) * 0.6f + this.prevOarXWavePull.get((Object)side).floatValue() + (this.oarXWavePull.get((Object)side).floatValue() - this.prevOarXWavePull.get((Object)side).floatValue()) * delta;
    }

    public float getOarRotationY(ShipSide side, float theta) {
        float angle = MathUtils.linearTransformf(MathHelper.func_76126_a((float)(theta * -28.0f + 1.5707964f)), -1.0f, 1.0f, 1.5707964f, 0.0f);
        if (side == ShipSide.PORT) {
            angle = (float)Math.PI - angle;
        }
        return angle;
    }

    public float getOarRotationZ(ShipSide side, float theta, float delta) {
        float angle = MathHelper.func_76134_b((float)(theta * -28.0f)) * 0.45f - 1.2566371f + this.prevOarZWavePull.get((Object)side).floatValue() + (this.oarZWavePull.get((Object)side).floatValue() - this.prevOarZWavePull.get((Object)side).floatValue()) * delta;
        if (side == ShipSide.PORT) {
            angle = -angle;
        }
        return angle;
    }

    public Quat getRotation(float delta) {
        Quat rot = new Quat(this.prevRotation);
        rot.interpolate(this.rotation, delta);
        return rot;
    }

    public double getWaveHeight(float delta) {
        return delta == 1.0f ? this.waveHeight : this.prevWaveHeight + (this.waveHeight - this.prevWaveHeight) * (double)delta;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.isTarred()) {
            compound.func_74757_a("isTarred", this.isTarred());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setIsTarred(compound.func_74767_n("isTarred"));
    }

    public void writeSpawnData(ByteBuf buf) {
    }

    public void readSpawnData(ByteBuf buf) {
        this.field_70126_B = this.field_70177_z;
    }

    public static boolean isTarred(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74775_l("attributes").func_74767_n("isTarred");
    }

    private static <T> DataParameter<T> defineId(DataSerializer<T> serializer) {
        return EntityDataManager.func_187226_a(EntityWeedwoodRowboat.class, serializer);
    }

    private static boolean isWater(IBlockState state) {
        return state.func_185904_a() == Material.field_151586_h;
    }

    private static float getLiquidHeight(IBlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).getFilledPercentage(world, pos);
        }
        if (block instanceof BlockLiquid) {
            return BlockLiquid.func_190973_f((IBlockState)state, (IBlockAccess)world, (BlockPos)pos);
        }
        return 1.0f;
    }

    public float func_184451_k() {
        throw this.ohnoes();
    }

    public float func_184441_l() {
        throw this.ohnoes();
    }

    public void func_184458_a(EntityBoat.Type boatType) {
        throw this.ohnoes();
    }

    public EntityBoat.Type func_184453_r() {
        throw this.ohnoes();
    }

    public float func_184448_a(int oar, float limbSwing) {
        throw this.ohnoes();
    }

    private RuntimeException ohnoes() {
        return new UnsupportedOperationException("OH NOES!");
    }

    @SubscribeEvent
    public static void onLivingAttacked(LivingAttackEvent event) {
        Entity ridingEntity = event.getEntityLiving().func_184187_bx();
        if (ridingEntity instanceof EntityWeedwoodRowboat && event.getSource().func_76346_g() != null) {
            Vec3d location = event.getSource().func_188404_v();
            Entity attacker = event.getSource().func_76364_f();
            if (location != null) {
                double d = location.field_72448_b;
                float f = attacker != null ? attacker.func_70047_e() : 0.0f;
                if (d + (double)f < ridingEntity.field_70163_u + (double)(ridingEntity.field_70131_O / 2.0f)) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

