/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.item.tools.bow.EnumArrowType;
import thebetweenlands.common.registries.ItemRegistry;

public class EntityBLArrow
extends EntityArrow
implements IThrowableEntity {
    private static final DataParameter<String> DW_TYPE = EntityDataManager.func_187226_a(EntityArrow.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityBLArrow(World worldIn) {
        super(worldIn);
    }

    public EntityBLArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityBLArrow(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_TYPE, (Object)"");
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("arrowType", this.getArrowType().func_176610_l());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setType(EnumArrowType.getEnumFromString(nbt.func_74779_i("arrowType")));
    }

    protected void func_184548_a(EntityLivingBase living) {
        switch (this.getArrowType()) {
            case ANGLER_POISON: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 2));
                break;
            }
            case OCTINE: {
                if (living.func_70027_ad()) {
                    living.func_70015_d(9);
                    break;
                }
                living.func_70015_d(5);
                break;
            }
            case BASILISK: {
                if (!living.func_184222_aU()) {
                    // empty if block
                }
                living.func_70690_d(ElixirEffectRegistry.EFFECT_PETRIFY.createEffect(100, 1));
                break;
            }
        }
    }

    public void setType(EnumArrowType type) {
        this.field_70180_af.func_187227_b(DW_TYPE, (Object)type.func_176610_l());
    }

    public EnumArrowType getArrowType() {
        return EnumArrowType.getEnumFromString((String)this.field_70180_af.func_187225_a(DW_TYPE));
    }

    protected ItemStack func_184550_j() {
        switch (this.getArrowType()) {
            case ANGLER_POISON: {
                return new ItemStack(ItemRegistry.POISONED_ANGLER_TOOTH_ARROW);
            }
            case OCTINE: {
                return new ItemStack(ItemRegistry.OCTINE_ARROW);
            }
            case BASILISK: {
                return new ItemStack(ItemRegistry.BASILISK_ARROW);
            }
        }
        return new ItemStack(ItemRegistry.ANGLER_TOOTH_ARROW);
    }
}

