/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.entity.mobs.EntityWallFace;
import thebetweenlands.common.entity.projectiles.EntitySapSpit;
import thebetweenlands.common.registries.BlockRegistry;

public abstract class EntitySpiritTreeFace
extends EntityWallFace
implements IMob {
    public static final byte EVENT_ATTACKED = 2;
    public static final byte EVENT_DEATH = 3;
    public static final byte EVENT_EMERGE_SOUND = 81;
    public static final byte EVENT_HURT_SOUND = 82;
    public static final byte EVENT_SPIT = 83;
    protected int spitTicks = 0;
    protected float spitDamage;
    private boolean emergeSound = false;
    protected int prevGlowTicks = 0;
    protected int glowTicks = 0;
    protected int glowDuration = 0;

    public EntitySpiritTreeFace(World world) {
        super(world);
        this.field_70728_aV = 4;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    public void setGlowTicks(int duration) {
        this.glowTicks = duration = Math.max(duration, 1);
        this.glowDuration = duration;
    }

    public float getGlow(float partialTicks) {
        return ((float)this.prevGlowTicks + (float)(this.glowTicks - this.prevGlowTicks) * partialTicks) / (float)this.glowDuration;
    }

    protected void playSpitSound() {
    }

    protected void playEmergeSound() {
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public boolean func_174814_R() {
        return super.func_174814_R() || !this.isActive();
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected void func_184581_c(DamageSource source) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)82);
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 83) {
            if (this.glowTicks < 10) {
                this.setGlowTicks(10);
            }
        } else if (id == 2) {
            if (this.glowTicks < 10) {
                this.setGlowTicks(10);
            }
        } else if (id == 82 || id == 3) {
            SoundType soundType = SoundType.field_185848_a;
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 1.3f, soundType.func_185847_b() * 0.8f, false);
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185846_f(), SoundCategory.NEUTRAL, (soundType.func_185843_a() + 1.0f) / 4.0f, soundType.func_185847_b() * 0.5f, false);
        }
    }

    public boolean isActive() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    @Override
    protected boolean func_70610_aX() {
        return !this.isActive() || this.isAttacking() || super.func_70610_aX();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean canResideInBlock(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_177230_c() == BlockRegistry.LOG_SPIRIT_TREE;
    }

    @Override
    public boolean canMoveFaceInto(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_185904_a().func_76224_d() || state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, pos)) {
            return true;
        }
        if (state.func_177230_c().isLeaves(state, (IBlockAccess)this.field_70170_p, pos)) {
            return false;
        }
        ArrayList collisionBoxes = new ArrayList();
        state.func_185908_a(this.field_70170_p, pos, new AxisAlignedBB(pos), collisionBoxes, (Entity)this, false);
        return collisionBoxes.isEmpty();
    }

    public boolean func_85031_j(Entity entity) {
        if (this.func_190530_aW()) {
            return true;
        }
        return super.func_85031_j(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        ItemStack item;
        EntityLivingBase attacker;
        if (this.func_190530_aW()) {
            return false;
        }
        if (source.func_76364_f() instanceof IProjectile && source.func_76346_g() != null && source.func_76346_g().func_70032_d((Entity)this) >= 26.0f) {
            return false;
        }
        EntityLivingBase entityLivingBase = attacker = source.func_76364_f() instanceof EntityLivingBase ? (EntityLivingBase)source.func_76364_f() : null;
        if (attacker != null && attacker.func_184600_cs() != null && !(item = attacker.func_184586_b(attacker.func_184600_cs())).func_190926_b() && item.func_77973_b() instanceof ItemAxe) {
            amount *= 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76369_e || source == DamageSource.field_76371_c || super.func_180431_b(source);
    }

    public boolean func_190530_aW() {
        return super.func_190530_aW() || !this.isActive();
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevGlowTicks = this.glowTicks;
        if (this.glowTicks > 0) {
            --this.glowTicks;
        }
        if (!this.field_70170_p.field_72995_K) {
            float moveProgress = this.getMovementProgress(1.0f);
            if (moveProgress < 0.6f) {
                this.emergeSound = false;
            } else {
                if (!this.emergeSound) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)81);
                    this.playEmergeSound();
                }
                this.emergeSound = true;
            }
        }
        if (this.spitTicks > 0) {
            this.updateSpitAttack();
        }
        if (this.isMoving() && this.field_70170_p.field_72995_K && this.field_70173_aa % 3 == 0) {
            EnumFacing facing = this.getFacing();
            double px = this.field_70165_t + (double)((float)facing.func_82601_c() * this.field_70130_N / 2.0f);
            double py = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + (double)((float)facing.func_96559_d() * this.field_70131_O / 2.0f);
            double pz = this.field_70161_v + (double)((float)facing.func_82599_e() * this.field_70130_N / 2.0f);
            for (int i = 0; i < 24; ++i) {
                double rz;
                double ry;
                double rx = (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)this.field_70130_N;
                BlockPos pos = new BlockPos(px + rx, py + (ry = (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)this.field_70131_O), pz + (rz = (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)this.field_70130_N));
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, pos)) continue;
                double mx = (double)((float)facing.func_82601_c() * 0.15f) + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.25;
                double my = (double)((float)facing.func_96559_d() * 0.15f) + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.25;
                double mz = (double)((float)facing.func_82599_e() * 0.15f) + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.25;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, px + rx, py + ry, pz + rz, mx, my, mz, new int[]{Block.func_176210_f((IBlockState)state)});
            }
        }
    }

    protected void updateSpitAttack() {
        if (this.spitTicks == 1) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)83);
            this.setGlowTicks(10);
            this.playSpitSound();
        }
        if (this.spitTicks > 6) {
            this.doSpitAttack();
            this.spitTicks = 0;
        } else {
            ++this.spitTicks;
        }
    }

    @Override
    protected void fixUnsuitablePosition(int violatedChecks) {
        if (this.field_70173_aa % 5 == 0) {
            for (int i = 0; i < 50; ++i) {
                float rx = this.field_70170_p.field_73012_v.nextFloat() * 2.0f - 1.0f;
                float ry = this.field_70170_p.field_73012_v.nextFloat() * 2.0f - 1.0f;
                float rz = this.field_70170_p.field_73012_v.nextFloat() * 2.0f - 1.0f;
                BlockPos rndPos = new BlockPos(this.field_70165_t + (double)this.field_70170_p.field_73012_v.nextInt(8) - 4.0, this.field_70163_u + (double)(this.field_70131_O / 2.0f) + (double)this.field_70170_p.field_73012_v.nextInt(8) - 4.0, this.field_70161_v + (double)this.field_70170_p.field_73012_v.nextInt(8) - 4.0);
                Vec3d pos = new Vec3d((double)rndPos.func_177958_n() + 0.5, (double)rndPos.func_177956_o() + 0.5, (double)rndPos.func_177952_p() + 0.5);
                if (this.checkAnchorAt(pos, new Vec3d((double)rx, (double)ry, (double)rz), 7) != 0) continue;
                this.field_70749_g.setLookDirection(rx, ry, rz);
                this.field_70765_h.func_75642_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1.0);
                break;
            }
        }
    }

    public List<BlockPos> findNearbyWoodBlocks() {
        int radius = 8;
        BlockPos center = new BlockPos((Entity)this);
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dx = -8; dx <= 8; ++dx) {
            for (int dy = -8; dy <= 8; ++dy) {
                for (int dz = -8; dz <= 8; ++dz) {
                    pos.func_181079_c(center.func_177958_n() + dx, center.func_177956_o() + dy, center.func_177952_p() + dz);
                    IBlockState state = this.field_70170_p.func_180495_p((BlockPos)pos);
                    if (state.func_177230_c() != BlockRegistry.LOG_SPIRIT_TREE) continue;
                    blocks.add(pos.func_185334_h());
                }
            }
        }
        return blocks;
    }

    public boolean isAttacking() {
        return this.spitTicks > 0;
    }

    public void startSpit(float spitDamage) {
        this.spitTicks = 1;
        this.spitDamage = spitDamage;
    }

    public void doSpitAttack() {
        EntityLivingBase target = this.func_70638_az();
        if (target != null) {
            EnumFacing facing = this.getFacing();
            EntitySapSpit spit = new EntitySapSpit(this.field_70170_p, (EntityLivingBase)this, this.spitDamage);
            spit.func_70107_b(this.field_70165_t + (double)((float)facing.func_82601_c() * (this.field_70130_N / 2.0f + 0.1f)), this.field_70163_u + (double)(this.field_70131_O / 2.0f) + (double)((float)facing.func_96559_d() * (this.field_70131_O / 2.0f + 0.1f)), this.field_70161_v + (double)((float)facing.func_82599_e() * (this.field_70130_N / 2.0f + 0.1f)));
            double dx = target.field_70165_t - spit.field_70165_t;
            double dy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - spit.field_70163_u;
            double dz = target.field_70161_v - spit.field_70161_v;
            double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
            spit.func_70186_c(dx, dy + dist * (double)0.2f, dz, 1.0f, 1.0f);
            this.field_70170_p.func_72838_d((Entity)spit);
        }
    }

    public static class AISpit
    extends EntityAIBase {
        protected final EntitySpiritTreeFace entity;
        protected int minCooldown;
        protected int maxCooldown;
        protected int cooldown = 0;
        protected float spitDamage;

        public AISpit(EntitySpiritTreeFace entity, float spitDamage) {
            this(entity, spitDamage, 50, 170);
        }

        public AISpit(EntitySpiritTreeFace entity, float spitDamage, int minCooldown, int maxCooldown) {
            this.entity = entity;
            this.minCooldown = minCooldown;
            this.maxCooldown = maxCooldown;
            this.spitDamage = spitDamage;
            this.func_75248_a(0);
        }

        public boolean func_75250_a() {
            return this.entity.isActive() && !this.entity.isAttacking() && !this.entity.isMoving() && this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S() && this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az());
        }

        public void func_75249_e() {
            this.cooldown = 20 + this.entity.field_70146_Z.nextInt(40);
        }

        public void func_75246_d() {
            if (!this.entity.isAttacking()) {
                if (this.cooldown <= 0) {
                    this.cooldown = this.minCooldown + this.entity.field_70146_Z.nextInt(this.maxCooldown - this.minCooldown + 1);
                    this.entity.startSpit(this.getSpitDamage());
                }
                --this.cooldown;
            }
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        protected float getSpitDamage() {
            return this.spitDamage;
        }
    }

    public static class AIAttackMelee
    extends EntityAIAttackMelee {
        public AIAttackMelee(EntityCreature creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N;
        }
    }

    public static class AITrackTarget
    extends EntityAIBase {
        protected final EntitySpiritTreeFace entity;
        protected int findWoodCooldown = 0;
        protected List<BlockPos> woodBlocks;
        protected int checkCooldown = 0;
        protected boolean stayInRange;
        protected double maxRangeSq;

        public AITrackTarget(EntitySpiritTreeFace entity) {
            this(entity, false, 0.0);
        }

        public AITrackTarget(EntitySpiritTreeFace entity, boolean stayInRange, double maxRange) {
            this.entity = entity;
            this.stayInRange = stayInRange;
            this.maxRangeSq = maxRange * maxRange;
            this.func_75248_a(3);
        }

        protected boolean isTargetVisibleAndInRange() {
            return this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az()) && (!this.stayInRange || this.entity.func_70638_az().func_70068_e((Entity)this.entity) <= this.maxRangeSq);
        }

        public boolean func_75250_a() {
            return this.entity.isActive() && !this.entity.isAttacking() && !this.entity.isMoving() && this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S() && !this.isTargetVisibleAndInRange();
        }

        public void func_75249_e() {
            this.checkCooldown = 0;
            this.findWoodCooldown = 20 + this.entity.field_70146_Z.nextInt(30);
            this.woodBlocks = null;
        }

        public void func_75246_d() {
            if (!this.entity.isAttacking()) {
                if (this.findWoodCooldown <= 0 && (this.woodBlocks == null || this.woodBlocks.isEmpty())) {
                    this.findWoodCooldown = 20 + this.entity.field_70146_Z.nextInt(40);
                    this.woodBlocks = this.entity.findNearbyWoodBlocks();
                }
                if (this.woodBlocks != null && !this.woodBlocks.isEmpty() && this.checkCooldown <= 0) {
                    this.checkCooldown = 5 + this.entity.field_70146_Z.nextInt(15);
                    block0: for (int i = 0; i < 16 && !this.woodBlocks.isEmpty(); ++i) {
                        BlockPos pos = this.woodBlocks.remove(this.entity.field_70146_Z.nextInt(this.woodBlocks.size()));
                        if (this.stayInRange && !(this.entity.func_70638_az().func_174831_c(pos) <= this.maxRangeSq)) continue;
                        Vec3d center = new Vec3d((double)pos.func_177958_n() + (double)this.entity.getBlockWidth() / 2.0, (double)pos.func_177956_o() + (double)this.entity.getBlockHeight() / 2.0, (double)pos.func_177952_p() + (double)this.entity.getBlockWidth() / 2.0);
                        Vec3d lookDir = this.entity.func_70638_az().func_174791_d().func_72441_c(0.0, (double)this.entity.func_70638_az().func_70047_e(), 0.0).func_178788_d(center);
                        EnumFacing facing = EnumFacing.func_176737_a((float)((float)lookDir.field_72450_a), (float)((float)lookDir.field_72448_b), (float)((float)lookDir.field_72449_c));
                        if (this.canSeeFrom(pos, facing, (Entity)this.entity.func_70638_az()) && this.entity.checkAnchorAt(center, lookDir, 7) == 0) {
                            this.entity.field_70765_h.func_75642_a(center.field_72450_a, center.field_72448_b, center.field_72449_c, 1.0);
                            this.entity.field_70749_g.setLookDirection(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
                            break;
                        }
                        for (EnumFacing otherFacing : EnumFacing.field_176754_o) {
                            if (otherFacing == facing) continue;
                            lookDir = new Vec3d((double)otherFacing.func_82601_c(), 0.0, (double)otherFacing.func_82599_e());
                            if (!this.canSeeFrom(pos, otherFacing, (Entity)this.entity.func_70638_az()) || this.entity.checkAnchorAt(center, lookDir, 7) != 0) continue;
                            this.entity.field_70765_h.func_75642_a(center.field_72450_a, center.field_72448_b, center.field_72449_c, 1.0);
                            this.entity.field_70749_g.setLookDirection(otherFacing.func_82601_c(), otherFacing.func_96559_d(), otherFacing.func_82599_e());
                            continue block0;
                        }
                    }
                }
                --this.checkCooldown;
                --this.findWoodCooldown;
            }
        }

        protected boolean canSeeFrom(BlockPos pos, EnumFacing facing, Entity entity) {
            return this.entity.field_70170_p.func_147447_a(new Vec3d((double)pos.func_177958_n() + (double)this.entity.getBlockWidth() / 2.0 + (double)((float)facing.func_82601_c() * (this.entity.field_70130_N / 2.0f + this.entity.getPeek())), (double)pos.func_177956_o() + (double)this.entity.getBlockHeight() / 2.0 + (double)((float)facing.func_96559_d() * (this.entity.field_70131_O / 2.0f + this.entity.getPeek())), (double)pos.func_177952_p() + (double)this.entity.getBlockWidth() / 2.0 + (double)((float)facing.func_82599_e() * (this.entity.field_70130_N / 2.0f + this.entity.getPeek()))), new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), false, true, false) == null;
        }

        public boolean func_75253_b() {
            return !this.entity.isMoving() && this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S() && !this.isTargetVisibleAndInRange();
        }
    }
}

