/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.ai.EntityAIFlyRandomly;
import thebetweenlands.common.entity.ai.EntityAIMoveToDirect;
import thebetweenlands.common.entity.attributes.BooleanAttribute;
import thebetweenlands.common.entity.mobs.EntityFlyingMob;
import thebetweenlands.common.entity.mobs.EntityPyradFlame;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityPyrad
extends EntityFlyingMob
implements IEntityBL {
    public static final IAttribute FLAMES_PER_ATTACK = new RangedAttribute(null, "bl.flamesPerAttack", 6.0, 1.0, 64.0).func_111117_a("Number range of flames per attack");
    public static final IAttribute AGRESSIVE = new BooleanAttribute(null, "bl.pyradAgressive", false).func_111117_a("Whether the Pyrad is agressive and doesn't go inactive");
    private static final DataParameter<Boolean> CHARGING = EntityDataManager.func_187226_a(EntityBlaze.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ACTIVE = EntityDataManager.func_187226_a(EntityBlaze.class, (DataSerializer)DataSerializers.field_187198_h);
    private List<EntityAIBase> activeTasks;
    private List<EntityAIBase> activeTargetTasks;
    private int glowTicks = 0;
    private int prevGlowTicks = 0;
    private int activeTicks = 0;
    private int prevActiveTicks = 0;
    private int hitTicks = 0;
    private int prevHitTicks = 0;
    private int deathTicks = 0;

    public EntityPyrad(World worldIn) {
        super(worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
        this.field_70765_h = new FlightMoveHelper((EntityLiving)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHARGING, (Object)false);
        this.field_70180_af.func_187214_a(ACTIVE, (Object)false);
    }

    protected void func_184651_r() {
        this.activeTasks = new ArrayList<EntityAIBase>();
        this.activeTargetTasks = new ArrayList<EntityAIBase>();
        this.activeTasks.add(new EntityAIMoveToDirect<EntityPyrad>(this, 1.0){

            @Override
            protected Vec3d getTarget() {
                EntityLivingBase target = ((EntityPyrad)this.entity).func_70638_az();
                if (target != null) {
                    BlockPos pos = new BlockPos((Entity)this.entity);
                    int groundHeight = FlightMoveHelper.getGroundHeight(((EntityPyrad)this.entity).field_70170_p, pos, 16, pos).func_177956_o();
                    Vec3d dir = new Vec3d(target.field_70165_t - ((EntityPyrad)this.entity).field_70165_t, target.field_70163_u + 1.0 - (double)((EntityPyrad)this.entity).field_70146_Z.nextFloat() * 0.3 - ((EntityPyrad)this.entity).field_70163_u - 1.0, target.field_70161_v - ((EntityPyrad)this.entity).field_70161_v);
                    double dst = dir.func_72433_c();
                    if (dst > 10.0) {
                        dir = dir.func_72432_b();
                        this.setSpeed(0.75);
                        return new Vec3d(((EntityPyrad)this.entity).field_70165_t + dir.field_72450_a * (dst - 10.0), Math.min(((EntityPyrad)this.entity).field_70163_u + dir.field_72448_b * (dst - 10.0), Math.max((double)(groundHeight + 2), target.field_70163_u + 2.0)), ((EntityPyrad)this.entity).field_70161_v + dir.field_72449_c * (dst - 10.0));
                    }
                    if (dst < 5.0) {
                        dir = dir.func_72432_b();
                        this.setSpeed(1.0);
                        return new Vec3d(((EntityPyrad)this.entity).field_70165_t - dir.field_72450_a * 2.0, Math.min(((EntityPyrad)this.entity).field_70163_u - dir.field_72448_b * 2.0, Math.max((double)(groundHeight + (((EntityPyrad)this.entity).isCharging() ? 6 : 2)), target.field_70163_u + 2.0)), ((EntityPyrad)this.entity).field_70161_v - dir.field_72449_c * 2.0);
                    }
                }
                return null;
            }
        });
        this.activeTasks.add(new EntityAIFlyRandomly<EntityPyrad>(this){

            @Override
            protected double getTargetX(Random rand, double distanceMultiplier) {
                return ((EntityPyrad)this.entity).field_70165_t + (double)((rand.nextFloat() * 2.0f - 1.0f) * 10.0f) * distanceMultiplier;
            }

            @Override
            protected double getTargetY(Random rand, double distanceMultiplier) {
                return ((EntityPyrad)this.entity).field_70163_u + ((double)rand.nextFloat() * 1.45 - 1.0) * 4.0 * distanceMultiplier;
            }

            @Override
            protected double getTargetZ(Random rand, double distanceMultiplier) {
                return ((EntityPyrad)this.entity).field_70161_v + (double)((rand.nextFloat() * 2.0f - 1.0f) * 10.0f) * distanceMultiplier;
            }

            @Override
            protected double getFlightSpeed() {
                return 0.5;
            }
        });
        this.activeTasks.add(new AIPyradAttack(this));
        this.activeTasks.add((EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.04));
        this.activeTasks.add((EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.activeTasks.add((EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.activeTargetTasks.add((EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.activeTargetTasks.add((EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(28.0);
        this.func_110140_aT().func_111150_b(FLAMES_PER_ATTACK);
        this.func_110140_aT().func_111150_b(AGRESSIVE);
    }

    protected SoundEvent func_184639_G() {
        if (!this.isActive()) {
            return null;
        }
        return SoundRegistry.PYRAD_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.PYRAD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.PYRAD_DEATH;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74757_a("active", this.isActive());
        super.func_70014_b(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("active")) {
            this.setActive(nbt.func_74767_n("active"));
        }
        super.func_70037_a(nbt);
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean day;
            boolean bl = day = this.field_70170_p.field_73011_w.getSunBrightnessFactor(1.0f) >= 0.5f;
            if (this.func_70089_S() && (this.func_110148_a(AGRESSIVE).func_111126_e() == 1.0 || !day || this.func_70090_H()) && !this.isActive()) {
                this.setActive(true);
            }
            if (this.func_110148_a(AGRESSIVE).func_111126_e() == 0.0 && this.func_70089_S() && this.isActive() && this.func_70638_az() == null && this.field_70146_Z.nextInt(800) == 0) {
                this.setActive(false);
            }
            if (this.func_70090_H() && this.isActive()) {
                this.field_70765_h.func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 1.0);
            }
        }
        this.prevGlowTicks = this.glowTicks;
        if (this.isCharging() && this.glowTicks < 10) {
            ++this.glowTicks;
        } else if (!this.isCharging() && this.glowTicks > 0) {
            --this.glowTicks;
        }
        this.prevActiveTicks = this.activeTicks;
        if (this.isActive() && this.activeTicks < 60) {
            ++this.activeTicks;
        } else if (!this.isActive() && this.activeTicks > 0 && this.field_70122_E) {
            --this.activeTicks;
        }
        this.prevHitTicks = this.hitTicks;
        if (this.hitTicks > 0) {
            --this.hitTicks;
        }
        if (!this.isActive() && this.activeTicks == 0) {
            this.func_70105_a(0.7f, 1.2f);
            this.field_184626_bk = this.field_70177_z;
            this.field_70759_as = (float)this.field_184626_bk;
        } else {
            this.func_70105_a(0.7f, 2.0f);
        }
        if (this.field_70170_p.field_72995_K && this.isActive()) {
            if (this.field_70146_Z.nextInt(4) == 0) {
                Object args = ParticleFactory.ParticleArgs.get().withDataBuilder().setData(2, this).buildData();
                if (this.isCharging()) {
                    ((ParticleFactory.ParticleArgs)args).withColor(0.9f, 0.35f, 0.1f, 1.0f);
                } else {
                    ((ParticleFactory.ParticleArgs)args).withColor(1.0f, 0.65f, 0.25f, 1.0f);
                }
                BLParticles.LEAF_SWIRL.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (ParticleFactory.ParticleArgs<?>)args);
            }
            if (this.isCharging() || this.field_70146_Z.nextInt(10) == 0) {
                Object args = ParticleFactory.ParticleArgs.get().withMotion((this.field_70146_Z.nextFloat() - 0.5f) / 4.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 4.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 4.0f);
                if (this.isCharging()) {
                    ((ParticleFactory.ParticleArgs)args).withColor(0.9f, 0.35f, 0.1f, 1.0f);
                    ((ParticleFactory.ParticleArgs)args).withData(60);
                } else {
                    ((ParticleFactory.ParticleArgs)args).withColor(1.0f, 0.65f, 0.25f, 1.0f);
                }
                BLParticles.WEEDWOOD_LEAF.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, (ParticleFactory.ParticleArgs<?>)args);
            }
        }
        super.func_70636_d();
    }

    public float getGlowTicks(float partialTicks) {
        return (float)this.prevGlowTicks + (float)(this.glowTicks - this.prevGlowTicks) * partialTicks;
    }

    public float getActiveTicks(float partialTicks) {
        return (float)this.prevActiveTicks + (float)(this.activeTicks - this.prevActiveTicks) * partialTicks;
    }

    public float getHitTicks(float partialTicks) {
        return (float)this.prevHitTicks + (float)(this.hitTicks - this.prevHitTicks) * partialTicks;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entity) {
        return !this.isActive() && this.activeTicks == 0 ? entity.func_174813_aQ() : super.func_70114_g(entity);
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return !this.isActive() && this.activeTicks == 0 ? this.func_174813_aQ() : super.func_70046_E();
    }

    @Override
    public void func_191986_a(float strafe, float vertical, float forward) {
        if (!this.isActive()) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70181_x -= 0.1;
        }
        super.func_191986_a(strafe, vertical, forward);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.isActive() && this.func_70089_S()) {
            if (this.hitTicks <= 0) {
                if (!this.field_70170_p.field_72995_K && (this.field_70146_Z.nextInt(12) == 0 || amount > 3.0f)) {
                    this.setActive(true);
                    return super.func_70097_a(source, amount);
                }
                for (int i = 0; i < 10; ++i) {
                    if (this.field_70170_p.field_72995_K) {
                        Object args = ((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((this.field_70146_Z.nextFloat() - 0.5f) / 2.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 2.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 2.0f)).withColor(1.0f, 0.65f, 0.25f, 1.0f);
                        BLParticles.WEEDWOOD_LEAF.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v, (ParticleFactory.ParticleArgs<?>)args);
                    }
                    this.func_184185_a(SoundRegistry.PYRAD_HURT, 0.1f, 0.3f + this.field_70146_Z.nextFloat() * 0.3f);
                }
                this.hitTicks = 20;
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70653_a(Entity entityIn, float strenght, double xRatio, double zRatio) {
        if (this.isActive()) {
            super.func_70653_a(entityIn, strenght, xRatio, zRatio);
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && this.isActive();
    }

    protected void func_70609_aI() {
        if (this.isActive()) {
            this.setActive(false);
        } else if (this.field_70122_E && this.activeTicks < 20) {
            ++this.deathTicks;
            if (this.deathTicks > 10) {
                int i;
                if (this.field_70170_p.field_72995_K) {
                    for (i = 0; i < 10; ++i) {
                        Object args = ((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((this.field_70146_Z.nextFloat() - 0.5f) / 2.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 2.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 2.0f)).withScale(2.0f);
                        ((ParticleFactory.ParticleArgs)args).withColor(1.0f, 0.25f + this.field_70146_Z.nextFloat() * 0.5f, 0.05f + this.field_70146_Z.nextFloat() * 0.25f, 1.0f);
                        BLParticles.WEEDWOOD_LEAF.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v, (ParticleFactory.ParticleArgs<?>)args);
                        args = ParticleFactory.ParticleArgs.get().withMotion((this.field_70146_Z.nextFloat() - 0.5f) / 2.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 2.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 2.0f);
                        BLParticles.SWAMP_SMOKE.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v, (ParticleFactory.ParticleArgs<?>)args);
                    }
                }
                if (this.deathTicks > 30 && !this.field_70170_p.field_72995_K) {
                    for (i = 0; i < 10; ++i) {
                        this.func_184185_a(SoundRegistry.PYRAD_HURT, 0.18f, 0.1f + this.field_70146_Z.nextFloat() * 0.2f);
                        this.func_184185_a(SoundRegistry.PYRAD_DEATH, 0.08f, 0.1f + this.field_70146_Z.nextFloat() * 0.2f);
                    }
                    this.func_70106_y();
                }
            }
        }
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.PYRAD;
    }

    public boolean isCharging() {
        return (Boolean)this.func_184212_Q().func_187225_a(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.func_184212_Q().func_187227_b(CHARGING, (Object)charging);
    }

    public boolean isActive() {
        return (Boolean)this.func_184212_Q().func_187225_a(ACTIVE);
    }

    public void setActive(boolean active) {
        block6: {
            this.func_184212_Q().func_187227_b(ACTIVE, (Object)active);
            if (this.field_70170_p.field_72995_K) break block6;
            if (active) {
                int i;
                for (i = 0; i < this.activeTasks.size(); ++i) {
                    this.field_70714_bg.func_75776_a(i, this.activeTasks.get(i));
                }
                for (i = 0; i < this.activeTargetTasks.size(); ++i) {
                    this.field_70715_bh.func_75776_a(i, this.activeTargetTasks.get(i));
                }
            } else {
                for (EntityAIBase ai : this.activeTasks) {
                    this.field_70714_bg.func_85156_a(ai);
                }
                for (EntityAIBase ai : this.activeTargetTasks) {
                    this.field_70715_bh.func_85156_a(ai);
                }
            }
        }
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }

    static class AIPyradAttack
    extends EntityAIBase {
        private final EntityPyrad pyrad;
        private int attackStep;
        private int attackTime;

        public AIPyradAttack(EntityPyrad pyrad) {
            this.pyrad = pyrad;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.pyrad.func_70638_az();
            return target != null && target.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.pyrad.setCharging(false);
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase target = this.pyrad.func_70638_az();
            double distSq = this.pyrad.func_70068_e((Entity)target);
            if (distSq < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.pyrad.func_70652_k((Entity)target);
                }
                this.pyrad.func_70605_aq().func_75642_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0);
            } else if (distSq < 256.0) {
                double dx = target.field_70165_t - this.pyrad.field_70165_t;
                double dy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (this.pyrad.field_70163_u + (double)(this.pyrad.field_70131_O / 2.0f));
                double dz = target.field_70161_v - this.pyrad.field_70161_v;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 20 + this.pyrad.field_70146_Z.nextInt(40);
                        this.pyrad.setCharging(true);
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 60 + this.pyrad.field_70146_Z.nextInt(40);
                        this.attackStep = 0;
                        this.pyrad.setCharging(false);
                    }
                    if (this.attackStep > 1) {
                        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)distSq)) * 0.8f;
                        this.pyrad.field_70170_p.func_180498_a((EntityPlayer)null, 1018, new BlockPos((int)this.pyrad.field_70165_t, (int)this.pyrad.field_70163_u, (int)this.pyrad.field_70161_v), 0);
                        int numberFlames = (int)this.pyrad.func_110148_a(FLAMES_PER_ATTACK).func_111126_e();
                        for (int i = 0; i < (numberFlames > 1 ? this.pyrad.field_70146_Z.nextInt(numberFlames) : 0) + 1; ++i) {
                            EntityPyradFlame flame = new EntityPyradFlame(this.pyrad.field_70170_p, (EntityLivingBase)this.pyrad, dx + this.pyrad.func_70681_au().nextGaussian() * (double)f, dy, dz + this.pyrad.func_70681_au().nextGaussian() * (double)f);
                            flame.field_70163_u = this.pyrad.field_70163_u + (double)(this.pyrad.field_70131_O / 2.0f) + 0.5;
                            this.pyrad.field_70170_p.func_72838_d((Entity)flame);
                        }
                    }
                }
                this.pyrad.func_70671_ap().func_75651_a((Entity)target, 10.0f, 10.0f);
            }
            super.func_75246_d();
        }
    }
}

