/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IEntityScreenShake;
import thebetweenlands.common.entity.ai.EntityAIApproachItem;
import thebetweenlands.common.entity.ai.EntityAIPeatMummyCharge;
import thebetweenlands.common.entity.attributes.BooleanAttribute;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityPeatMummy
extends EntityMob
implements IEntityBL,
IEntityScreenShake {
    public static final IAttribute SPAWN_LENGTH_ATTRIB = new RangedAttribute(null, "bl.spawnLength", 100.0, 0.0, 2.147483647E9).func_111117_a("Spawning Length");
    public static final IAttribute SPAWN_OFFSET_ATTRIB = new RangedAttribute(null, "bl.spawnOffset", 2.0, -2.147483647E9, 2.147483647E9).func_111117_a("Spawning Y Offset");
    public static final IAttribute SPAWN_RANGE_ATTRIB = new RangedAttribute(null, "bl.spawnRange", 8.0, 0.0, Double.MAX_VALUE).func_111117_a("Spawning Range");
    public static final IAttribute CHARGING_COOLDOWN_ATTRIB = new RangedAttribute(null, "bl.chargingCooldown", 160.0, 0.0, 2.147483647E9).func_111117_a("Charging Cooldown");
    public static final IAttribute CHARGING_PREPARATION_SPEED_ATTRIB = new RangedAttribute(null, "bl.chargingPreparationSpeed", 60.0, 0.0, 2.147483647E9).func_111117_a("Charging Preparation Speed");
    public static final IAttribute CHARGING_TIME_ATTRIB = new RangedAttribute(null, "bl.chargingTime", 320.0, 0.0, 2.147483647E9).func_111117_a("Charging Time");
    public static final IAttribute CHARGING_SPEED_ATTRIB = new RangedAttribute(null, "bl.chargingSpeed", 0.55, 0.0, Double.MAX_VALUE).func_111117_a("Charging Movement Speed");
    public static final IAttribute CHARGING_DAMAGE_MULTIPLIER_ATTRIB = new RangedAttribute(null, "bl.chargingDamageMultiplier", 1.65, 0.0, Double.MAX_VALUE).func_111117_a("Charging Damage Multiplier");
    public static final IAttribute CARRY_SHIMMERSTONE = new BooleanAttribute(null, "bl.carryShimmerstone", false).func_111117_a("Whether this Peat Mummy carries a Shimmerstone");
    public static final IAttribute IS_BOSS = new BooleanAttribute(null, "bl.isDreadfulPeatMummyBoss", false).func_111117_a("Whether this Peat Mummy was spawned by a Dreadful Peat Mummy");
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final int BREAK_COUNT = 5;
    public static final float BASE_SPEED = 0.2f;
    public static final float BASE_DAMAGE = 6.0f;
    private static final DataParameter<Integer> SPAWNING_TICKS = EntityDataManager.func_187226_a(EntityPeatMummy.class, (DataSerializer)DataSerializers.field_187192_b);
    private int chargingPreparation;
    private static final DataParameter<Byte> CHARGING_STATE = EntityDataManager.func_187226_a(EntityPeatMummy.class, (DataSerializer)DataSerializers.field_187191_a);
    private int prevScreamTimer;
    private int screamTimer;
    private boolean screaming = false;
    private static final int SCREAMING_TIMER_MAX = 50;
    private float prevSpawningOffset = 0.0f;
    private float prevSpawningProgress = 0.0f;
    private static final List<Block> SPAWN_BLOCKS = new ArrayList<Block>();
    private List<EntityAIBase> activeTargetTasks;
    private List<EntityAIBase> inactiveTargetTasks;

    public EntityPeatMummy(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.2f);
        this.setSpawningTicks(0);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIApproachItem((EntityCreature)this, ItemRegistry.SHIMMER_STONE, 80, 64.0f, (double)1.9f, 1.5){

            @Override
            protected double getNearSpeed() {
                if (EntityPeatMummy.this.isCharging()) {
                    return 1.0;
                }
                return super.getNearSpeed();
            }

            @Override
            protected double getFarSpeed() {
                if (EntityPeatMummy.this.isCharging()) {
                    return 1.0;
                }
                return super.getFarSpeed();
            }

            @Override
            protected void onPickup() {
                EntityPeatMummy entity = EntityPeatMummy.this;
                if (entity.isCharging()) {
                    entity.stopCharging();
                }
                entity.setCarryShimmerstone(true);
            }
        });
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true){

            protected double func_179512_a(EntityLivingBase attackTarget) {
                return 0.8 + (double)attackTarget.field_70130_N;
            }
        });
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPeatMummyCharge(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.activeTargetTasks = new ArrayList<EntityAIBase>();
        this.activeTargetTasks.add((EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.activeTargetTasks.add((EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.inactiveTargetTasks = new ArrayList<EntityAIBase>();
        this.inactiveTargetTasks.add((EntityAIBase)new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, false){

            protected double func_111175_f() {
                return EntityPeatMummy.this.func_110148_a(SPAWN_RANGE_ATTRIB).func_111126_e();
            }
        });
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(110.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(CARRY_SHIMMERSTONE);
        this.func_110140_aT().func_111150_b(IS_BOSS);
        this.func_110140_aT().func_111150_b(SPAWN_LENGTH_ATTRIB);
        this.func_110140_aT().func_111150_b(SPAWN_OFFSET_ATTRIB);
        this.func_110140_aT().func_111150_b(SPAWN_RANGE_ATTRIB);
        this.func_110140_aT().func_111150_b(CHARGING_COOLDOWN_ATTRIB);
        this.func_110140_aT().func_111150_b(CHARGING_PREPARATION_SPEED_ATTRIB);
        this.func_110140_aT().func_111150_b(CHARGING_TIME_ATTRIB);
        this.func_110140_aT().func_111150_b(CHARGING_SPEED_ATTRIB);
        this.func_110140_aT().func_111150_b(CHARGING_DAMAGE_MULTIPLIER_ATTRIB);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SPAWNING_TICKS, (Object)0);
        this.func_184212_Q().func_187214_a(CHARGING_STATE, (Object)0);
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.getChargingState() == 1;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("spawningTicks", this.getSpawningTicks());
        nbt.func_74768_a("chargingPreparation", this.chargingPreparation);
        nbt.func_74774_a("chargingState", ((Byte)this.func_184212_Q().func_187225_a(CHARGING_STATE)).byteValue());
        super.func_70014_b(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("spawningTicks")) {
            this.setSpawningTicks(nbt.func_74762_e("spawningTicks"));
        }
        if (nbt.func_74764_b("chargingPreparation")) {
            this.chargingPreparation = nbt.func_74762_e("chargingPreparation");
        }
        if (nbt.func_74764_b("chargingState")) {
            this.func_184212_Q().func_187227_b(CHARGING_STATE, (Object)nbt.func_74771_c("chargingState"));
        }
        super.func_70037_a(nbt);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevSpawningOffset = this.getSpawningOffset();
        this.prevSpawningProgress = this.getSpawningProgress();
        if (!this.field_70170_p.field_72995_K) {
            if (this.shouldUpdateSpawningAnimation()) {
                if (this.getSpawningTicks() == 0) {
                    this.func_184185_a(SoundRegistry.PEAT_MUMMY_EMERGE, 1.2f, 1.0f);
                }
                this.updateSpawningTicks();
            } else if (this.getSpawningTicks() > 0) {
                this.setSpawningFinished();
            }
            if (this.isInValidSpawn() && !this.isSpawningFinished()) {
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.field_70133_I = true;
                int breakPoint = this.getSpawningLength() / 5;
                if ((this.getSpawningTicks() - breakPoint / 2 - 1) % breakPoint == 0) {
                    BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                    IBlockState blockState = this.field_70170_p.func_180495_p(pos);
                    this.func_184185_a(blockState.func_177230_c().func_185467_w().func_185845_c(), this.field_70146_Z.nextFloat() * 0.3f + 0.3f, this.field_70146_Z.nextFloat() * 0.15f + 0.7f);
                }
                if (this.func_70638_az() != null) {
                    this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 360.0f);
                }
                if (this.getSpawningTicks() == this.getSpawningLength() - 1) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
            } else {
                this.setSpawningFinished();
            }
        } else if (this.getSpawningProgress() != 0.0f && this.getSpawningProgress() != 1.0f) {
            int breakPoint = this.getSpawningLength() / 5;
            if ((this.getSpawningTicks() - breakPoint / 2 - 1) % breakPoint == 0) {
                BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                IBlockState blockState = this.field_70170_p.func_180495_p(pos);
                double px = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                double py = this.field_70163_u + this.field_70146_Z.nextDouble() * 0.2 + 0.075;
                double pz = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                int amount = this.field_70146_Z.nextInt(20) + 15;
                for (int i = 0; i < amount; ++i) {
                    double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                    double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                    double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                    double motionY = this.field_70146_Z.nextDouble() * 0.25 + 0.1;
                    double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, px + ox, py, pz + oz, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)blockState)});
                }
            }
        }
        if (this.isSpawningFinished()) {
            this.prevScreamTimer = this.screamTimer;
            if (this.isPreparing() && this.screamTimer == 0) {
                this.screaming = true;
                this.screamTimer = 1;
            }
            if (this.screamTimer > 0) {
                ++this.screamTimer;
            }
            this.screaming = this.screamTimer < 50 && this.isPreparing();
            if (!this.isPreparing()) {
                this.screamTimer = 0;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.isPreparing()) {
                    ++this.chargingPreparation;
                    if (this.getPreparationProgress() == 1.0f) {
                        this.chargingPreparation = 0;
                        this.setChargingState(2);
                    }
                }
                if (this.isCharging()) {
                    this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0 * this.func_110148_a(CHARGING_DAMAGE_MULTIPLIER_ATTRIB).func_111126_e());
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110148_a(CHARGING_SPEED_ATTRIB).func_111126_e());
                } else {
                    this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
                }
            }
        }
    }

    public boolean shouldUpdateSpawningAnimation() {
        return this.func_70638_az() != null;
    }

    public boolean isInValidSpawn() {
        int ebx = MathHelper.func_76128_c((double)this.field_70165_t);
        int eby = MathHelper.func_76128_c((double)this.field_70163_u);
        int ebz = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.inMud(ebx, eby, ebz);
    }

    private boolean inMud(int ebx, int eby, int ebz) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = -MathHelper.func_76143_f((double)this.getMaxSpawnOffset()); y < 0; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    IBlockState blockState = this.field_70170_p.func_180495_p((BlockPos)pos.func_181079_c(ebx + x, eby + y, ebz + z));
                    Block cb = blockState.func_177230_c();
                    if (y != -1 ? cb.func_149662_c(blockState) || SPAWN_BLOCKS.contains(cb) : SPAWN_BLOCKS.contains(cb)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void func_70100_b_(EntityPlayer player) {
        if (this.isSpawningFinished()) {
            super.func_70100_b_(player);
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && this.isSpawningFinished() && this.getChargingState() == 0;
    }

    public int func_70641_bl() {
        return 2;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return !source.equals(DamageSource.field_76368_d) && super.func_70097_a(source, damage);
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.isInValidSpawn();
    }

    public boolean func_70652_k(Entity entity) {
        if (this.isCharging()) {
            this.stopCharging();
        }
        if (this.isSpawningFinished()) {
            return super.func_70652_k(entity);
        }
        return false;
    }

    public void func_70642_aH() {
        if (this.isSpawningFinished()) {
            super.func_70642_aH();
        }
    }

    public void startCharging() {
        this.func_184185_a(SoundRegistry.PEAT_MUMMY_CHARGE, 1.75f, (this.field_70146_Z.nextFloat() * 0.4f + 0.8f) * 0.8f);
        this.setChargingState(1);
    }

    public void stopCharging() {
        this.setChargingState(0);
        this.chargingPreparation = 0;
    }

    public float getSpawningOffset() {
        return (float)(-this.getMaxSpawnOffset() + (double)this.getSpawningProgress() * this.getMaxSpawnOffset());
    }

    public float getInterpolatedSpawningOffset(float partialTicks) {
        return this.prevSpawningOffset + (this.getSpawningOffset() - this.prevSpawningOffset) * partialTicks;
    }

    public double getMaxSpawnOffset() {
        return this.func_110148_a(SPAWN_OFFSET_ATTRIB).func_111126_e();
    }

    public void setSpawningTicks(int ticks) {
        block6: {
            this.func_184212_Q().func_187227_b(SPAWNING_TICKS, (Object)ticks);
            if (this.field_70170_p.field_72995_K) break block6;
            if (this.isSpawningFinished()) {
                for (EntityAIBase task : this.inactiveTargetTasks) {
                    this.field_70715_bh.func_85156_a(task);
                }
                for (int i = 0; i < this.activeTargetTasks.size(); ++i) {
                    this.field_70715_bh.func_75776_a(i, this.activeTargetTasks.get(i));
                }
            } else {
                for (EntityAIBase task : this.activeTargetTasks) {
                    this.field_70715_bh.func_85156_a(task);
                }
                for (int i = 0; i < this.inactiveTargetTasks.size(); ++i) {
                    this.field_70715_bh.func_75776_a(i, this.inactiveTargetTasks.get(i));
                }
            }
        }
    }

    public int getSpawningTicks() {
        return (Integer)this.func_184212_Q().func_187225_a(SPAWNING_TICKS);
    }

    public int getSpawningLength() {
        return (int)this.func_110148_a(SPAWN_LENGTH_ATTRIB).func_111126_e();
    }

    public double getSpawningRange() {
        return this.func_110148_a(SPAWN_RANGE_ATTRIB).func_111126_e();
    }

    public float getSpawningProgress() {
        if (this.getSpawningLength() == 0) {
            return 1.0f;
        }
        return 1.0f / (float)this.getSpawningLength() * (float)this.getSpawningTicks();
    }

    public float getInterpolatedSpawningProgress(float partialTicks) {
        return this.prevSpawningProgress + (this.getSpawningProgress() - this.prevSpawningProgress) * partialTicks;
    }

    public void updateSpawningTicks() {
        int spawningTicks = this.getSpawningTicks();
        if (spawningTicks < this.getSpawningLength()) {
            this.setSpawningTicks(spawningTicks + 1);
        }
    }

    public void resetSpawningState() {
        this.setSpawningTicks(0);
    }

    public void setSpawningFinished() {
        if (this.isSpawningFinished()) {
            return;
        }
        this.setSpawningTicks(this.getSpawningLength());
    }

    public boolean isSpawningFinished() {
        return this.getSpawningTicks() == this.getSpawningLength();
    }

    public int getMaxChargingCooldown() {
        return (int)this.func_110148_a(CHARGING_COOLDOWN_ATTRIB).func_111126_e();
    }

    public void setChargingState(int state) {
        this.func_184212_Q().func_187227_b(CHARGING_STATE, (Object)((byte)state));
    }

    public byte getChargingState() {
        return (Byte)this.func_184212_Q().func_187225_a(CHARGING_STATE);
    }

    public boolean isPreparing() {
        return this.getChargingState() == 1;
    }

    public boolean isCharging() {
        return this.getChargingState() == 2;
    }

    public float getPreparationProgress() {
        return 1.0f / (float)((int)this.func_110148_a(CHARGING_PREPARATION_SPEED_ATTRIB).func_111126_e()) * (float)this.chargingPreparation;
    }

    public boolean isScreaming() {
        return this.screaming;
    }

    public float getScreamingProgress(float delta) {
        return 0.02f * ((float)this.prevScreamTimer + (float)(this.screamTimer - this.prevScreamTimer) * delta);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.PEAT_MUMMY_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.PEAT_MUMMY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.PEAT_MUMMY_DEATH;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.PEAT_MUMMY;
    }

    public void setCarryShimmerstone(boolean shimmerStone) {
        this.func_110148_a(CARRY_SHIMMERSTONE).func_111128_a(shimmerStone ? 1.0 : 0.0);
    }

    public boolean doesCarryShimmerstone() {
        return this.func_110148_a(CARRY_SHIMMERSTONE).func_111125_b() > 0.0;
    }

    public void setBossMummy(boolean boss) {
        this.func_110148_a(IS_BOSS).func_111128_a(boss ? 1.0 : 0.0);
    }

    public boolean isBossMummy() {
        return this.func_110148_a(IS_BOSS).func_111125_b() > 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d || this.getSpawningTicks() > 0 ? this.func_174813_aQ() : ZERO_AABB;
    }

    @Override
    public float getShakeIntensity(Entity viewer, float partialTicks) {
        if (this.isScreaming()) {
            double dist = this.func_70032_d(viewer);
            float screamMult = (float)(1.0 - dist / 30.0);
            if (dist >= 30.0) {
                return 0.0f;
            }
            return (float)((Math.sin((double)this.getScreamingProgress(partialTicks) * Math.PI) + (double)0.1f) * (double)0.15f * (double)screamMult);
        }
        return 0.0f;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }

    static {
        SPAWN_BLOCKS.add(BlockRegistry.MUD);
        SPAWN_BLOCKS.add(BlockRegistry.PEAT);
    }
}

