/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.EntityShockwaveBlock;
import thebetweenlands.common.entity.mobs.EntityFortressBoss;

public class EntityFortressBossBlockade
extends EntityMob
implements IEntityBL {
    protected static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityFortressBossBlockade.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityFortressBossBlockade.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityFortressBossBlockade.class, (DataSerializer)DataSerializers.field_187193_c);
    private Entity cachedOwner;
    private float prevRotation = 0.0f;
    private float rotation = 0.0f;
    private int despawnTicks = 0;
    private int maxDespawnTicks = 160;

    public EntityFortressBossBlockade(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.2f);
    }

    public EntityFortressBossBlockade(World world, Entity source) {
        super(world);
        this.func_70105_a(1.0f, 0.2f);
        this.setOwner(source);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(ROTATION, (Object)Float.valueOf(this.rotation));
    }

    public void setOwner(@Nullable Entity entity) {
        this.func_184212_Q().func_187227_b(OWNER, (Object)(entity == null ? Optional.absent() : Optional.of((Object)entity.func_110124_au())));
    }

    @Nullable
    public UUID getOwnerUUID() {
        Optional uuid = (Optional)this.func_184212_Q().func_187225_a(OWNER);
        return uuid.isPresent() ? (UUID)uuid.get() : null;
    }

    @Nullable
    public Entity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid == null) {
            this.cachedOwner = null;
        } else if (this.cachedOwner == null || !this.cachedOwner.func_70089_S() || !this.cachedOwner.func_110124_au().equals(uuid)) {
            this.cachedOwner = null;
            for (Entity entity : this.func_130014_f_().func_72872_a(Entity.class, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0))) {
                if (!entity.func_110124_au().equals(uuid)) continue;
                this.cachedOwner = entity;
                break;
            }
        }
        return this.cachedOwner;
    }

    public void setTriangleSize(float size) {
        this.func_184212_Q().func_187227_b(SIZE, (Object)Float.valueOf(size));
        if (this.field_70170_p.field_72995_K) {
            double prevX = this.field_70165_t;
            double prevZ = this.field_70161_v;
            this.func_70105_a(size * 2.0f, this.field_70131_O);
            this.func_70107_b(prevX, this.field_70163_u, prevZ);
        }
    }

    public float getTriangleSize() {
        return ((Float)this.func_184212_Q().func_187225_a(SIZE)).floatValue();
    }

    public void setMaxDespawnTicks(int ticks) {
        this.maxDespawnTicks = ticks;
    }

    public int getMaxDespawnTicks() {
        return this.maxDespawnTicks;
    }

    public int getDespawnTicks() {
        return this.despawnTicks;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("triangleSize", this.getTriangleSize());
        nbt.func_74776_a("triangleRotation", ((Float)this.func_184212_Q().func_187225_a(ROTATION)).floatValue());
        nbt.func_74768_a("despawnTicks", this.despawnTicks);
        nbt.func_74768_a("maxDespawnTicks", this.maxDespawnTicks);
        if (this.getOwnerUUID() != null) {
            nbt.func_186854_a("owner", this.getOwnerUUID());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTriangleSize(nbt.func_74760_g("triangleSize"));
        this.func_184212_Q().func_187227_b(ROTATION, (Object)Float.valueOf(nbt.func_74760_g("triangleRotation")));
        this.despawnTicks = nbt.func_74762_e("despawnTicks");
        this.maxDespawnTicks = nbt.func_74762_e("maxDespawnTicks");
        if (nbt.func_186855_b("owner")) {
            this.func_184212_Q().func_187227_b(OWNER, (Object)Optional.of((Object)nbt.func_186857_a("owner")));
        } else {
            this.func_184212_Q().func_187227_b(OWNER, (Object)Optional.absent());
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL || this.getOwner() != null && !this.getOwner().func_70089_S())) {
            this.func_70106_y();
            return;
        }
        this.setTriangleSize(this.getTriangleSize());
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            ++this.despawnTicks;
            if (this.despawnTicks >= this.getMaxDespawnTicks()) {
                this.func_70106_y();
            }
            this.rotation += 1.0f;
            this.func_184212_Q().func_187227_b(ROTATION, (Object)Float.valueOf(this.rotation));
            List targets = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b((double)(this.getTriangleSize() * 2.0f), 0.0, (double)(this.getTriangleSize() * 2.0f)));
            for (EntityPlayer target : targets) {
                EntityLivingBase owner;
                float damage;
                Vec3d[] vertices = this.getTriangleVertices(1.0f);
                if (!EntityFortressBoss.rayTraceTriangle(new Vec3d(target.field_70165_t - this.field_70165_t, 1.0, target.field_70161_v - this.field_70161_v), new Vec3d(0.0, -2.0, 0.0), vertices[0], vertices[1], vertices[2]) || !target.func_70097_a(DamageSource.field_76376_m, damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()) || this.getOwner() == null || !(this.getOwner() instanceof EntityLivingBase) || !((owner = (EntityLivingBase)this.getOwner()).func_110143_aJ() < owner.func_110138_aP() - damage)) continue;
                owner.func_70691_i(damage * 3.0f);
            }
        } else {
            this.prevRotation = this.rotation;
            this.rotation = ((Float)this.func_184212_Q().func_187225_a(ROTATION)).floatValue();
            for (int c = 0; c < 4; ++c) {
                float r1 = this.field_70170_p.field_73012_v.nextFloat();
                float r2 = this.field_70170_p.field_73012_v.nextFloat();
                this.rotation += 15.0f;
                Vec3d[] vertices = this.getTriangleVertices(1.0f);
                this.rotation -= 15.0f;
                double xc = 0.0;
                double zc = 0.0;
                block6: for (int i = 0; i < 3; ++i) {
                    Vec3d vertex = vertices[i];
                    switch (i) {
                        default: {
                            xc += vertex.field_72450_a * (1.0 - Math.sqrt(r1));
                            zc += vertex.field_72449_c * (1.0 - Math.sqrt(r1));
                            continue block6;
                        }
                        case 1: {
                            xc += Math.sqrt(r1) * (double)(1.0f - r2) * vertex.field_72450_a;
                            zc += Math.sqrt(r1) * (double)(1.0f - r2) * vertex.field_72449_c;
                            continue block6;
                        }
                        case 2: {
                            xc += Math.sqrt(r1) * (double)r2 * vertex.field_72450_a;
                            zc += Math.sqrt(r1) * (double)r2 * vertex.field_72449_c;
                        }
                    }
                }
                Vec3d rp = new Vec3d(xc, vertices[0].field_72448_b, zc);
                double sx = this.field_70165_t + rp.field_72450_a;
                double sy = this.field_70163_u + rp.field_72448_b + 4.0;
                double sz = this.field_70161_v + rp.field_72449_c;
                double ex = this.field_70165_t + rp.field_72450_a;
                double ey = this.field_70163_u + rp.field_72448_b;
                double ez = this.field_70161_v + rp.field_72449_c;
                if (this.getOwner() != null) {
                    sx = this.getOwner().field_70165_t;
                    sy = this.getOwner().func_174813_aQ().field_72338_b + (this.getOwner().func_174813_aQ().field_72337_e - this.getOwner().func_174813_aQ().field_72338_b) / 2.0;
                    sz = this.getOwner().field_70161_v;
                }
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, sx, sy, sz, ex - sx, ey - sy, ez - sz, new int[0]);
            }
        }
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, up, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else {
            float friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            float groundFriction = 0.16277136f / (friction * friction * friction);
            this.func_191958_b(strafe, up, forward, this.field_70122_E ? 0.1f * groundFriction : 0.02f);
            friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)friction;
            this.field_70181_x *= (double)friction;
            this.field_70179_y *= (double)friction;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double dx = this.field_70165_t - this.field_70169_q;
        double dz = this.field_70161_v - this.field_70166_s;
        float distanceMoved = MathHelper.func_76133_a((double)(dx * dx + dz * dz)) * 4.0f;
        if (distanceMoved > 1.0f) {
            distanceMoved = 1.0f;
        }
        this.field_70721_aZ += (distanceMoved - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public Vec3d[] getTriangleVertices(float partialTicks) {
        Vec3d[] vertices = new Vec3d[3];
        double rot = Math.toRadians(this.prevRotation + (this.rotation - this.prevRotation) * partialTicks);
        double angle = 2.0943951023931953;
        for (int i = 0; i < 3; ++i) {
            double sin = Math.sin(angle * (double)i + rot);
            double cos = Math.cos(angle * (double)i + rot);
            vertices[i] = new Vec3d(sin * (double)this.getTriangleSize(), 0.0, cos * (double)this.getTriangleSize());
        }
        return vertices;
    }

    public boolean func_70652_k(Entity target) {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_180431_b(DamageSource source) {
        return !DamageSource.field_76380_i.func_76355_l().equals(source.func_76355_l()) && !(source.func_76364_f() instanceof EntityShockwaveBlock);
    }

    public boolean func_190530_aW() {
        return true;
    }
}

