/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai.gecko;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import thebetweenlands.common.entity.mobs.EntityGecko;
import thebetweenlands.common.registries.BlockRegistry;

public abstract class EntityAIGeckoHide
extends EntityAIBase {
    private final Comparator<BlockPos> closest = (a, b) -> {
        double bLength;
        double aLength = a.func_185332_f(0, 0, 0);
        return aLength < (bLength = b.func_185332_f(0, 0, 0)) ? -1 : (aLength > bLength ? 1 : 0);
    };
    protected final EntityGecko gecko;
    private double farSpeed;
    private double nearSpeed;
    private Path path;
    private PathNavigate navigator;
    private boolean bushBound;
    private BlockPos target;

    public EntityAIGeckoHide(EntityGecko gecko, double farSpeed, double nearSpeed) {
        this.gecko = gecko;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        this.navigator = gecko.func_70661_as();
        this.func_75248_a(1);
    }

    @Nullable
    protected abstract Vec3d getFleeingCausePosition();

    protected abstract boolean shouldFlee();

    public boolean func_75250_a() {
        if (this.gecko.isHiding()) {
            return false;
        }
        if (!this.shouldFlee()) {
            return false;
        }
        Vec3d fleeingCausePos = this.getFleeingCausePosition();
        this.target = this.findNearBush();
        if (this.target == null) {
            Vec3d target;
            Vec3d vec3d = target = fleeingCausePos != null ? RandomPositionGenerator.func_75461_b((EntityCreature)this.gecko, (int)16, (int)7, (Vec3d)fleeingCausePos) : RandomPositionGenerator.func_75461_b((EntityCreature)this.gecko, (int)16, (int)7, (Vec3d)this.gecko.func_174791_d());
            if (target != null) {
                this.target = new BlockPos(target);
            }
        } else {
            this.bushBound = true;
        }
        if (this.target == null) {
            return false;
        }
        if (!this.bushBound && fleeingCausePos != null && fleeingCausePos.func_186679_c((double)this.target.func_177958_n(), (double)this.target.func_177956_o(), (double)this.target.func_177952_p()) < fleeingCausePos.func_72436_e(this.gecko.func_174791_d())) {
            return false;
        }
        this.path = this.navigator.func_179680_a(this.target);
        if (this.doesGeckoNeighborBush(this.target)) {
            this.gecko.setHidingBush(new BlockPos((Vec3i)this.target));
            this.gecko.startHiding();
            return false;
        }
        if (this.path != null) {
            PathPoint finalPathPoint = this.path.func_75870_c();
            return finalPathPoint.field_75839_a == this.target.func_177958_n() && finalPathPoint.field_75837_b == this.target.func_177956_o() && finalPathPoint.field_75838_c == this.target.func_177952_p() || this.bushBound && this.doesPathDestinationNeighborBush(this.target, this.path);
        }
        return false;
    }

    private boolean doesGeckoNeighborBush(BlockPos target) {
        BlockPos geckoPos = new BlockPos((Entity)this.gecko);
        for (EnumFacing facing : EnumFacing.values()) {
            if (!target.func_177972_a(facing).equals((Object)geckoPos)) continue;
            return true;
        }
        return false;
    }

    private boolean doesPathDestinationNeighborBush(BlockPos target, Path path) {
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos nearTarget = new BlockPos((Vec3i)target.func_177972_a(facing));
            PathPoint finalPathPoint = path.func_75870_c();
            if (finalPathPoint.field_75839_a != nearTarget.func_177958_n() || finalPathPoint.field_75837_b != nearTarget.func_177956_o() || finalPathPoint.field_75838_c != nearTarget.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    private BlockPos findNearBush() {
        int radius = 8;
        BlockPos center = new BlockPos((Entity)this.gecko);
        Random rand = this.gecko.func_70681_au();
        ArrayList<BlockPos> bushes = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dx = -8; dx <= 8; ++dx) {
            for (int dy = -4; dy <= 8; ++dy) {
                for (int dz = -8; dz <= 8; ++dz) {
                    pos.func_181079_c(center.func_177958_n() + dx, center.func_177956_o() + dy, center.func_177952_p() + dz);
                    IBlockState state = this.gecko.field_70170_p.func_180495_p((BlockPos)pos);
                    if (state.func_177230_c() != BlockRegistry.WEEDWOOD_BUSH || !this.gecko.field_70170_p.func_175677_d(pos.func_177977_b(), false) || !this.gecko.field_70170_p.func_175647_a(EntityGecko.class, new AxisAlignedBB((BlockPos)pos), e -> e != this.gecko).isEmpty()) continue;
                    bushes.add(pos.func_177973_b((Vec3i)center));
                }
            }
        }
        if (bushes.size() == 0) {
            return null;
        }
        Collections.sort(bushes, this.closest);
        double targetDistance = ((BlockPos)bushes.get(0)).func_185332_f(0, 0, 0);
        double epsilon = 1.0E-8;
        int bushCount = bushes.size();
        for (int i = 0; i < bushCount; ++i) {
            boolean end;
            boolean bl = end = i == bushCount - 1;
            if (!(Math.abs(((BlockPos)bushes.get(i)).func_185332_f(0, 0, 0) - targetDistance) > 1.0E-8) && !end) continue;
            return ((BlockPos)bushes.get(rand.nextInt(end ? i + 1 : i))).func_177971_a((Vec3i)center);
        }
        throw new ConcurrentModificationException("I'm not sure how I feel about this...");
    }

    public boolean func_75253_b() {
        if (this.target != null && !this.gecko.field_70170_p.func_175647_a(EntityGecko.class, new AxisAlignedBB(this.target), e -> e != this.gecko).isEmpty()) {
            return false;
        }
        return !this.navigator.func_75500_f();
    }

    public void func_75249_e() {
        this.navigator.func_75484_a(this.path, this.farSpeed);
        this.gecko.setHidingBush(this.target);
    }

    public void func_75251_c() {
        if (this.bushBound && this.path.func_75879_b()) {
            this.gecko.startHiding();
        }
        this.bushBound = false;
    }

    public void func_75246_d() {
        Vec3d fleeingCausePos = this.getFleeingCausePosition();
        if (fleeingCausePos != null && this.gecko.func_174791_d().func_72436_e(fleeingCausePos) < 49.0) {
            this.gecko.func_70661_as().func_75489_a(this.nearSpeed);
        } else {
            this.gecko.func_70661_as().func_75489_a(this.farSpeed);
        }
    }
}

