/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.foodsickness;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IFoodSicknessCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.capability.foodsickness.FoodSickness;
import thebetweenlands.common.handler.FoodSicknessHandler;
import thebetweenlands.common.registries.CapabilityRegistry;

public class FoodSicknessEntityCapability
extends EntityCapability<FoodSicknessEntityCapability, IFoodSicknessCapability, EntityPlayer>
implements IFoodSicknessCapability,
ISerializableCapability {
    private Map<Item, Integer> hatredMap = Maps.newHashMap();
    private FoodSickness lastSickness = FoodSickness.FINE;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "food_sickness");
    }

    @Override
    protected Capability<IFoodSicknessCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_FOOD_SICKNESS;
    }

    @Override
    protected Class<IFoodSicknessCapability> getCapabilityClass() {
        return IFoodSicknessCapability.class;
    }

    @Override
    protected FoodSicknessEntityCapability getDefaultCapabilityImplementation() {
        return new FoodSicknessEntityCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public boolean isPersistent(EntityPlayer oldPlayer, EntityPlayer newPlayer, boolean wasDead) {
        return true;
    }

    @Override
    public FoodSickness getLastSickness() {
        return this.lastSickness;
    }

    @Override
    public void setLastSickness(FoodSickness sickness) {
        this.lastSickness = sickness;
    }

    @Override
    public FoodSickness getSickness(Item food) {
        return FoodSickness.getSicknessForHatred(this.getFoodHatred(food));
    }

    @Override
    public void decreaseHatredForAllExcept(Item food, int decrease) {
        if (decrease > 0) {
            HashMap newHatredMap = Maps.newHashMap();
            for (Item key : this.hatredMap.keySet()) {
                if (key == food) continue;
                newHatredMap.put(key, Math.max(this.hatredMap.get(key) - decrease, 0));
            }
            if (!newHatredMap.isEmpty()) {
                this.hatredMap.putAll(newHatredMap);
                this.markDirty();
            }
        }
    }

    @Override
    public void increaseFoodHatred(Item food, int amount, int decreaseForOthers) {
        if (!FoodSicknessHandler.isFoodSicknessEnabled()) {
            return;
        }
        int finalMaxHatred = FoodSickness.VALUES[Math.max((int)(FoodSickness.VALUES.length - 1), (int)0)].maxHatred;
        if (this.hatredMap.containsKey(food)) {
            int currentAmount = this.hatredMap.get(food);
            this.hatredMap.put(food, Math.max(Math.min(currentAmount + amount, finalMaxHatred), 0));
        } else {
            this.hatredMap.put(food, Math.max(Math.min(amount, finalMaxHatred), 0));
        }
        this.decreaseHatredForAllExcept(food, decreaseForOthers);
        this.markDirty();
    }

    @Override
    public int getFoodHatred(Item food) {
        if (this.hatredMap.containsKey(food)) {
            return this.hatredMap.get(food);
        }
        return 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Item, Integer> entry : this.hatredMap.entrySet()) {
            NBTTagCompound listCompound = new NBTTagCompound();
            listCompound.func_74778_a("Food", entry.getKey().getRegistryName().toString());
            listCompound.func_74768_a("Level", entry.getValue().intValue());
            list.func_74742_a((NBTBase)listCompound);
        }
        nbt.func_74782_a("HatredMap", (NBTBase)list);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.hatredMap = Maps.newHashMap();
        NBTTagList list = nbt.func_150295_c("HatredMap", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound listCompound = list.func_150305_b(i);
            Item food = Item.func_111206_d((String)listCompound.func_74779_i("Food"));
            if (food == null) continue;
            int level = listCompound.func_74762_e("Level");
            this.hatredMap.put(food, level);
        }
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 0;
    }
}

