/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.base;

import net.minecraft.entity.player.EntityPlayerMP;
import thebetweenlands.common.capability.base.EntityCapability;

public class EntityCapabilityTracker {
    private final EntityCapability<?, ?, ?> entityCapability;
    private final EntityPlayerMP watcher;
    private boolean trackerReady = false;
    private int lastUpdate = 0;
    private boolean dirty = false;

    public EntityCapabilityTracker(EntityCapability<?, ?, ?> entityCapability, EntityPlayerMP watcher) {
        this.entityCapability = entityCapability;
        this.watcher = watcher;
    }

    public void add() {
        this.entityCapability.addTracker(this);
    }

    public void remove() {
        this.entityCapability.removeTracker(this);
    }

    public void markDirty() {
        this.dirty = true;
    }

    public EntityPlayerMP getWatcher() {
        return this.watcher;
    }

    public EntityCapability<?, ?, ?> getEntityCapability() {
        return this.entityCapability;
    }

    public void update() {
        if (this.lastUpdate < this.entityCapability.getTrackingTime()) {
            ++this.lastUpdate;
        } else {
            this.trackerReady = true;
        }
        if (this.trackerReady && this.dirty) {
            this.lastUpdate = 0;
            this.trackerReady = false;
            this.entityCapability.sendPacket(this.watcher);
            this.dirty = false;
        }
    }
}

