/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.base;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.capability.base.EntityCapabilityTracker;

public class EntityCapabilityHandler {
    private static final List<EntityCapability<?, ?, ? extends Entity>> REGISTERED_CAPABILITIES = new ArrayList();
    private static final Map<ResourceLocation, EntityCapability<?, ?, ? extends Entity>> ID_CAPABILITY_MAP = new HashMap();
    private static final Map<EntityPlayerMP, List<EntityCapabilityTracker>> TRACKER_MAP = new HashMap<EntityPlayerMP, List<EntityCapabilityTracker>>();
    private static int updateTimer = 0;

    public static <T, F extends EntityCapability<F, T, E>, E extends Entity> void registerEntityCapability(EntityCapability<F, T, E> entityCapability) {
        Preconditions.checkState((boolean)entityCapability.getCapabilityClass().isAssignableFrom(entityCapability.getClass()), (String)"Entity capability %s must implement %s", (Object)entityCapability.getClass().getName(), (Object)entityCapability.getCapabilityClass().getName());
        REGISTERED_CAPABILITIES.add(entityCapability);
    }

    public static void registerCapabilities() {
        Preconditions.checkState((boolean)Loader.instance().isInState(LoaderState.PREINITIALIZATION));
        for (EntityCapability<?, ?, ? extends Entity> entityCapability : REGISTERED_CAPABILITIES) {
            EntityCapabilityHandler.registerCapability(entityCapability);
        }
    }

    public static <E extends Entity> EntityCapability<?, ?, E> getCapability(ResourceLocation id, E entity) {
        EntityCapability<?, ?, Entity> entityCapability = ID_CAPABILITY_MAP.get(id);
        if (entityCapability != null && entity.hasCapability(entityCapability.getCapability(), null)) {
            return (EntityCapability)entity.getCapability(entityCapability.getCapability(), null);
        }
        return null;
    }

    private static <T, E extends Entity> void registerCapability(final EntityCapability<?, T, E> capability) {
        CapabilityManager.INSTANCE.register(capability.getCapabilityClass(), new Capability.IStorage<T>(){

            public final NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
                if (instance instanceof ISerializableCapability) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    ((ISerializableCapability)instance).writeToNBT(nbt);
                    return nbt;
                }
                return new NBTTagCompound();
            }

            public final void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
                if (instance instanceof ISerializableCapability && nbt instanceof NBTTagCompound) {
                    ((ISerializableCapability)instance).readFromNBT((NBTTagCompound)nbt);
                }
            }
        }, new Callable<T>(){

            @Override
            public final T call() throws Exception {
                return capability.getDefaultCapabilityImplementation();
            }
        });
        ID_CAPABILITY_MAP.put(capability.getID(), capability);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        final Entity entity = (Entity)event.getObject();
        for (EntityCapability<?, ?, Entity> entityCapability : REGISTERED_CAPABILITIES) {
            if (!entityCapability.isApplicable(entity)) continue;
            final Capability capabilityInstance = entityCapability.getCapability();
            event.addCapability(entityCapability.getID(), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                private Object entityCapability = this.getNewInstance();

                private EntityCapability<?, ?, ?> getNewInstance() {
                    EntityCapability entityCapability = (EntityCapability)capabilityInstance.getDefaultInstance();
                    entityCapability.setEntity(entity);
                    entityCapability.init();
                    return entityCapability;
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == capabilityInstance;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == capabilityInstance ? this.entityCapability : null);
                }

                public NBTTagCompound serializeNBT() {
                    return this.serialize(capabilityInstance, this.entityCapability);
                }

                private <T> NBTTagCompound serialize(Capability<T> capability, Object instance) {
                    return (NBTTagCompound)capability.getStorage().writeNBT(capability, instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    this.deserialize(capabilityInstance, this.entityCapability, nbt);
                }

                private <T> void deserialize(Capability<T> capability, Object instance, NBTTagCompound nbt) {
                    capability.getStorage().readNBT(capability, instance, null, (NBTBase)nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            EntityCapabilityHandler.addTrackers(player, (Entity)player);
        }
    }

    @SubscribeEvent
    public static void onEntityChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayerMP player;
        List<EntityCapabilityTracker> trackers;
        if (!event.player.func_130014_f_().field_72995_K && event.player instanceof EntityPlayerMP && (trackers = TRACKER_MAP.get(player = (EntityPlayerMP)event.player)) != null) {
            for (EntityCapabilityTracker tracker : trackers) {
                tracker.getEntityCapability().sendPacket(tracker.getWatcher());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityStartTracking(PlayerEvent.StartTracking event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            EntityCapabilityHandler.addTrackers((EntityPlayerMP)event.getEntityPlayer(), event.getTarget());
        }
    }

    @SubscribeEvent
    public static void onEntityStopTracking(PlayerEvent.StopTracking event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            EntityCapabilityHandler.removeTrackers((EntityPlayerMP)event.getEntityPlayer(), event.getTarget());
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayerMP player;
        List<EntityCapabilityTracker> trackers;
        if (!event.player.func_130014_f_().field_72995_K && event.side == Side.SERVER && (trackers = TRACKER_MAP.get(player = (EntityPlayerMP)event.player)) != null) {
            Iterator<EntityCapabilityTracker> trackerIT = trackers.iterator();
            while (trackerIT.hasNext()) {
                Set vanillaTrackingPlayers;
                EntityCapabilityTracker tracker = trackerIT.next();
                if (tracker.getEntityCapability().getEntity() != player && ((vanillaTrackingPlayers = player.func_71121_q().func_73039_n().getTrackingPlayers(tracker.getEntityCapability().getEntity())) == null || vanillaTrackingPlayers.isEmpty() || !vanillaTrackingPlayers.contains(player))) {
                    trackerIT.remove();
                    tracker.remove();
                }
                tracker.update();
            }
        }
    }

    @SubscribeEvent
    public static void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++updateTimer > 20) {
            updateTimer = 0;
            Iterator<Map.Entry<EntityPlayerMP, List<EntityCapabilityTracker>>> it = TRACKER_MAP.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<EntityPlayerMP, List<EntityCapabilityTracker>> entry = it.next();
                EntityPlayerMP player = entry.getKey();
                if (player.func_71121_q().func_73046_m() == null || player.func_71121_q().func_73046_m().func_184103_al().func_181057_v().contains(player)) continue;
                it.remove();
                for (EntityCapabilityTracker tracker : entry.getValue()) {
                    tracker.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        EntityPlayer newPlayer = event.getEntityPlayer();
        List<EntityCapability<?, ?, EntityPlayer>> capabilities = EntityCapabilityHandler.getEntityCapabilities(oldPlayer);
        for (EntityCapability<?, ?, EntityPlayer> capability : capabilities) {
            EntityCapability<?, ?, EntityPlayer> newCapability;
            if (!capability.isPersistent(oldPlayer, newPlayer, event.isWasDeath()) || !(capability instanceof ISerializableCapability) || (newCapability = capability.getEntityCapability(newPlayer)) == null || !(newCapability instanceof ISerializableCapability)) continue;
            capability.clonePersistentData(oldPlayer, newPlayer, event.isWasDeath(), (ISerializableCapability)((Object)newCapability));
        }
    }

    private static <E extends Entity> List<EntityCapability<?, ?, E>> getEntityCapabilities(E entity) {
        ArrayList capabilities = new ArrayList();
        for (EntityCapability<?, ?, Entity> capability : REGISTERED_CAPABILITIES) {
            if (!entity.hasCapability(capability.getCapability(), null)) continue;
            capabilities.add((EntityCapability)entity.getCapability(capability.getCapability(), null));
        }
        return capabilities;
    }

    private static void addTrackers(EntityPlayerMP watcher, Entity target) {
        List<EntityCapability<?, ?, Entity>> entityCapabilities = EntityCapabilityHandler.getEntityCapabilities(target);
        for (EntityCapability<?, ?, Entity> capability : entityCapabilities) {
            if (capability.getTrackingTime() < 0) continue;
            List<EntityCapabilityTracker> trackers = TRACKER_MAP.get(watcher);
            if (trackers == null) {
                trackers = new ArrayList<EntityCapabilityTracker>();
                TRACKER_MAP.put(watcher, trackers);
            }
            EntityCapabilityTracker tracker = new EntityCapabilityTracker(capability, watcher);
            trackers.add(tracker);
            tracker.add();
            capability.sendPacket(watcher);
        }
    }

    private static void removeTrackers(EntityPlayerMP watcher, Entity target) {
        List<EntityCapabilityTracker> trackers = TRACKER_MAP.get(watcher);
        if (trackers != null) {
            List<EntityCapability<?, ?, Entity>> entityCapabilities = EntityCapabilityHandler.getEntityCapabilities(target);
            for (EntityCapability<?, ?, Entity> capability : entityCapabilities) {
                if (capability.getTrackingTime() < 0) continue;
                Iterator<EntityCapabilityTracker> it = trackers.iterator();
                while (it.hasNext()) {
                    EntityCapabilityTracker tracker = it.next();
                    if (tracker.getEntityCapability() != capability) continue;
                    it.remove();
                    tracker.remove();
                }
            }
            if (trackers.isEmpty()) {
                TRACKER_MAP.remove(watcher);
            }
        }
    }
}

