/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.sky;

import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.world.World;
import thebetweenlands.api.sky.IRiftMaskRenderer;
import thebetweenlands.api.sky.IRiftRenderer;
import thebetweenlands.api.sky.IRiftSkyRenderer;
import thebetweenlands.client.render.shader.ResizableFramebuffer;
import thebetweenlands.client.render.sky.OverworldRiftSkyRenderer;
import thebetweenlands.client.render.sky.RiftMaskRenderer;
import thebetweenlands.common.world.event.EventRift;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.util.RenderUtils;

public class RiftRenderer
implements IRiftRenderer {
    protected final int skyDomeDispList;
    private static ResizableFramebuffer overworldSkyFbo;
    private final FloatBuffer textureMatrix = GLAllocation.func_74529_h((int)16);
    private final FloatBuffer modelviewMatrix = GLAllocation.func_74529_h((int)16);
    private final FloatBuffer projectionMatrix = GLAllocation.func_74529_h((int)16);
    private final FloatBuffer buffer4f = GLAllocation.func_74529_h((int)16);
    private IRiftMaskRenderer riftMaskRenderer;
    private IRiftSkyRenderer riftSkyRenderer;
    private static RiftMaskRenderer blRiftMaskRenderer;
    private static OverworldRiftSkyRenderer blRiftSkyRenderer;

    public RiftRenderer(int skyDomeDispList) {
        this.skyDomeDispList = skyDomeDispList;
        if (overworldSkyFbo == null) {
            overworldSkyFbo = new ResizableFramebuffer(true);
        }
        if (blRiftMaskRenderer == null) {
            blRiftMaskRenderer = new RiftMaskRenderer(this.skyDomeDispList);
        }
        if (blRiftSkyRenderer == null) {
            blRiftSkyRenderer = new OverworldRiftSkyRenderer();
        }
        this.setRiftMaskRenderer(blRiftMaskRenderer);
        this.setRiftSkyRenderer(blRiftSkyRenderer);
    }

    private FloatBuffer getBuffer4f(float v1, float v2, float v3, float v4) {
        this.buffer4f.clear();
        this.buffer4f.put(v1).put(v2).put(v3).put(v4);
        this.buffer4f.flip();
        return this.buffer4f;
    }

    @Override
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        EventRift rift;
        if (OpenGlHelper.func_148822_b() && (rift = BetweenlandsWorldStorage.forWorld((World)world).getEnvironmentEventRegistry().rift).getActivationTicks() > 0 && rift.getVisibility(partialTicks) > 0.0f) {
            int parentFboId = RenderUtils.getBoundFramebuffer();
            Framebuffer mcFbo = mc.func_147110_a();
            Framebuffer skyFbo = overworldSkyFbo.getFramebuffer(mcFbo.field_147621_c, mcFbo.field_147618_d);
            skyFbo.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
            skyFbo.func_147614_f();
            skyFbo.func_147610_a(false);
            GlStateManager.func_179092_a((int)516, (float)0.5f);
            GlStateManager.func_179089_o();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179090_x();
            GlStateManager.func_179094_E();
            this.riftSkyRenderer.setClearColor(partialTicks, world, mc);
            GlStateManager.func_179086_m((int)16640);
            this.riftSkyRenderer.render(partialTicks, world, mc);
            GlStateManager.func_179121_F();
            float skyBrightness = this.riftSkyRenderer.getSkyBrightness(partialTicks, world, mc);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
            RenderHelper.func_74518_a();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179106_n();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179151_a((double)1.0);
            GlStateManager.func_179086_m((int)16640);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            if (OpenGlHelper.field_148828_i) {
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            } else {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            this.riftMaskRenderer.renderMask(partialTicks, world, mc, skyBrightness);
            if (parentFboId != -1) {
                OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)parentFboId);
            } else {
                mcFbo.func_147610_a(true);
            }
            mc.field_71460_t.func_191514_d(false);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179106_n();
            GlStateManager.func_179144_i((int)skyFbo.field_147617_g);
            GlStateManager.func_179111_a((int)2982, (FloatBuffer)this.modelviewMatrix);
            GlStateManager.func_179111_a((int)2983, (FloatBuffer)this.projectionMatrix);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9216);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9216);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9216);
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9474, (FloatBuffer)this.getBuffer4f(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9474, (FloatBuffer)this.getBuffer4f(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9474, (FloatBuffer)this.getBuffer4f(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            GlStateManager.func_179110_a((FloatBuffer)this.projectionMatrix);
            GlStateManager.func_179110_a((FloatBuffer)this.modelviewMatrix);
            this.riftMaskRenderer.renderRiftProjection(partialTicks, world, mc, skyBrightness);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.R);
            this.riftMaskRenderer.renderOverlay(partialTicks, world, mc, skyBrightness);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179126_j();
        }
    }

    @Override
    public void setRiftMaskRenderer(IRiftMaskRenderer maskRenderer) {
        this.riftMaskRenderer = maskRenderer;
    }

    @Override
    public IRiftMaskRenderer getRiftMaskRenderer() {
        return this.riftMaskRenderer;
    }

    @Override
    public void setRiftSkyRenderer(IRiftSkyRenderer skyRenderer) {
        this.riftSkyRenderer = skyRenderer;
    }

    @Override
    public IRiftSkyRenderer getRiftSkyRenderer() {
        return this.riftSkyRenderer;
    }
}

