/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.particle.Particle;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.client.handler.TextureStitchHandler;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.client.render.sprite.TextureAnimation;

public class ParticleAnimated
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    protected TextureAnimation animation;

    public ParticleAnimated(World world, double x, double y, double z, double mx, double my, double mz, int maxAge, float scale) {
        this(world, x, y, z, mx, my, mz, maxAge, scale, true);
    }

    public ParticleAnimated(World world, double x, double y, double z, double mx, double my, double mz, int maxAge, float scale, boolean randomStart) {
        super(world, x, y, z);
        this.field_187126_f = this.field_187123_c = x;
        this.field_187127_g = this.field_187124_d = y;
        this.field_187128_h = this.field_187125_e = z;
        this.field_187129_i = mx;
        this.field_187130_j = my;
        this.field_187131_k = mz;
        this.field_70544_f = scale;
        this.animation = new TextureAnimation();
        if (randomStart) {
            this.animation.setRandomStart(this.field_187136_p);
        }
        this.field_70547_e = maxAge;
    }

    public int func_70537_b() {
        return 1;
    }

    @Override
    public void setStitchedSprites(TextureStitchHandler.Frame[][] frames) {
        if (this.animation != null && frames != null) {
            this.animation.setFrames(frames[0]);
            if (this.field_70547_e < 0) {
                this.field_70547_e = this.animation.getTotalDuration() - 1;
            }
            if (this.field_187119_C == null) {
                this.func_187117_a(frames[0][0].getSprite());
            }
        }
    }

    public void func_189213_a() {
        this.animation.update();
        this.func_187117_a(this.animation.getCurrentSprite());
        super.func_189213_a();
    }

    public static final class SpawnerFactory
    extends ParticleFactory<PortalFactory, ParticleAnimated> {
        public SpawnerFactory() {
            super(ParticleAnimated.class, ParticleTextureStitcher.create(ParticleAnimated.class, new ResourceLocation("thebetweenlands:particle/spawner")).setSplitAnimations(true));
        }

        @Override
        public ParticleAnimated createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleAnimated(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getInt(0), args.scale){
                private float startAlpha;
                {
                    super(world, x, y, z, mx, my, mz, maxAge, scale);
                    this.startAlpha = this.field_82339_as;
                }

                public void func_82338_g(float alpha) {
                    super.func_82338_g(alpha);
                    this.startAlpha = alpha;
                }

                @Override
                public void func_189213_a() {
                    super.func_189213_a();
                    if (this.field_70546_d > this.field_70547_e - 40) {
                        this.field_82339_as = this.startAlpha * (float)(this.field_70547_e - this.field_70546_d) / 40.0f;
                    }
                }
            };
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(80);
        }
    }

    public static final class PortalFactory
    extends ParticleFactory<PortalFactory, ParticleAnimated> {
        public PortalFactory() {
            super(ParticleAnimated.class, ParticleTextureStitcher.create(ParticleAnimated.class, new ResourceLocation("thebetweenlands:particle/portal")).setSplitAnimations(true));
        }

        @Override
        public ParticleAnimated createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleAnimated(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getInt(0), args.scale);
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(40);
        }
    }

    public static final class GenericFactory
    extends ParticleFactory<GenericFactory, ParticleAnimated> {
        public GenericFactory(ResourceLocation texture) {
            super(ParticleAnimated.class, ParticleTextureStitcher.create(ParticleAnimated.class, texture).setSplitAnimations(true));
        }

        @Override
        public ParticleAnimated createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleAnimated(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getInt(0), args.scale, args.data.getBool(1));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(40, false);
        }
    }
}

