/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.client.render.sprite.TextureCorrosion;
import thebetweenlands.client.render.sprite.TextureFromData;
import thebetweenlands.common.registries.ItemRegistry;

public class TextureStitchHandler {
    public static final TextureStitchHandler INSTANCE = new TextureStitchHandler();
    private final List<TextureCorrosion> stitchedCorrosionSprites = new ArrayList<TextureCorrosion>();
    private final List<TextureStitcher> stitchers = new ArrayList<TextureStitcher>();

    public void registerTextureStitcher(TextureStitcher splitter) {
        this.stitchers.add(splitter);
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre e) {
        Map mapRegisteredSprites;
        if (e.getMap() != Minecraft.func_71410_x().func_147117_R()) {
            return;
        }
        this.stitchedCorrosionSprites.clear();
        try {
            mapRegisteredSprites = e.getMap().field_110574_e;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load underlying sprite map", ex);
        }
        for (Item item : ItemRegistry.ITEMS) {
            ResourceLocation[] variants;
            if (!(item instanceof ICorrodible)) continue;
            for (ResourceLocation variant : variants = ICorrodible.getItemCorrodibleVariants((Item)((ICorrodible)item))) {
                try {
                    ResourceLocation modelLocation = new ResourceLocation(variant.func_110624_b(), "item/" + variant.func_110623_a());
                    IModel model = ModelLoaderRegistry.getModel((ResourceLocation)modelLocation);
                    ArrayList textures = Lists.newArrayList();
                    textures.addAll(model.getTextures());
                    List<IModel> dependencies = this.gatherModelDependencies(model, new ArrayList<IModel>());
                    for (IModel dependencyModel : dependencies) {
                        Collection dependencyTextures = dependencyModel.getTextures();
                        for (ResourceLocation dependencyTexture : dependencyTextures) {
                            if (textures.contains(dependencyTexture)) continue;
                            textures.add(dependencyTexture);
                        }
                    }
                    for (ResourceLocation texture : textures) {
                        String path = texture.func_110623_a();
                        if (!path.contains("/")) continue;
                        String corrodibleSuffix = "_corrodible";
                        String fileName = texture.func_110623_a().substring(texture.func_110623_a().lastIndexOf("/") + 1);
                        if (!fileName.endsWith(corrodibleSuffix)) continue;
                        ResourceLocation completeBaseTextureLocation = new ResourceLocation(texture.func_110624_b(), String.format("textures/%s.png", texture.func_110623_a()));
                        for (int n = 0; n < 6; ++n) {
                            String corrosionSpriteName = texture.func_110624_b() + ":" + path.substring(0, path.length() - corrodibleSuffix.length()) + "_corrosion_" + n;
                            TextureCorrosion corrosionTexture = new TextureCorrosion(corrosionSpriteName, completeBaseTextureLocation, n, item.func_77658_a().hashCode());
                            mapRegisteredSprites.put(corrosionSpriteName, corrosionTexture);
                            this.stitchedCorrosionSprites.add(corrosionTexture);
                        }
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to load corrosion texture", ex);
                }
            }
        }
        HashMap<ResourceLocation, Frame[]> animationFramesCache = new HashMap<ResourceLocation, Frame[]>();
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        for (TextureStitcher stitcher : this.stitchers) {
            ResourceLocation[] textures = stitcher.getTextures();
            Frame[][] frames = new Frame[textures.length][];
            for (int i = 0; i < textures.length; ++i) {
                TextureAtlasSprite sprite = e.getMap().func_174942_a(textures[i]);
                if (stitcher.splitFrames) {
                    try {
                        ResourceLocation resourceLocation = this.getResourceLocation(e.getMap().getBasePath(), sprite);
                        Frame[] cachedFrames = (Frame[])animationFramesCache.get(resourceLocation);
                        if (cachedFrames != null) {
                            frames[i] = cachedFrames;
                            continue;
                        }
                        IResource resource = null;
                        if (sprite.hasCustomLoader(resourceManager, resourceLocation)) {
                            sprite.load(resourceManager, resourceLocation, l -> (TextureAtlasSprite)mapRegisteredSprites.get(l.toString()));
                        } else {
                            PngSizeInfo pngSizeInfo = PngSizeInfo.func_188532_a((IResource)resourceManager.func_110536_a(resourceLocation));
                            resource = resourceManager.func_110536_a(resourceLocation);
                            boolean hasAnimation = resource.func_110526_a("animation") != null;
                            sprite.func_188538_a(pngSizeInfo, hasAnimation);
                        }
                        sprite.func_188539_a(resource, e.getMap().getMipmapLevels() + 1);
                        if (!sprite.func_130098_m() || sprite.func_110970_k() == 1) {
                            frames[i] = new Frame[]{new Frame(sprite, 0)};
                        } else {
                            AnimationMetadataSection animationMetadata = (AnimationMetadataSection)resource.func_110526_a("animation");
                            boolean hasFrameMeta = animationMetadata.func_110473_c() > 0;
                            int frameCount = hasFrameMeta ? animationMetadata.func_110473_c() : sprite.func_110970_k();
                            frames[i] = new Frame[frameCount];
                            for (int frame = 0; frame < frameCount; ++frame) {
                                int duration = hasFrameMeta ? animationMetadata.func_110472_a(frame) : animationMetadata.func_110469_d();
                                int index = hasFrameMeta ? animationMetadata.func_110468_c(frame) : frame;
                                int[] frameData = sprite.func_147965_a(index)[0];
                                TextureFromData frameSprite = new TextureFromData(sprite.func_94215_i() + "_frame_" + frame, frameData, sprite.func_94211_a(), sprite.func_94216_b());
                                e.getMap().setTextureEntry((TextureAtlasSprite)frameSprite);
                                frames[i][frame] = new Frame(frameSprite, duration);
                            }
                        }
                        animationFramesCache.put(resourceLocation, frames[i]);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Failed splitting texture animation", ex);
                    }
                }
                frames[i] = new Frame[]{new Frame(sprite, 0)};
            }
            TextureStitcher.access$102(stitcher, frames);
        }
    }

    private ResourceLocation getResourceLocation(String basePath, TextureAtlasSprite sprite) {
        ResourceLocation resourcelocation = new ResourceLocation(sprite.func_94215_i());
        return new ResourceLocation(resourcelocation.func_110624_b(), String.format("%s/%s%s", basePath, resourcelocation.func_110623_a(), ".png"));
    }

    @SubscribeEvent
    public void onTextureStitchPost(TextureStitchEvent.Post e) {
        if (e.getMap() != Minecraft.func_71410_x().func_147117_R()) {
            return;
        }
        TextureMap map = e.getMap();
        for (TextureCorrosion corrosionSprite : this.stitchedCorrosionSprites) {
            String parentIconName = corrosionSprite.getParentSpriteName().toString();
            TextureAtlasSprite parentSprite = map.getTextureExtry(parentIconName);
            if (parentSprite == null) continue;
            corrosionSprite.setParentSprite(parentSprite);
        }
        this.stitchedCorrosionSprites.clear();
        for (TextureStitcher splitter : this.stitchers) {
            if (splitter.callback == null) continue;
            splitter.callback.accept(splitter);
        }
    }

    private List<IModel> gatherModelDependencies(IModel model, List<IModel> foundDependencies) {
        Collection dependencies = model.getDependencies();
        for (ResourceLocation dependency : dependencies) {
            try {
                IModel dependencyModel = ModelLoaderRegistry.getModel((ResourceLocation)dependency);
                if (foundDependencies.contains(dependencyModel)) continue;
                foundDependencies.add(dependencyModel);
                this.gatherModelDependencies(dependencyModel, foundDependencies);
            }
            catch (ModelLoaderRegistry.LoaderException dependencyModel) {
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return foundDependencies;
    }

    public static final class Frame {
        private final TextureAtlasSprite sprite;
        private final int duration;

        protected Frame(TextureAtlasSprite sprite, int duration) {
            this.sprite = sprite;
            this.duration = duration;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public int getDuration() {
            return this.duration;
        }
    }

    public static final class TextureStitcher {
        private final Consumer<TextureStitcher> callback;
        private final ResourceLocation[] textures;
        private Frame[][] frames;
        private boolean splitFrames;

        public TextureStitcher(ResourceLocation ... textures) {
            this((Consumer<TextureStitcher>)null, textures);
        }

        public TextureStitcher(@Nullable Consumer<TextureStitcher> callback, ResourceLocation ... textures) {
            this.textures = textures;
            this.callback = callback;
        }

        public TextureStitcher setSplitFrames(boolean split) {
            this.splitFrames = split;
            return this;
        }

        public ResourceLocation[] getTextures() {
            return this.textures;
        }

        public Frame[][] getFrames() {
            return this.frames;
        }

        static /* synthetic */ Frame[][] access$102(TextureStitcher x0, Frame[][] x1) {
            x0.frames = x1;
            return x1;
        }
    }
}

