/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.util.Random;
import java.util.stream.StreamSupport;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import thebetweenlands.api.storage.ILocalStorage;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationStorage;
import thebetweenlands.common.world.storage.location.guard.ILocationGuard;

public class DebugHandlerClient {
    @SubscribeEvent
    public static void renderWorld(RenderWorldLastEvent event) {
        if (StreamSupport.stream(Minecraft.func_71410_x().field_71439_g.func_184214_aD().spliterator(), false).anyMatch(stack -> !stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.LOCATION_DEBUG)) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld((World)world);
            for (ILocalStorage sharedStorage : worldStorage.getLocalStorageHandler().getLoadedStorages()) {
                if (!(sharedStorage instanceof LocationStorage)) continue;
                LocationStorage location = (LocationStorage)sharedStorage;
                GlStateManager.func_179094_E();
                if (GuiScreen.func_146271_m()) {
                    GlStateManager.func_179097_i();
                }
                GlStateManager.func_179090_x();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_187441_d((float)1.0f);
                GlStateManager.func_179132_a((boolean)false);
                GL11.glEnable((int)2848);
                Random rnd = new Random(location.getSeed());
                float red = (0.25f + rnd.nextFloat() / 2.0f * 0.75f) * (float)(location.getLayer() + 2) / 2.0f;
                float green = (0.25f + rnd.nextFloat() / 2.0f * 0.75f) * (float)(location.getLayer() + 2) / 2.0f;
                float blue = (0.25f + rnd.nextFloat() * 0.75f) * (float)(location.getLayer() + 2) / 2.0f;
                float alpha = 0.25f;
                GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
                for (AxisAlignedBB bb : location.getBounds()) {
                    DebugHandlerClient.drawBoundingBox(bb.func_72317_d(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n));
                }
                GlStateManager.func_179131_c((float)(red / 1.5f), (float)(green / 1.5f), (float)(blue / 1.5f), (float)1.0f);
                for (AxisAlignedBB bb : location.getBounds()) {
                    DebugHandlerClient.drawBoundingBoxOutline(bb.func_72317_d(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n));
                }
                if (location.getEnclosingBounds() != null) {
                    GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
                    DebugHandlerClient.drawBoundingBoxOutline(location.getEnclosingBounds().func_72317_d(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n));
                    AxisAlignedBB aabb = location.getEnclosingBounds();
                    Vec3d center = new Vec3d((aabb.field_72336_d + aabb.field_72340_a) / 2.0, (aabb.field_72337_e + aabb.field_72338_b) / 2.0, (aabb.field_72334_f + aabb.field_72339_c) / 2.0).func_72441_c(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)center.field_72450_a, (double)center.field_72448_b, (double)center.field_72449_c);
                    float scale = Math.max(2.0f, (float)center.func_72433_c() / 10.0f);
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    DebugHandlerClient.renderTag(Minecraft.func_71410_x().field_71466_p, location.hasLocalizedName() ? location.getLocalizedName() : location.getName(), 0.0f, 0.0f, 0.0f, 0, Minecraft.func_71410_x().func_175598_ae().field_78735_i, Minecraft.func_71410_x().func_175598_ae().field_78732_j, Minecraft.func_71410_x().func_175598_ae().field_78733_k.field_74320_O == 2);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179090_x();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179126_j();
                GlStateManager.func_187441_d((float)2.0f);
                ILocationGuard guard = location.getGuard();
                if (guard != null) {
                    GlStateManager.func_179136_a((float)-0.1f, (float)-10.0f);
                    GlStateManager.func_179088_q();
                    for (int xo = -8; xo <= 8; ++xo) {
                        for (int yo = -8; yo <= 8; ++yo) {
                            for (int zo = -8; zo <= 8; ++zo) {
                                BlockPos pos = Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177982_a(xo, yo, zo);
                                if (pos.func_177956_o() < 0) continue;
                                IBlockState state = world.func_180495_p(pos);
                                boolean guarded = guard.isGuarded((World)world, (Entity)Minecraft.func_71410_x().field_71439_g, pos);
                                if (!guarded) continue;
                                if (state.func_177230_c() != Blocks.field_150350_a) {
                                    GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)0.25f);
                                    DebugHandlerClient.drawBoundingBox(state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos).func_72317_d(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n));
                                    continue;
                                }
                                GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)0.8f);
                                DebugHandlerClient.drawBoundingBoxOutline(new AxisAlignedBB(pos).func_72317_d(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n));
                            }
                        }
                    }
                    GlStateManager.func_179113_r();
                }
                GL11.glDisable((int)2848);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179126_j();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
    }

    public static void renderTag(FontRenderer fontRenderer, String str, float x, float y, float z, int yOffset, float playerViewY, float playerViewX, boolean thirdPerson) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(thirdPerson ? -1 : 1) * playerViewX), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = fontRenderer.func_78256_a(str) / 2;
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(-i - 1), (double)(-1 + yOffset), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(-i - 1), (double)(8 + yOffset), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(i + 1), (double)(8 + yOffset), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(i + 1), (double)(-1 + yOffset), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontRenderer.func_78276_b(str, -fontRenderer.func_78256_a(str) / 2, yOffset, -1);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBoundingBox(AxisAlignedBB axisalignedbb) {
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glEnd();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBoundingBoxOutline(AxisAlignedBB par1AxisAlignedBB) {
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glEnd();
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glEnd();
    }

    @SubscribeEvent
    public static void onKey(InputEvent.KeyInputEvent event) {
        if (BetweenlandsConfig.DEBUG.debug && Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == 21) {
                WorldServer world = DimensionManager.getWorld((int)BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId);
                if (world != null) {
                    ChunkGeneratorBetweenlands cgb = (ChunkGeneratorBetweenlands)world.func_72863_F().field_186029_c;
                    if (Keyboard.getEventKey() == 21) {
                        if (Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184)) {
                            cgb.debugProvideReset();
                            if (Minecraft.func_71410_x().field_71439_g != null) {
                                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(String.format("Reset chunk provider debug", new Object[0])));
                            }
                        } else {
                            cgb.debugGenerateChunkProvidesImage(true);
                        }
                    }
                }
            } else if (Keyboard.getEventKey() == 45) {
                boolean bl = ChunkGeneratorBetweenlands.debugRecord = !ChunkGeneratorBetweenlands.debugRecord;
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(String.format("Chunk provider debug is now %s", ChunkGeneratorBetweenlands.debugRecord ? "enabled" : "disabled")));
                }
            }
        }
    }
}

