/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import nc.config.NCConfig;
import nc.util.PotionHelper;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class RadEffects {
    public static final List<Double> PLAYER_RAD_LEVEL_LIST = new ArrayList<Double>();
    public static final List<List<PotionEffect>> PLAYER_DEBUFF_LIST = new ArrayList<List<PotionEffect>>();
    public static final List<Double> ENTITY_RAD_LEVEL_LIST = new ArrayList<Double>();
    public static final List<List<PotionEffect>> ENTITY_DEBUFF_LIST = new ArrayList<List<PotionEffect>>();
    public static final List<Double> MOB_RAD_LEVEL_LIST = new ArrayList<Double>();
    public static final List<List<PotionEffect>> MOB_EFFECTS_LIST = new ArrayList<List<PotionEffect>>();

    public static void init() {
        RadEffects.parseEffects(NCConfig.radiation_passive_debuff_lists, PLAYER_RAD_LEVEL_LIST, PLAYER_DEBUFF_LIST, Math.max(NCConfig.radiation_player_tick_rate, 19));
        RadEffects.parseEffects(NCConfig.radiation_passive_debuff_lists, ENTITY_RAD_LEVEL_LIST, ENTITY_DEBUFF_LIST, Math.max(NCConfig.radiation_world_tick_rate, 39));
        RadEffects.parseEffects(NCConfig.radiation_mob_buff_lists, MOB_RAD_LEVEL_LIST, MOB_EFFECTS_LIST, Math.max(NCConfig.radiation_world_tick_rate, 39));
    }

    private static void parseEffects(String[] effectsArray, List<Double> radLevelList, List<List<PotionEffect>> potionList, int effectTime) {
        int[] orderedIndices;
        ArrayList<Double> radLevelListUnordered = new ArrayList<Double>();
        ArrayList potionListUnordered = new ArrayList();
        block0: for (String effects : effectsArray) {
            int puncPos = effects.indexOf(95);
            if (puncPos == -1) continue;
            double health = Double.parseDouble(effects.substring(0, puncPos));
            effects = effects.substring(puncPos + 1);
            ArrayList<PotionEffect> effectList = new ArrayList<PotionEffect>();
            while ((puncPos = effects.indexOf(64)) != -1) {
                String potionName = effects.substring(0, puncPos);
                Integer strength = Integer.parseInt((puncPos = (effects = effects.substring(puncPos + 1)).indexOf(44)) == -1 ? effects : effects.substring(0, puncPos));
                effects = effects.substring(puncPos == -1 ? strength.toString().length() : strength.toString().length() + 1);
                int modifiedTime = RadEffects.getModifiedTime(potionName, effectTime, strength - 1);
                Potion potion = Potion.func_180142_b((String)potionName);
                if (potion != null && strength != null) {
                    effectList.add(PotionHelper.newEffect(potion, (int)strength, modifiedTime));
                }
                if (puncPos != -1) continue;
                if (effectList.isEmpty()) continue block0;
                radLevelListUnordered.add(health);
                potionListUnordered.add(effectList);
                continue block0;
            }
        }
        Double[] healthArray = radLevelListUnordered.toArray(new Double[radLevelListUnordered.size()]);
        for (int index : orderedIndices = IntStream.range(0, healthArray.length).boxed().sorted((i, j) -> healthArray[i].compareTo(healthArray[j])).mapToInt(e -> e).toArray()) {
            radLevelList.add(radLevelListUnordered.get(index));
            potionList.add(potionListUnordered.get(index));
        }
        radLevelList = Lists.reverse(radLevelList);
        potionList = Lists.reverse(potionList);
    }

    private static int getModifiedTime(String potionName, int effectTime, int amplifier) {
        if (potionName.equals("regeneration") || potionName.equals("minecraft:regeneration")) {
            return Math.max(effectTime, 50 >> amplifier);
        }
        if (potionName.equals("wither") || potionName.equals("minecraft:wither")) {
            return Math.max(effectTime, 40 >> amplifier);
        }
        if (potionName.equals("poison") || potionName.equals("minecraft:poison")) {
            return Math.max(effectTime, 25 >> amplifier);
        }
        return effectTime;
    }
}

