/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.condenser;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import nc.config.NCConfig;
import nc.multiblock.IMultiblockFluid;
import nc.multiblock.IMultiblockPart;
import nc.multiblock.MultiblockBase;
import nc.multiblock.TileBeefBase;
import nc.multiblock.condenser.tile.TileCondenserController;
import nc.multiblock.container.ContainerCondenserController;
import nc.multiblock.cuboidal.CuboidalMultiblockBase;
import nc.multiblock.network.CondenserUpdatePacket;
import nc.multiblock.validation.IMultiblockValidator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Condenser
extends CuboidalMultiblockBase<CondenserUpdatePacket>
implements IMultiblockFluid {
    private Set<TileCondenserController> controllers = new HashSet<TileCondenserController>();
    private TileCondenserController controller;
    public int redstoneSignal = 0;
    private int updateCount = 0;
    public boolean isCondenserOn;

    public Condenser(World world) {
        super(world);
    }

    public Set<TileCondenserController> getControllers() {
        return this.controllers;
    }

    @Override
    protected int getMinimumInteriorLength() {
        return NCConfig.condenser_min_size;
    }

    @Override
    protected int getMaximumInteriorLength() {
        return NCConfig.condenser_max_size;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.syncDataFrom(data, TileBeefBase.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof TileCondenserController) {
            this.controllers.add((TileCondenserController)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        if (oldPart instanceof TileCondenserController) {
            this.controllers.remove(oldPart);
        }
    }

    @Override
    protected void onMachineAssembled() {
        Iterator<TileCondenserController> iterator = this.controllers.iterator();
        while (iterator.hasNext()) {
            TileCondenserController contr;
            this.controller = contr = iterator.next();
        }
        this.onCondenserFormed();
    }

    @Override
    protected void onMachineRestored() {
        this.onCondenserFormed();
    }

    protected void onCondenserFormed() {
        this.setIsCondenserOn();
        this.calculateCondenserStats();
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
        this.isCondenserOn = false;
        if (this.controller != null) {
            this.controller.updateBlock(false);
        }
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this.controllers.size() == 0) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.controllers.size() > 1) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        return super.isMachineWhole(validatorCallback);
    }

    @Override
    protected void onAssimilate(MultiblockBase assimilated) {
    }

    @Override
    protected void onAssimilated(MultiblockBase assimilator) {
    }

    @Override
    protected boolean updateServer() {
        if (this.shouldUpdate()) {
            this.calculateCondenserStats();
        }
        if (this.shouldUpdate()) {
            this.sendUpdateToListeningPlayers();
        }
        this.incrementUpdateCount();
        return true;
    }

    public void setIsCondenserOn() {
        boolean oldIsCondenserOn = this.isCondenserOn;
        boolean bl = this.isCondenserOn = this.isRedstonePowered() && this.isAssembled();
        if (this.isCondenserOn != oldIsCondenserOn) {
            if (this.controller != null) {
                this.controller.updateBlock(this.isCondenserOn);
            }
            this.sendUpdateToAllPlayers();
        }
    }

    protected boolean isRedstonePowered() {
        return this.controller != null && this.controller.checkIsRedstonePowered(this.WORLD, this.controller.func_174877_v());
    }

    protected void calculateCondenserStats() {
    }

    private void incrementUpdateCount() {
        ++this.updateCount;
        this.updateCount %= this.updateTime();
    }

    private int updateTime() {
        return NCConfig.machine_update_rate / 4;
    }

    private boolean shouldUpdate() {
        return this.updateCount == 0;
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void syncDataTo(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
    }

    @Override
    protected void syncDataFrom(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
    }

    @Override
    protected CondenserUpdatePacket getUpdatePacket() {
        return new CondenserUpdatePacket(this.controller.func_174877_v(), this.isCondenserOn);
    }

    @Override
    public void onPacket(CondenserUpdatePacket message) {
        this.isCondenserOn = message.isCondenserOn;
    }

    public Container getContainer(EntityPlayer player) {
        return new ContainerCondenserController(player, this.controller);
    }

    @Override
    public void clearAllFluids() {
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return true;
    }
}

