/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.integrations.minetweaker;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconInfusionRitual;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.minetweaker.ACMTMisc;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.abyssalcraft.InfusionRitual")
public class InfusionRitual {
    @ZenMethod
    public static void addRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean remnantHelp, IItemStack item, IIngredient sacrifice, IIngredient ... offerings) {
        InfusionRitual.addRitual(unlocalizedName, bookType, dimension, requiredEnergy, remnantHelp, item, sacrifice, offerings, false);
    }

    @ZenMethod
    public static void addRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean remnantHelp, IItemStack item, IIngredient sacrifice, IIngredient[] offerings, boolean nbt) {
        InfusionRitual.addRitual(unlocalizedName, bookType, dimension, requiredEnergy, remnantHelp, item, sacrifice, offerings, nbt, new String[0]);
    }

    @ZenMethod
    public static void addRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean remnantHelp, IItemStack item, IIngredient sacrifice, IIngredient[] offerings, boolean nbt, String ... tags) {
        Object[] offers = ACMT.toObjects(offerings);
        NecronomiconInfusionRitual ritual = new NecronomiconInfusionRitual(unlocalizedName, bookType, dimension, requiredEnergy, remnantHelp, ACMT.toStack(item), ACMT.toObject(sacrifice), offers);
        if (nbt) {
            ritual.setNBTSensitive().setNBTSensitiveSacrifice();
        }
        if (tags != null && tags.length > 0) {
            ritual.setTags(tags);
        }
        ACMTMisc.TASKS.add(new Add(ritual));
    }

    @ZenMethod
    public static void removeRitual(IItemStack item) {
        ACMTMisc.TASKS.add(new Remove(ACMT.toStack(item)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack item;

        public Remove(ItemStack item) {
            this.item = item;
        }

        public void apply() {
            ArrayList<NecronomiconInfusionRitual> temp = new ArrayList<NecronomiconInfusionRitual>();
            for (NecronomiconRitual necronomiconRitual : RitualRegistry.instance().getRituals()) {
                if (!(necronomiconRitual instanceof NecronomiconInfusionRitual) || necronomiconRitual.getClass().getSuperclass() == NecronomiconInfusionRitual.class || necronomiconRitual.getClass().getSuperclass().getSuperclass() == NecronomiconInfusionRitual.class) continue;
                temp.add((NecronomiconInfusionRitual)necronomiconRitual);
            }
            for (NecronomiconInfusionRitual necronomiconInfusionRitual : temp) {
                if (!APIUtils.areStacksEqual((ItemStack)this.item, (ItemStack)necronomiconInfusionRitual.getItem())) continue;
                RitualRegistry.instance().getRituals().remove(necronomiconInfusionRitual);
            }
        }

        public String describe() {
            return "Removing Necronomicon Infusion Ritual for " + this.item.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final NecronomiconInfusionRitual ritual;

        public Add(NecronomiconInfusionRitual ritual) {
            this.ritual = ritual;
        }

        public void apply() {
            RitualRegistry.instance().registerRitual((NecronomiconRitual)this.ritual);
        }

        public String describe() {
            return "Adding Necronomicon Infusion Ritual for " + this.ritual.getItem().func_82833_r();
        }
    }
}

