/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.forgeenergy;

import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergyCableIntegration
implements IEnergyStorage {
    public TileEntityUniversalCable tileEntity;
    public EnumFacing side;

    public ForgeEnergyCableIntegration(TileEntityUniversalCable tile, EnumFacing facing) {
        this.tileEntity = tile;
        this.side = facing;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)Math.round(this.tileEntity.acceptEnergy(this.side, (double)maxReceive * MekanismConfig.current().general.FROM_FORGE.val(), simulate) * MekanismConfig.current().general.TO_FORGE.val());
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return (int)Math.round(Math.min(2.147483647E9, this.tileEntity.getEnergy() * MekanismConfig.current().general.TO_FORGE.val()));
    }

    public int getMaxEnergyStored() {
        return (int)Math.round(Math.min(2.147483647E9, this.tileEntity.getMaxEnergy() * MekanismConfig.current().general.TO_FORGE.val()));
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.tileEntity.canReceiveEnergy(this.side);
    }
}

