/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.CraftTweakerGasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.separator")
@ModOnly(value="mtlib")
@ZenRegister
public class Separator {
    public static final String NAME = "Mekanism Separator";

    @ZenMethod
    public static void addRecipe(ILiquidStack liquidInput, double energy, IGasStack leftGasOutput, IGasStack rightGasOutput) {
        if (liquidInput == null || leftGasOutput == null || rightGasOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        SeparatorRecipe recipe = new SeparatorRecipe(InputHelper.toFluid((ILiquidStack)liquidInput), energy, GasHelper.toGas(leftGasOutput), GasHelper.toGas(rightGasOutput));
        CrafttweakerIntegration.LATE_ADDITIONS.add((IAction)new AddMekanismRecipe<FluidInput, SeparatorRecipe>(NAME, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.get(), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient liquidInput, @Optional IIngredient leftGasInput, @Optional IIngredient rightGasInput) {
        if (liquidInput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        if (leftGasInput == null) {
            leftGasInput = IngredientAny.INSTANCE;
        }
        if (rightGasInput == null) {
            leftGasInput = IngredientAny.INSTANCE;
        }
        CrafttweakerIntegration.LATE_REMOVALS.add((IAction)new Remove(NAME, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.get(), liquidInput, leftGasInput, rightGasInput));
    }

    private static class Remove
    extends RemoveMekanismRecipe<FluidInput, SeparatorRecipe> {
        private IIngredient liquidInput;
        private IIngredient leftGasInput;
        private IIngredient rightGasInput;

        public Remove(String name, Map<FluidInput, SeparatorRecipe> map, IIngredient liquidInput, IIngredient leftGasInput, IIngredient rightGasInput) {
            super(name, map);
            this.liquidInput = liquidInput;
            this.leftGasInput = leftGasInput;
            this.rightGasInput = rightGasInput;
        }

        @Override
        public void addRecipes() {
            HashMap<FluidInput, SeparatorRecipe> recipesToRemove = new HashMap<FluidInput, SeparatorRecipe>();
            for (Map.Entry<FluidInput, SeparatorRecipe> entry : RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.get().entrySet()) {
                ILiquidStack inputLiquid = InputHelper.toILiquidStack((FluidStack)entry.getKey().ingredient);
                CraftTweakerGasStack outputItemLeft = new CraftTweakerGasStack(((ChemicalPairOutput)entry.getValue().recipeOutput).leftGas);
                CraftTweakerGasStack outputItemRight = new CraftTweakerGasStack(((ChemicalPairOutput)entry.getValue().recipeOutput).rightGas);
                if (!StackHelper.matches((IIngredient)this.liquidInput, (ILiquidStack)inputLiquid) || !GasHelper.matches(this.leftGasInput, outputItemLeft) || !GasHelper.matches(this.rightGasInput, outputItemRight)) continue;
                recipesToRemove.put(entry.getKey(), entry.getValue());
            }
            if (!recipesToRemove.isEmpty()) {
                this.recipes.putAll(recipesToRemove);
            } else {
                LogHelper.logInfo((String)String.format("No %s recipe found for %s, %s and %s. Command ignored!", Separator.NAME, this.liquidInput.toString(), this.leftGasInput.toString(), this.rightGasInput.toString()));
            }
        }
    }
}

