/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.extrarails;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.beans.ConstructorProperties;
import java.util.Collection;
import net.minecraft.util.math.BlockPos;

public class TeleportingManager {
    private static Multimap<Integer, Pos> map = HashMultimap.create();

    public static void add(int color, int dimension, BlockPos pos) {
        map.put((Object)color, (Object)new Pos(dimension, pos));
    }

    public static void remove(int color, int dimension, BlockPos pos) {
        map.remove((Object)color, (Object)new Pos(dimension, pos));
    }

    public static Collection<Pos> get(int color) {
        return map.get((Object)color);
    }

    public static class Pos {
        public final int dim;
        public final BlockPos pos;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pos pos1 = (Pos)o;
            if (this.dim != pos1.dim) {
                return false;
            }
            return this.pos.equals((Object)pos1.pos);
        }

        public int hashCode() {
            int result = this.dim;
            result = 31 * result + this.pos.hashCode();
            return result;
        }

        @ConstructorProperties(value={"dim", "pos"})
        public Pos(int dim, BlockPos pos) {
            this.dim = dim;
            this.pos = pos;
        }
    }
}

