/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.EventManager;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberActivationFX;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityCatalyzer;
import teamroots.embers.tileentity.TileEntityCombustor;
import teamroots.embers.util.EmberGenUtil;
import teamroots.embers.util.Misc;

public class TileEntityReactor
extends TileEntity
implements ITileEntityBase,
ITickable {
    public IEmberCapability capability = new DefaultEmberCapability();
    Random random = new Random();
    int progress = -1;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityReactor.this.func_70296_d();
            TileEntityReactor.this.capability.setEmberCapacity(64000.0);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (EmberGenUtil.getEmberForItem(stack.func_77973_b()) == 0.0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    public boolean dirty = false;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        this.capability.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.capability.readFromNBT(tag);
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(this.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == EmberCapabilityProvider.emberCapability) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == EmberCapabilityProvider.emberCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            ++this.progress;
            if (this.progress > 20) {
                float catalyzerMult = 0.0f;
                float combustorMult = 0.0f;
                float multiplier = 1.0f;
                if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177978_c().func_177977_b()) instanceof TileEntityCatalyzer) {
                    catalyzerMult += ((TileEntityCatalyzer)this.field_145850_b.func_175625_s((BlockPos)this.func_174877_v().func_177978_c().func_177977_b())).multiplier;
                }
                if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177968_d().func_177977_b()) instanceof TileEntityCatalyzer) {
                    catalyzerMult += ((TileEntityCatalyzer)this.field_145850_b.func_175625_s((BlockPos)this.func_174877_v().func_177968_d().func_177977_b())).multiplier;
                }
                if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177974_f().func_177977_b()) instanceof TileEntityCatalyzer) {
                    catalyzerMult += ((TileEntityCatalyzer)this.field_145850_b.func_175625_s((BlockPos)this.func_174877_v().func_177974_f().func_177977_b())).multiplier;
                }
                if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177976_e().func_177977_b()) instanceof TileEntityCatalyzer) {
                    catalyzerMult += ((TileEntityCatalyzer)this.field_145850_b.func_175625_s((BlockPos)this.func_174877_v().func_177976_e().func_177977_b())).multiplier;
                }
                if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177978_c().func_177977_b()) instanceof TileEntityCombustor) {
                    combustorMult += ((TileEntityCombustor)this.field_145850_b.func_175625_s((BlockPos)this.func_174877_v().func_177978_c().func_177977_b())).multiplier;
                }
                if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177968_d().func_177977_b()) instanceof TileEntityCombustor) {
                    combustorMult += ((TileEntityCombustor)this.field_145850_b.func_175625_s((BlockPos)this.func_174877_v().func_177968_d().func_177977_b())).multiplier;
                }
                if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177974_f().func_177977_b()) instanceof TileEntityCombustor) {
                    combustorMult += ((TileEntityCombustor)this.field_145850_b.func_175625_s((BlockPos)this.func_174877_v().func_177974_f().func_177977_b())).multiplier;
                }
                if (this.field_145850_b.func_175625_s(this.func_174877_v().func_177976_e().func_177977_b()) instanceof TileEntityCombustor) {
                    combustorMult += ((TileEntityCombustor)this.field_145850_b.func_175625_s((BlockPos)this.func_174877_v().func_177976_e().func_177977_b())).multiplier;
                }
                if (Math.max(combustorMult, catalyzerMult) < 2.0f * Math.min(combustorMult, catalyzerMult)) {
                    multiplier += combustorMult;
                    multiplier += catalyzerMult;
                    this.progress = 0;
                    int i = 0;
                    if (this.inventory != null && EmberGenUtil.getEmberForItem(this.inventory.getStackInSlot(i).func_77973_b()) > 0.0) {
                        double ember = (double)multiplier * EmberGenUtil.getEmberForItem(this.inventory.getStackInSlot(i).func_77973_b());
                        if (this.capability.getEmber() <= this.capability.getEmberCapacity() - ember) {
                            if (!this.field_145850_b.field_72995_K) {
                                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberActivationFX((float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 0.5f, (float)this.func_174877_v().func_177952_p() + 0.5f));
                            }
                            this.capability.addAmount(ember, true);
                            this.inventory.extractItem(i, 1, false);
                            this.func_70296_d();
                            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                            this.func_70296_d();
                            state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177984_a());
                        }
                    }
                }
            }
            this.func_70296_d();
        }
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }
}

