/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import teamroots.embers.EventManager;
import teamroots.embers.item.ItemTinkerHammer;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityFluidExtractor;
import teamroots.embers.util.Misc;

public class TileEntityFluidPipe
extends TileFluidHandler
implements ITileEntityBase,
ITickable {
    Random random = new Random();
    List<EnumFacing> from = new ArrayList<EnumFacing>();
    public EnumPipeConnection up = EnumPipeConnection.NONE;
    public EnumPipeConnection down = EnumPipeConnection.NONE;
    public EnumPipeConnection north = EnumPipeConnection.NONE;
    public EnumPipeConnection south = EnumPipeConnection.NONE;
    public EnumPipeConnection east = EnumPipeConnection.NONE;
    public EnumPipeConnection west = EnumPipeConnection.NONE;
    public boolean dirty = false;

    public static EnumPipeConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return EnumPipeConnection.NONE;
            }
            case 1: {
                return EnumPipeConnection.PIPE;
            }
            case 2: {
                return EnumPipeConnection.BLOCK;
            }
            case 3: {
                return EnumPipeConnection.LEVER;
            }
            case 4: {
                return EnumPipeConnection.FORCENONE;
            }
        }
        return EnumPipeConnection.NONE;
    }

    public TileEntityFluidPipe() {
        this.tank.setCapacity(1000);
    }

    public void updateNeighbors(IBlockAccess world) {
        this.up = this.getConnection(world, this.func_174877_v().func_177984_a(), EnumFacing.UP);
        this.down = this.getConnection(world, this.func_174877_v().func_177977_b(), EnumFacing.DOWN);
        this.north = this.getConnection(world, this.func_174877_v().func_177978_c(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.func_174877_v().func_177968_d(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.func_174877_v().func_177976_e(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.func_174877_v().func_177974_f(), EnumFacing.EAST);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("up", this.up.ordinal());
        tag.func_74768_a("down", this.down.ordinal());
        tag.func_74768_a("north", this.north.ordinal());
        tag.func_74768_a("south", this.south.ordinal());
        tag.func_74768_a("west", this.west.ordinal());
        tag.func_74768_a("east", this.east.ordinal());
        NBTTagList l = new NBTTagList();
        for (EnumFacing f : this.from) {
            l.func_74742_a((NBTBase)new NBTTagInt(f.func_176745_a()));
        }
        tag.func_74782_a("from", (NBTBase)l);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.up = TileEntityFluidPipe.connectionFromInt(tag.func_74762_e("up"));
        this.down = TileEntityFluidPipe.connectionFromInt(tag.func_74762_e("down"));
        this.north = TileEntityFluidPipe.connectionFromInt(tag.func_74762_e("north"));
        this.south = TileEntityFluidPipe.connectionFromInt(tag.func_74762_e("south"));
        this.west = TileEntityFluidPipe.connectionFromInt(tag.func_74762_e("west"));
        this.east = TileEntityFluidPipe.connectionFromInt(tag.func_74762_e("east"));
        NBTTagList l = tag.func_150295_c("from", 3);
        for (int i = 0; i < l.func_74745_c(); ++i) {
            this.from.add(EnumFacing.func_82600_a((int)l.func_186858_c(i)));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumPipeConnection getConnection(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return this.up;
        }
        if (side == EnumFacing.DOWN) {
            return this.down;
        }
        if (side == EnumFacing.EAST) {
            return this.east;
        }
        if (side == EnumFacing.WEST) {
            return this.west;
        }
        if (side == EnumFacing.NORTH) {
            return this.north;
        }
        if (side == EnumFacing.SOUTH) {
            return this.south;
        }
        return EnumPipeConnection.NONE;
    }

    public void setConnection(EnumFacing side, EnumPipeConnection connect) {
        if (side == EnumFacing.UP) {
            this.up = connect;
        } else if (side == EnumFacing.DOWN) {
            this.down = connect;
        } else if (side == EnumFacing.EAST) {
            this.east = connect;
        } else if (side == EnumFacing.WEST) {
            this.west = connect;
        } else if (side == EnumFacing.NORTH) {
            this.north = connect;
        } else if (side == EnumFacing.SOUTH) {
            this.south = connect;
        }
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.getConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.FORCENONE;
        }
        if (world.func_175625_s(pos) instanceof TileEntityFluidPipe && !(world.func_175625_s(pos) instanceof TileEntityFluidExtractor)) {
            return EnumPipeConnection.PIPE;
        }
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Misc.getOppositeFace(side))) {
            return EnumPipeConnection.BLOCK;
        }
        return EnumPipeConnection.NONE;
    }

    public void reverseConnection(EnumFacing face) {
    }

    public static EnumPipeConnection reverseForce(EnumPipeConnection connect) {
        if (connect == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NONE;
        }
        if (connect != EnumPipeConnection.NONE && connect != EnumPipeConnection.LEVER) {
            return EnumPipeConnection.FORCENONE;
        }
        return EnumPipeConnection.NONE;
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem != ItemStack.field_190927_a && heldItem != ItemStack.field_190927_a && heldItem.func_77973_b() instanceof ItemTinkerHammer) {
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.west = TileEntityFluidPipe.reverseForce(this.west);
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.east = TileEntityFluidPipe.reverseForce(this.east);
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.north = TileEntityFluidPipe.reverseForce(this.north);
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.south = TileEntityFluidPipe.reverseForce(this.south);
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                if (Math.abs((double)hitY - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitY < 0.5) {
                        this.down = TileEntityFluidPipe.reverseForce(this.down);
                        this.reverseConnection(EnumFacing.DOWN);
                    } else {
                        this.up = TileEntityFluidPipe.reverseForce(this.up);
                        this.reverseConnection(EnumFacing.UP);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.north = TileEntityFluidPipe.reverseForce(this.north);
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.south = TileEntityFluidPipe.reverseForce(this.south);
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitY - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.west = TileEntityFluidPipe.reverseForce(this.west);
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.east = TileEntityFluidPipe.reverseForce(this.east);
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitY < 0.5) {
                    this.down = TileEntityFluidPipe.reverseForce(this.down);
                    this.reverseConnection(EnumFacing.DOWN);
                } else {
                    this.up = TileEntityFluidPipe.reverseForce(this.up);
                    this.reverseConnection(EnumFacing.UP);
                }
            }
            this.updateNeighbors((IBlockAccess)world);
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public boolean isConnected(EnumFacing face) {
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face));
        if (tile instanceof TileEntityFluidPipe && ((TileEntityFluidPipe)tile).getConnection(Misc.getOppositeFace(face)) != EnumPipeConnection.FORCENONE && ((TileEntityFluidPipe)tile).getConnection(Misc.getOppositeFace(face)) != EnumPipeConnection.NONE) {
            return true;
        }
        if (tile instanceof TileEntityFluidExtractor && ((TileEntityFluidExtractor)tile).getConnection(Misc.getOppositeFace(face)) != EnumPipeConnection.FORCENONE && ((TileEntityFluidExtractor)tile).getConnection(Misc.getOppositeFace(face)) != EnumPipeConnection.NONE) {
            return true;
        }
        return this.getConnection(face) == EnumPipeConnection.BLOCK;
    }

    public void func_73660_a() {
        if (this.tank.getFluid() != null) {
            ArrayList<BlockPos> toUpdate = new ArrayList<BlockPos>();
            int distAmount = Math.min(this.tank.getFluidAmount(), 120);
            ArrayList<EnumFacing> connectedFaces = new ArrayList<EnumFacing>();
            if ((this.up == EnumPipeConnection.PIPE || this.up == EnumPipeConnection.BLOCK) && this.isConnected(EnumFacing.UP) && !this.from.contains(EnumFacing.UP)) {
                connectedFaces.add(EnumFacing.UP);
            }
            if ((this.down == EnumPipeConnection.PIPE || this.down == EnumPipeConnection.BLOCK) && this.isConnected(EnumFacing.DOWN) && !this.from.contains(EnumFacing.DOWN)) {
                connectedFaces.add(EnumFacing.DOWN);
            }
            if ((this.north == EnumPipeConnection.PIPE || this.north == EnumPipeConnection.BLOCK) && this.isConnected(EnumFacing.NORTH) && !this.from.contains(EnumFacing.NORTH)) {
                connectedFaces.add(EnumFacing.NORTH);
            }
            if ((this.south == EnumPipeConnection.PIPE || this.south == EnumPipeConnection.BLOCK) && this.isConnected(EnumFacing.SOUTH) && !this.from.contains(EnumFacing.SOUTH)) {
                connectedFaces.add(EnumFacing.SOUTH);
            }
            if ((this.west == EnumPipeConnection.PIPE || this.west == EnumPipeConnection.BLOCK) && this.isConnected(EnumFacing.WEST) && !this.from.contains(EnumFacing.WEST)) {
                connectedFaces.add(EnumFacing.WEST);
            }
            if ((this.east == EnumPipeConnection.PIPE || this.east == EnumPipeConnection.BLOCK) && this.isConnected(EnumFacing.EAST) && !this.from.contains(EnumFacing.EAST)) {
                connectedFaces.add(EnumFacing.EAST);
            }
            for (int i = 0; i < connectedFaces.size(); ++i) {
                TileEntity t = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                if (!(t instanceof TileEntityFluidExtractor) || this.func_145831_w().func_175687_A(t.func_174877_v()) <= 0) continue;
                connectedFaces.remove(i);
                i = Math.max(i - 1, 0);
            }
            int count = 0;
            if (connectedFaces.size() >= 1) {
                for (int i = 0; i < connectedFaces.size(); ++i) {
                    IFluidHandler handler;
                    TileEntity t = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                    if (t == null || this.tank.getFluid() == null || !t.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Misc.getOppositeFace((EnumFacing)connectedFaces.get(i))) || (handler = (IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i)).func_176734_d())) == null) continue;
                    int capacity = 0;
                    int amount = 0;
                    for (IFluidTankProperties p : handler.getTankProperties()) {
                        capacity += p.getCapacity();
                        if (p.getContents() == null) continue;
                        amount += p.getContents().amount;
                    }
                    if (amount >= capacity) continue;
                    ++count;
                }
            }
            if (count >= 1 && !this.field_145850_b.field_72995_K) {
                int toEach = Math.max(1, distAmount / count);
                for (int i = 0; i < connectedFaces.size(); ++i) {
                    IFluidHandler handler;
                    TileEntity t = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                    if (t == null || toEach <= 0 || this.tank.getFluid() == null || !t.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Misc.getOppositeFace((EnumFacing)connectedFaces.get(i))) || (handler = (IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i)).func_176734_d())) == null) continue;
                    if (t.getClass() == TileEntityFluidPipe.class) {
                        ((TileEntityFluidPipe)t).from.add(Misc.getOppositeFace((EnumFacing)connectedFaces.get(i)));
                    }
                    FluidStack toAdd = new FluidStack(this.tank.getFluid().getFluid(), toEach);
                    int filled = handler.fill(toAdd, true);
                    this.tank.drainInternal(new FluidStack(this.tank.getFluid().getFluid(), filled), true);
                    if (!toUpdate.contains(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)))) {
                        toUpdate.add(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                    }
                    if (toUpdate.contains(this.func_174877_v())) continue;
                    toUpdate.add(this.func_174877_v());
                }
            }
            for (int i = 0; i < toUpdate.size(); ++i) {
                TileEntity tile = this.func_145831_w().func_175625_s((BlockPos)toUpdate.get(i));
                tile.func_70296_d();
                if (this.func_145831_w().field_72995_K || tile instanceof ITileEntityBase) continue;
                tile.func_70296_d();
                EventManager.markTEForUpdate((BlockPos)toUpdate.get(i), tile);
            }
        }
        this.from.clear();
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), (TileEntity)this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    public static enum EnumPipeConnection {
        NONE,
        PIPE,
        BLOCK,
        LEVER,
        FORCENONE;

    }
}

