/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.tileentity.TileEntityFacingBase;
import shetiphian.terraqueous.common.block.BlockPergola;

public abstract class TileEntityPergolaBase
extends TileEntityFacingBase
implements IRGB16_Tile {
    private RGB16 rgb16;
    private String savedtype = null;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74777_a("rgb16", this.getRGB16(null).getIndex());
        String style = this.getSavedType(true);
        if (!Strings.isNullOrEmpty((String)style)) {
            nbtTag.func_74778_a("style", style);
        }
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.loadRGB16(nbtTag.func_74765_d("rgb16"));
        if (nbtTag.func_74764_b("style")) {
            this.setSavedType(nbtTag.func_74779_i("style"));
        }
    }

    public IBlockState getActualState(IBlockState state) {
        return state;
    }

    public IBlockState getExtraState(IBlockState state) {
        String style = this.getSavedType(false);
        if (Strings.isNullOrEmpty((String)style)) {
            this.setSavedType(this.getType());
            style = this.getSavedType(false);
        }
        if (Strings.isNullOrEmpty((String)style)) {
            return state;
        }
        String[] split = style.split(",");
        for (byte index = 0; index < split.length; index = (byte)(index + 1)) {
            PropertyEnum<BlockPergola.EnumStyle> property = this.getProperty(index);
            if (property == null) continue;
            String name = split[index];
            try {
                name = name.split("=")[1];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            state = state.func_177226_a(property, (Comparable)((Object)BlockPergola.EnumStyle.byName(name)));
        }
        return state;
    }

    private PropertyEnum<BlockPergola.EnumStyle> getProperty(byte index) {
        switch (index) {
            case 0: {
                return BlockPergola.EDATA;
            }
            case 1: {
                return BlockPergola.NDATA;
            }
            case 2: {
                return BlockPergola.SDATA;
            }
            case 3: {
                return BlockPergola.WDATA;
            }
            case 4: {
                return BlockPergola.XDATA;
            }
        }
        return null;
    }

    protected abstract String getType();

    public abstract AxisAlignedBB getBoxBounds();

    public abstract List<AxisAlignedBB> getCollisionBoxes();

    public String getSavedType(boolean buildIfNull) {
        if (buildIfNull && Strings.isNullOrEmpty((String)this.savedtype)) {
            this.setSavedType(this.getType());
        }
        return this.savedtype;
    }

    protected void setSavedType(String type) {
        String last = this.getSavedType(false);
        this.savedtype = type;
        if (!(last != null && last.equals(type) || this.func_145831_w() == null || this.func_145831_w().field_72995_K)) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        }
    }

    boolean isNorthOrSouth(EnumFacing facing) {
        return facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH;
    }

    public void neighborChanged(Block neighbor) {
        this.setSavedType(this.getType());
        Function.syncTile((TileEntity)this);
    }

    public int colorMultiplier() {
        return this.rgb16 != null ? this.rgb16.getColor() : 0xFFFFFF;
    }

    private boolean loadRGB16(short rgbIndex) {
        return rgbIndex > -1 && rgbIndex < 4096 && this.getRGB16(null).setValues(rgbIndex);
    }

    public RGB16 getRGB16(EntityPlayer player) {
        if (this.rgb16 == null) {
            this.rgb16 = new RGB16("dyeWhite");
        }
        return this.rgb16;
    }

    public boolean setRGB16(short rgbIndex, EntityPlayer player) {
        boolean result = this.loadRGB16(rgbIndex);
        if (result) {
            Function.syncTile((TileEntity)this);
        }
        return result;
    }

    protected boolean isFacingValid(EnumFacing facing) {
        return facing != null && facing.func_176740_k() != EnumFacing.Axis.Y;
    }

    public static abstract class Directionless
    extends TileEntityPergolaBase {
        protected boolean saveFacing() {
            return false;
        }

        @Override
        protected boolean isFacingValid(EnumFacing facing) {
            return true;
        }
    }
}

