/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.terraqueous.common.item.ItemEquipable;
import shetiphian.terraqueous.modintegration.baubles.Baubles_Base;

public class ItemToonTrotters
extends ItemEquipable
implements ICapabilityProvider {
    @GameRegistry.ObjectHolder(value="minecraft:feather_falling")
    private static Enchantment FEATHER_FALLING;

    public ItemToonTrotters() {
        super("ToonTrotters", EntityEquipmentSlot.FEET);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        ItemToonTrotters.checkFall(stack, (EntityLivingBase)player);
    }

    public static void checkFall(ItemStack stack, EntityLivingBase entity) {
        if (stack.func_190926_b() || entity.field_70181_x >= 0.0) {
            return;
        }
        NBTTagCompound tag = stack.func_190925_c("status");
        byte status = tag.func_74771_c("active_state");
        World world = entity.func_130014_f_();
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v).func_177977_b();
        boolean toonWalk = false;
        switch (status) {
            case 0: {
                if (!(entity.func_70051_ag() && entity.field_70125_A < 15.0f) && !(entity.field_70125_A < -15.0f)) break;
                IBlockState state = world.func_180495_p(pos);
                toonWalk = state.func_185904_a().func_76224_d();
                if (!toonWalk) {
                    int counter = 0;
                    for (int scan = 0; scan < 2 && !ItemToonTrotters.isGround(world, pos, state); ++scan) {
                        ++counter;
                        pos = pos.func_177977_b();
                        state = world.func_180495_p(pos);
                    }
                    boolean bl = toonWalk = counter > 1;
                }
                if (!toonWalk) break;
                tag.func_74774_a("active_state", (byte)1);
                break;
            }
            case 1: {
                if (ItemToonTrotters.isGround(world, pos, null)) {
                    tag.func_74774_a("active_state", (byte)0);
                    break;
                }
                if (entity.func_70093_af() || entity.field_70125_A > 30.0f) {
                    tag.func_74774_a("active_state", (byte)-1);
                    break;
                }
                toonWalk = true;
                break;
            }
            default: {
                if (!entity.field_70122_E) break;
                tag.func_74774_a("active_state", (byte)0);
            }
        }
        if (toonWalk) {
            entity.field_70181_x = 0.0;
            entity.field_70143_R = 0.0f;
        }
    }

    private static boolean isGround(World world, BlockPos pos, IBlockState state) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        if (state == null) {
            state = world.func_180495_p(pos);
        }
        return !state.func_185904_a().func_76224_d() && !state.func_185904_a().func_76222_j();
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return ItemArmor.ArmorMaterial.LEATHER.func_78045_a();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == FEATHER_FALLING;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return this;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        Object bauble = Baubles_Base.INSTANCE.getCapability(capability, "toon_trotters");
        if (bauble != null) {
            return (T)bauble;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advancedTooltips) {
        Localization.multiLine((String)"info.terraqueous.toon_trotters.msg", tooltip);
    }
}

