/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.GameRegistry;
import shetiphian.terraqueous.common.item.ItemEquipable;
import shetiphian.terraqueous.modintegration.baubles.Baubles_Base;

public class ItemBurniumBelt
extends ItemEquipable
implements ICapabilityProvider {
    @GameRegistry.ObjectHolder(value="minecraft:efficiency")
    private static Enchantment EFFICIENCY;
    @GameRegistry.ObjectHolder(value="minecraft:fire_protection")
    private static Enchantment FIRE_PROTECTION;

    public ItemBurniumBelt() {
        super("BurniumBelt", EntityEquipmentSlot.LEGS);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        NBTTagCompound tag;
        short heat;
        boolean cool;
        if (stack.func_190926_b() || !(entity instanceof EntityLivingBase)) {
            return;
        }
        boolean bl = cool = itemSlot != EntityEquipmentSlot.LEGS.func_188454_b();
        if (!cool) {
            Iterable list = entity.func_184193_aE();
            for (ItemStack armor : list) {
                if (!armor.equals(stack)) continue;
                return;
            }
        }
        if (cool && (heat = (tag = stack.func_190925_c("status")).func_74765_d("heat")) > 0) {
            ItemBurniumBelt.cooldown(stack, heat, tag);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        ItemBurniumBelt.adjustHeat(stack, (EntityLivingBase)player);
    }

    public static void adjustHeat(ItemStack stack, EntityLivingBase entity) {
        if (stack.func_190926_b()) {
            return;
        }
        NBTTagCompound tag = stack.func_190925_c("status");
        short heat = tag.func_74765_d("heat");
        if (entity.func_70027_ad() || entity.func_180799_ab()) {
            if ((heat = (short)(heat + 1)) < ItemBurniumBelt.getMax(stack) + 1) {
                tag.func_74777_a("heat", heat);
                if (!entity.func_70045_F()) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 20, 0, true, false));
                }
                entity.func_70066_B();
            }
        } else if (heat > 0) {
            ItemBurniumBelt.cooldown(stack, heat, tag);
        }
    }

    private static short getMax(ItemStack stack) {
        int max = 2400;
        if (FIRE_PROTECTION != null && !stack.func_190926_b()) {
            max += 2400 * EnchantmentHelper.func_77506_a((Enchantment)FIRE_PROTECTION, (ItemStack)stack);
        }
        return (short)Math.min(max, Short.MAX_VALUE);
    }

    private static void cooldown(ItemStack stack, short heat, NBTTagCompound tag) {
        int value;
        int reduction = 1;
        if (FIRE_PROTECTION != null) {
            reduction += EnchantmentHelper.func_77506_a((Enchantment)FIRE_PROTECTION, (ItemStack)stack);
        }
        if (EFFICIENCY != null && (value = EnchantmentHelper.func_77506_a((Enchantment)EFFICIENCY, (ItemStack)stack)) > 0) {
            reduction *= value + 1;
        }
        tag.func_74777_a("heat", (short)Math.max(0, heat - reduction));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0.0;
        }
        NBTTagCompound tag = stack.func_190925_c("status");
        return (double)tag.func_74765_d("heat") / (double)ItemBurniumBelt.getMax(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return ItemArmor.ArmorMaterial.GOLD.func_78045_a();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == EFFICIENCY || enchantment == FIRE_PROTECTION;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return this;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        Object bauble = Baubles_Base.INSTANCE.getCapability(capability, "burnium_belt");
        if (bauble != null) {
            return (T)bauble;
        }
        return null;
    }
}

