/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.IColored;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.client.misc.FoliageColor;
import shetiphian.terraqueous.common.block.BlockTreeFoliage;

public class ItemBlockTreeFoliage
extends ItemBlockMulti
implements IColored {
    private final String[] names;

    public ItemBlockTreeFoliage(Block block, Integer index) {
        super(block, "BlockTreeFoliage" + (index + 1), Values.nameMapper);
        this.names = ItemBlockTreeFoliage.getNames(index);
        this.doNameMapping();
    }

    public void getSubItems(NonNullList<ItemStack> list) {
        if (this.names != null) {
            for (int meta = 0; meta < this.names.length; ++meta) {
                list.add((Object)new ItemStack((Item)this, 1, meta * 4));
                list.add((Object)new ItemStack((Item)this, 1, meta * 4 + 1));
                list.add((Object)new ItemStack((Item)this, 1, meta * 4 + 2));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (!data.stack.func_190926_b() && this.field_150939_a instanceof BlockTreeFoliage) {
            IBlockState state = this.field_150939_a.func_176203_a(data.stack.func_77960_j());
            return FoliageColor.getRenderColor(FoliageColor.EnumFoliage.getFoliage(((BlockTreeFoliage)this.field_150939_a).getTreeType(state)));
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advancedTooltips) {
        int dmg = stack.func_77952_i() % 4;
        if (dmg == 1) {
            tooltip.add(Localization.get((String)"info.terraqueous.growingfruit.txt"));
        } else if (dmg == 2) {
            tooltip.add(Localization.get((String)"info.terraqueous.withfruit.txt"));
        }
    }

    protected void addToNameMap() {
    }

    private void doNameMapping() {
        if (this.names != null) {
            for (int meta = 0; meta < this.names.length; ++meta) {
                this.add(meta * 4, "trees/", this.names[meta] + "_leaves", this.names[meta]);
                this.add(meta * 4 + 1, "trees/", this.names[meta] + "_leaves_flower", this.names[meta]);
                this.add(meta * 4 + 2, "trees/", this.names[meta] + "_leaves_fruit", this.names[meta]);
            }
        }
    }

    private static String[] getNames(int index) {
        switch (index) {
            case 0: {
                return new String[]{"apple", "cherry"};
            }
            case 1: {
                return new String[]{"orange", "pear"};
            }
            case 2: {
                return new String[]{"peach", "mango"};
            }
            case 3: {
                return new String[]{"lemon", "plum"};
            }
            case 4: {
                return new String[]{"coconut", "banana"};
            }
        }
        return new String[]{"error"};
    }
}

