/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.core.common.tileentity.TileEntityExtendedRedstone;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.misc.BlueFlowerHandler;

public class BlockBorder
extends Block
implements IColored,
IRGB16_Block {
    private static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"border", EnumType.class);
    private static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    private static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    private static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    private static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    @GameRegistry.ObjectHolder(value="minecraft:speed")
    private static Potion SPEED;
    @GameRegistry.ObjectHolder(value="minecraft:slowness")
    private static Potion SLOW;
    private static final AxisAlignedBB[] AABB_BY_INDEX;
    private static final AxisAlignedBB[] ALT_AABB_BY_INDEX;

    public BlockBorder() {
        super(Material.field_151570_A);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, NORTH, EAST, SOUTH, WEST});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return BlockBorder.getEnumType(state).getValue();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType style = BlockBorder.getEnumType(state);
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.isConnectedTo(world, pos, EnumFacing.NORTH, style))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.isConnectedTo(world, pos, EnumFacing.EAST, style))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.isConnectedTo(world, pos, EnumFacing.SOUTH, style))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.isConnectedTo(world, pos, EnumFacing.WEST, style)));
    }

    private boolean isConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing, EnumType style) {
        IBlockState state = world.func_180495_p(pos.func_177972_a(facing));
        return state.func_177230_c() instanceof BlockBorder && BlockBorder.getEnumType(state) == style;
    }

    public boolean hasTileEntity(IBlockState state) {
        EnumType type = BlockBorder.getEnumType(state);
        return type == EnumType.WAVE || type == EnumType.SPEED;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        EnumType type = BlockBorder.getEnumType(state);
        return type == EnumType.WAVE ? new TileEntityRGB16() : new TileEntityExtendedRedstone();
    }

    public TileEntityRGB16 getTile(IBlockAccess world, BlockPos pos) {
        try {
            return (TileEntityRGB16)world.func_175625_s(pos);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        EnumType type = BlockBorder.getEnumType(state);
        return type == EnumType.SPEED ? 0.0f : (type == EnumType.SPIKE ? 0.5f : 0.3f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        int index = 0;
        if (state.func_177230_c() instanceof BlockBorder) {
            if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
                index |= 1 << EnumFacing.NORTH.func_176736_b();
            }
            if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
                index |= 1 << EnumFacing.EAST.func_176736_b();
            }
            if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
                index |= 1 << EnumFacing.SOUTH.func_176736_b();
            }
            if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
                index |= 1 << EnumFacing.WEST.func_176736_b();
            }
        }
        EnumType type = BlockBorder.getEnumType(state);
        if (index == 0) {
            return type == EnumType.WAVE ? ALT_AABB_BY_INDEX[0] : AABB_BY_INDEX[0];
        }
        return type == EnumType.SPEED ? ALT_AABB_BY_INDEX[index] : AABB_BY_INDEX[index];
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean p_185477_7_) {
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return null;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return facing != EnumFacing.UP && facing != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.CENTER_SMALL;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof BlockBorder;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack stack = new ItemStack((Block)this, 1, this.func_180651_a(state));
        TileEntityRGB16 tile = this.getTile(world, pos);
        if (tile != null && stack.func_77973_b() instanceof IRGB16_Item) {
            ((IRGB16_Item)stack.func_77973_b()).setRGB16(stack, tile.getRGB16(null).getIndex());
        }
        drops.add((Object)stack);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.notifyRedstonePower(state, world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos pos2) {
        if (!this.canBlockStay(world, pos)) {
            world.func_175655_b(pos, true);
        } else {
            this.notifyRedstonePower(state, world, pos);
            super.func_189540_a(state, world, pos, neighbor, pos2);
        }
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        this.notifyRedstonePower(state, world, pos);
    }

    public boolean func_149744_f(IBlockState state) {
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return world.func_175625_s(pos) instanceof TileEntityExtendedRedstone;
    }

    private void notifyRedstonePower(IBlockState state, World world, BlockPos pos) {
        TileEntity tile;
        if (!world.field_72995_K && this.canConnectRedstone(state, (IBlockAccess)world, pos, EnumFacing.DOWN) && (tile = world.func_175625_s(pos)) instanceof TileEntityExtendedRedstone) {
            ((TileEntityExtendedRedstone)tile).setEnabled(this.getSpeedAxis((IBlockAccess)world, pos) != null);
            ((TileEntityExtendedRedstone)tile).updatePower();
        }
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.canConnectRedstone(state, world, pos, side)) {
            TileEntity tile = world.func_175625_s(pos);
            return tile instanceof TileEntityExtendedRedstone ? ((TileEntityExtendedRedstone)tile).getRSPower() : 0;
        }
        return 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            if (!entityLiving.func_174813_aQ().func_72326_a(this.func_185496_a(state, (IBlockAccess)world, pos).func_186670_a(pos))) {
                return;
            }
            boolean isPlayer = entity instanceof EntityPlayer;
            switch (BlockBorder.getEnumType(state)) {
                case WAVE: {
                    if (SLOW == null) break;
                    entityLiving.func_70690_d(new PotionEffect(SLOW));
                    break;
                }
                case SPIKE: {
                    entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
                    if (SPEED != null) {
                        entityLiving.func_184589_d(SPEED);
                    }
                    if (SLOW == null) break;
                    entityLiving.func_70690_d(new PotionEffect(SLOW, 20));
                    break;
                }
                case TRANSMUTE: {
                    if (!isPlayer) {
                        BlueFlowerHandler.INSTANCE.mobTransmute(entity, false);
                    }
                    if (SLOW == null) break;
                    entityLiving.func_70690_d(new PotionEffect(SLOW));
                    break;
                }
                case NECROTIC: {
                    if (!isPlayer) {
                        BlueFlowerHandler.INSTANCE.mobTransmute(entity, true);
                    }
                    if (SLOW == null) break;
                    entityLiving.func_70690_d(new PotionEffect(SLOW));
                    break;
                }
                case SPEED: {
                    TileEntity tile = world.func_175625_s(pos);
                    BlockLog.EnumAxis axis = this.getSpeedAxis((IBlockAccess)world, pos);
                    if (axis == null || !(tile instanceof TileEntityExtendedRedstone)) break;
                    int power = ((TileEntityExtendedRedstone)tile).getRSPower();
                    if (SLOW != null) {
                        entityLiving.func_184589_d(SLOW);
                    }
                    if (SPEED == null) break;
                    entityLiving.func_70690_d(new PotionEffect(SPEED, (power % 5 + 1) * 20, power / 5));
                }
            }
        }
        super.func_180634_a(world, pos, state, entity);
    }

    private BlockLog.EnumAxis getSpeedAxis(IBlockAccess world, BlockPos pos) {
        boolean north = this.isConnectedTo(world, pos, EnumFacing.NORTH, EnumType.SPEED);
        boolean east = this.isConnectedTo(world, pos, EnumFacing.EAST, EnumType.SPEED);
        boolean south = this.isConnectedTo(world, pos, EnumFacing.SOUTH, EnumType.SPEED);
        boolean west = this.isConnectedTo(world, pos, EnumFacing.WEST, EnumType.SPEED);
        if ((north || south) && !east && !west) {
            return BlockLog.EnumAxis.Z;
        }
        if (!north && !south && (east || west)) {
            return BlockLog.EnumAxis.X;
        }
        return null;
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntityRGB16 tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            EnumDyeColor current = tile.getRGB16(null).getDyeColor();
            tile.setRGB16(RGB16Helper.getIndexFor((EnumDyeColor)color), null);
            return current != color;
        }
        return false;
    }

    public boolean recolorBlock(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, Vec3d hitVec, String dyeName) {
        TileEntityRGB16 tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = this.getTile((IBlockAccess)world, pos)) != null) {
            if (!world.field_72995_K) {
                tile.getRGB16(player).recolor(player, dyeName);
                Function.syncTile((TileEntity)tile);
            }
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index == 1 && data.world != null && data.pos != null) {
            EnumType type;
            TileEntity tile = data.world.func_175625_s(data.pos);
            if (tile instanceof TileEntityRGB16) {
                return ((TileEntityRGB16)tile).getRGB16(null).getColor();
            }
            if (data.state != null && (type = BlockBorder.getEnumType(data.state)) == EnumType.SPEED && tile instanceof TileEntityExtendedRedstone) {
                return BlockRedstoneWire.func_176337_b((int)((TileEntityExtendedRedstone)tile).getRSPower());
            }
        }
        return 0xFFFFFF;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        TileEntityRGB16 tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            RGB16StackHelper.setRGB16((ItemStack)stack, (RGB16)tile.getRGB16(null));
        }
        return stack;
    }

    private static EnumType getEnumType(IBlockState state) {
        EnumType style;
        try {
            style = (EnumType)((Object)state.func_177229_b(TYPE));
        }
        catch (Exception e) {
            style = EnumType.WAVE;
            Terraqueous.errorPropertyNotFound("BlockBarrier.TYPE", "WAVE", state.toString());
        }
        return style;
    }

    static {
        AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.46875, 0.0, 0.46875, 0.53125, 0.5, 0.53125), new AxisAlignedBB(0.46875, 0.0, 0.46875, 0.53125, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.46875, 0.53125, 0.5, 0.53125), new AxisAlignedBB(0.0, 0.0, 0.46875, 0.53125, 0.5, 1.0), new AxisAlignedBB(0.46875, 0.0, 0.0, 0.53125, 0.5, 0.53125), new AxisAlignedBB(0.46875, 0.0, 0.0, 0.53125, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.53125, 0.5, 0.53125), new AxisAlignedBB(0.0, 0.0, 0.0, 0.53125, 0.5, 1.0), new AxisAlignedBB(0.46875, 0.0, 0.46875, 1.0, 0.5, 0.53125), new AxisAlignedBB(0.46875, 0.0, 0.46875, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.46875, 1.0, 0.5, 0.53125), new AxisAlignedBB(0.0, 0.0, 0.46875, 1.0, 0.5, 1.0), new AxisAlignedBB(0.46875, 0.0, 0.0, 1.0, 0.5, 0.53125), new AxisAlignedBB(0.46875, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.53125), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)};
        ALT_AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.46875, 0.0, 0.46875, 0.53125, 0.375, 0.53125), new AxisAlignedBB(0.34375, 0.0, 0.46875, 0.65625, 0.03125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.34375, 0.53125, 0.03125, 0.65625), new AxisAlignedBB(0.0, 0.0, 0.34375, 0.65625, 0.03125, 1.0), new AxisAlignedBB(0.34375, 0.0, 0.0, 0.65625, 0.03125, 0.53125), new AxisAlignedBB(0.34375, 0.0, 0.0, 0.65625, 0.03125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.65625, 0.03125, 0.65625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.65625, 0.03125, 1.0), new AxisAlignedBB(0.46875, 0.0, 0.34375, 1.0, 0.03125, 0.65625), new AxisAlignedBB(0.34375, 0.0, 0.34375, 1.0, 0.03125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.34375, 1.0, 0.03125, 0.65625), new AxisAlignedBB(0.0, 0.0, 0.34375, 1.0, 0.03125, 1.0), new AxisAlignedBB(0.34375, 0.0, 0.0, 1.0, 0.03125, 0.65625), new AxisAlignedBB(0.34375, 0.0, 0.0, 1.0, 0.03125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.03125, 0.65625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.03125, 1.0)};
    }

    public static enum EnumType implements IStringSerializable
    {
        WAVE(0),
        SPIKE(1),
        TRANSMUTE(2),
        NECROTIC(3),
        SPEED(4);

        private static final EnumType[] array;
        private final int value;

        private EnumType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            return array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[5];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType style;
                EnumType.array[style.getValue()] = style = enumTypeArray[i];
            }
        }
    }
}

