/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import shetiphian.core.common.FuelHelper;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Registry;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.client.render.RenderRegistry;
import shetiphian.terraqueous.common.command.StormForgeCommand;
import shetiphian.terraqueous.common.crafting.Recipes;
import shetiphian.terraqueous.common.misc.DeathFruitHelper;
import shetiphian.terraqueous.common.misc.PitchforkHelper;
import shetiphian.terraqueous.common.misc.ProxyCommon;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.modintegration.ModIntegration;

@Mod(modid="terraqueous", name="Terraqueous", version="1.4.16", dependencies="required-after:shetiphiancore@[3.5.4,);after:baubles@[1.5.1,)", updateJSON="https://gist.githubusercontent.com/ShetiPhian/5a4332ca6221ae61ab3c6d531a989f21/raw/Terraqueous", acceptedMinecraftVersions="[1.12]")
@Mod.EventBusSubscriber
public class Terraqueous {
    @SidedProxy(clientSide="shetiphian.terraqueous.client.misc.ProxyClient", serverSide="shetiphian.terraqueous.common.misc.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance(value="terraqueous")
    public static Terraqueous INSTANCE;
    public static final String MOD_ID = "terraqueous";

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Registry.INSTANCE.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Registry.INSTANCE.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        Registry.INSTANCE.registerItems((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerPotionTypes(RegistryEvent.Register<PotionType> event) {
        Registry.INSTANCE.registerPotionTypes((IForgeRegistry<PotionType>)event.getRegistry());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void modelRegistryEvent(ModelRegistryEvent event) throws Exception {
        RenderRegistry.renderingPreInt();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Values.logTerraqueous = event.getModLog();
        proxy.renderingPreInt();
        GameRegistry.registerFuelHandler((IFuelHandler)FuelHelper.INSTANCE);
        DeathFruitHelper.INSTANCE.register();
        PitchforkHelper.INSTANCE.register();
        new ModIntegration().preInit();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        Registry.INSTANCE.doRegistration();
        NetworkHandler.initialise();
        proxy.renderingInt();
        proxy.registerEventHandlers();
        new Recipes().loadRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        new ModIntegration().load();
        Configuration.EventHandler.cleanup();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Configuration.EventHandler.process();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new StormForgeCommand());
    }

    @Mod.EventHandler
    public void fmlInterModComms(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            try {
                if (msg.isStringMessage()) {
                    String[] data;
                    String regex = "~NOT-SET~";
                    if (msg.key.equals("addCloudBlock")) {
                        regex = "[^:, ]*:[^:, ]*,[0-9]*-[0-9]*,\\?(true|false)";
                        if (msg.getStringValue().matches(regex)) {
                            data = msg.getStringValue().split(",");
                            String[] numbers = data[1].split("-");
                            CloudAPI.addCloudBlock(data[0], Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1]), Boolean.parseBoolean(data[2].replace("?", "")));
                            continue;
                        }
                    } else if (msg.key.equals("addCloudWalkItem")) {
                        regex = "[^:, ]*:[^:, ]*,[0-9]*";
                        if (msg.getStringValue().matches(regex)) {
                            data = msg.getStringValue().split(",");
                            CloudAPI.addCloudWalkItem(data[0], Integer.parseInt(data[1]));
                            continue;
                        }
                    }
                    if (!regex.equals("~NOT-SET~")) {
                        Values.logTerraqueous.error(String.format("Received an invalid %s IMC: %s from mod %s. Regex Check Failure: %s", msg.key, msg.getStringValue(), msg.getSender(), regex));
                        continue;
                    }
                }
                Values.logTerraqueous.error(String.format("Received an unknown IMC: %s from mod %s.", msg.key, msg.getSender()));
            }
            catch (Exception e) {
                if (msg.isStringMessage()) {
                    Values.logTerraqueous.error(String.format("Received an invalid %s IMC: %s from mod %s", msg.key, msg.getStringValue(), msg.getSender()));
                    continue;
                }
                Values.logTerraqueous.error(String.format("Received an invalid %s IMC from mod %s", msg.key, msg.getSender()));
            }
        }
    }

    public static void errorPropertyNotFound(String property, String returning, String state) {
        Values.logTerraqueous.error("PropertyEnum '" + property + "' not found in provided BlockState, returning '" + returning + "'. Provided BlockState: " + state);
    }

    @Nonnull
    public static ItemStack getCustomItemStack(String name, int ... amount) {
        return Values.stacks.get(name, amount);
    }
}

