/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.api.configuration.Configurations;
import com.ldtteam.structurize.api.util.ChangeStorage;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.InstantStructurePlacer;
import com.mojang.authlib.GameProfile;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class ScanToolOperation {
    private final OperationType operation;
    private BlockPos startPos;
    private BlockPos currentPos;
    private final BlockPos endPos;
    private final EntityPlayer player;
    private final ChangeStorage storage;
    private final ItemStack firstBlock;
    private final ItemStack secondBlock;
    private final InstantStructurePlacer wrapper;

    public ScanToolOperation(OperationType type, BlockPos startPos, BlockPos endPos, EntityPlayer player, ItemStack firstBlock, ItemStack secondBlock) {
        this.operation = type;
        this.startPos = new BlockPos(Math.min(startPos.func_177958_n(), endPos.func_177958_n()), Math.min(startPos.func_177956_o(), endPos.func_177956_o()), Math.min(startPos.func_177952_p(), endPos.func_177952_p()));
        this.currentPos = new BlockPos(Math.min(startPos.func_177958_n(), endPos.func_177958_n()), Math.min(startPos.func_177956_o(), endPos.func_177956_o()), Math.min(startPos.func_177952_p(), endPos.func_177952_p()));
        this.endPos = new BlockPos(Math.max(startPos.func_177958_n(), endPos.func_177958_n()), Math.max(startPos.func_177956_o(), endPos.func_177956_o()), Math.max(startPos.func_177952_p(), endPos.func_177952_p()));
        this.player = player;
        this.firstBlock = firstBlock;
        this.secondBlock = secondBlock;
        this.storage = new ChangeStorage(player);
        this.wrapper = null;
    }

    public ScanToolOperation(ChangeStorage storage, EntityPlayer player) {
        this.operation = OperationType.UNDO;
        this.startPos = BlockPos.field_177992_a;
        this.currentPos = BlockPos.field_177992_a;
        this.endPos = BlockPos.field_177992_a;
        this.player = player;
        this.firstBlock = ItemStack.field_190927_a;
        this.secondBlock = ItemStack.field_190927_a;
        this.storage = storage;
        this.wrapper = null;
    }

    public ScanToolOperation(InstantStructurePlacer wrapper, EntityPlayer player) {
        this.operation = OperationType.PLACE_STRUCTURE;
        this.startPos = BlockPos.field_177992_a;
        this.currentPos = BlockPos.field_177992_a;
        this.endPos = BlockPos.field_177992_a;
        this.player = player;
        this.firstBlock = ItemStack.field_190927_a;
        this.secondBlock = ItemStack.field_190927_a;
        this.storage = new ChangeStorage(player);
        this.wrapper = wrapper;
    }

    public boolean apply(WorldServer world) {
        if (this.player.field_71093_bK != world.field_73011_w.getDimension()) {
            return false;
        }
        if (this.operation == OperationType.UNDO) {
            return this.storage.undo((World)world);
        }
        if (this.operation == OperationType.PLACE_STRUCTURE) {
            this.currentPos = this.wrapper.placeStructure((World)world, this.storage, this.currentPos);
            return this.currentPos == null;
        }
        return this.run(world);
    }

    private boolean run(WorldServer world) {
        FakePlayer fakePlayer = new FakePlayer(world, new GameProfile(this.player.func_110124_au(), "placeStuffForMePl0x"));
        int count = 0;
        for (int y = this.currentPos.func_177956_o(); y <= this.endPos.func_177956_o(); ++y) {
            for (int x = this.currentPos.func_177958_n(); x <= this.endPos.func_177958_n(); ++x) {
                for (int z = this.currentPos.func_177952_p(); z <= this.endPos.func_177952_p(); ++z) {
                    BlockPos here = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(here);
                    ItemStack stack = BlockUtils.getItemStackFromBlockState(blockState);
                    if (!ScanToolOperation.correctBlockToRemoveOrReplace(stack, blockState, this.firstBlock) || blockState.func_177230_c() instanceof BlockDoor && blockState.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER || blockState.func_177230_c() instanceof BlockBed && blockState.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD) continue;
                    ++count;
                    this.storage.addPositionStorage(here, (World)world);
                    world.func_175698_g(here);
                    if (this.operation == OperationType.REPLACE_BLOCK) {
                        BlockUtils.handleCorrectBlockPlacement((World)world, fakePlayer, this.secondBlock, blockState, here);
                    }
                    if (count < Configurations.gameplay.maxOperationsPerTick) continue;
                    this.currentPos = new BlockPos(x, y, z);
                    return false;
                }
                this.currentPos = new BlockPos(x, y, this.startPos.func_177952_p());
            }
            this.currentPos = new BlockPos(this.startPos.func_177958_n(), y, this.startPos.func_177952_p());
        }
        return true;
    }

    private static boolean correctBlockToRemoveOrReplace(ItemStack worldStack, IBlockState worldState, ItemStack compareStack) {
        return worldStack != null && worldStack.func_77969_a(compareStack) || compareStack.func_77973_b() == Items.field_151129_at && (worldState.func_177230_c() == Blocks.field_150353_l || worldState.func_177230_c() == Blocks.field_150356_k) || compareStack.func_77973_b() == Items.field_151131_as && (worldState.func_177230_c() == Blocks.field_150355_j || worldState.func_177230_c() == Blocks.field_150358_i) || compareStack.func_77973_b() == Items.field_190931_a && worldState.func_177230_c() == Blocks.field_150350_a;
    }

    public ChangeStorage getChangeStorage() {
        return this.storage;
    }

    public boolean isUndo() {
        return this.operation == OperationType.UNDO;
    }

    public static enum OperationType {
        REMOVE_BLOCK,
        REPLACE_BLOCK,
        REMOVE_ENTITY,
        SCAN,
        PLACE_STRUCTURE,
        UNDO;

    }
}

