/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structures.lib.BlueprintUtils;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ClientEventHandler {
    @SubscribeEvent
    public void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        Structure structure = Settings.instance.getActiveStructure();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (structure != null) {
            BlockPos smallOffset;
            BlockPos primaryOffset = BlueprintUtils.getPrimaryBlockOffset(structure.getBluePrint());
            BlockPos offset = primaryOffset.func_190942_a(BlockPosUtil.getRotationFromRotations(Settings.instance.getRotation()));
            BlockPos pos = Settings.instance.getPosition().func_177973_b((Vec3i)offset);
            BlockPos size = structure.getSize(BlockPosUtil.getRotationFromRotations(Settings.instance.getRotation()), Settings.instance.getMirror());
            boolean mirrored = Settings.instance.getMirror() != Mirror.NONE;
            switch (Settings.instance.getRotation()) {
                case 1: {
                    size = new BlockPos(-size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
                    smallOffset = new BlockPos(-1, 1, 1);
                    if (!mirrored) break;
                    pos = pos.func_177982_a(0, 0, -size.func_177952_p() + 2 * offset.func_177952_p() + 1);
                    break;
                }
                case 2: {
                    if (mirrored) {
                        pos = pos.func_177982_a(size.func_177958_n() - 2 * primaryOffset.func_177958_n() - 1, 0, 0);
                    }
                    size = new BlockPos(-size.func_177958_n(), size.func_177956_o(), -size.func_177952_p());
                    smallOffset = new BlockPos(-1, 1, -1);
                    break;
                }
                case 3: {
                    if (mirrored) {
                        pos = pos.func_177982_a(0, 0, size.func_177952_p() + 2 * offset.func_177952_p() - 1);
                    }
                    size = new BlockPos(size.func_177958_n(), size.func_177956_o(), -size.func_177952_p());
                    smallOffset = new BlockPos(1, 1, -1);
                    break;
                }
                default: {
                    if (mirrored) {
                        pos = pos.func_177982_a(-size.func_177958_n() + 2 * primaryOffset.func_177958_n() + 1, 0, 0);
                    }
                    smallOffset = new BlockPos(1, 1, 1);
                }
            }
            ClientEventHandler.renderBox(pos, pos.func_177971_a((Vec3i)size).func_177973_b((Vec3i)smallOffset), (EntityPlayer)player, event);
        }
        if (Settings.instance.getBox() != null) {
            ClientEventHandler.renderBox((BlockPos)Settings.instance.getBox().func_76341_a(), (BlockPos)Settings.instance.getBox().func_76340_b(), (EntityPlayer)player, event);
        }
    }

    private static void renderBox(BlockPos posA, BlockPos posB, EntityPlayer player, RenderWorldLastEvent event) {
        int x1 = posA.func_177958_n();
        int y1 = posA.func_177956_o();
        int z1 = posA.func_177952_p();
        int x2 = posB.func_177958_n();
        int y2 = posB.func_177956_o();
        int z2 = posB.func_177952_p();
        if (x1 > x2) {
            ++x1;
        } else {
            ++x2;
        }
        if (y1 > y2) {
            ++y1;
        } else {
            ++y2;
        }
        if (z1 > z2) {
            ++z1;
        } else {
            ++z2;
        }
        double renderPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double renderPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double renderPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        RenderGlobal.func_189697_a((AxisAlignedBB)axisalignedbb.func_186662_g(0.002).func_72317_d(-renderPosX, -renderPosY, -renderPosZ), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }
}

