/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.google.common.collect.Lists;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.util.StructureUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class UpdateSchematics
implements ICommand {
    public int compareTo(@NotNull ICommand o) {
        return 0;
    }

    @NotNull
    public String func_71517_b() {
        return "updateschematics";
    }

    @NotNull
    public List<String> func_71514_a() {
        return Lists.newArrayList();
    }

    @NotNull
    public String func_71518_a(@NotNull ICommandSender sender) {
        return "/updateschematics";
    }

    public void func_184881_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args) throws CommandException {
        File updaterInput = new File(Structurize.proxy.getSchematicsFolder(), "/updater/input");
        File updaterOutput = new File(Structurize.proxy.getSchematicsFolder(), "/updater/output");
        updaterInput.mkdirs();
        for (File file : updaterInput.listFiles()) {
            this.update(file, updaterInput, updaterOutput);
        }
    }

    private void update(@NotNull File input, @NotNull File globalInputFolder, @NotNull File globalOutputFolder) {
        if (input.isDirectory()) {
            for (File file : input.listFiles()) {
                this.update(file, globalInputFolder, globalOutputFolder);
            }
            return;
        }
        if (input.getPath().endsWith(".blueprint")) {
            return;
        }
        try {
            File output = new File(globalOutputFolder, input.toString().replaceAll("\\.nbt", ".blueprint").replace(globalInputFolder.toString(), ""));
            output.getParentFile().mkdirs();
            NBTTagCompound blueprint = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(input.toPath(), new OpenOption[0]));
            if (blueprint == null || blueprint.func_82582_d()) {
                return;
            }
            blueprint = StructureUtils.getFixer().func_188257_a((IFixType)FixTypes.STRUCTURE, blueprint);
            NBTTagList blocks = blueprint.func_150295_c("blocks", 10);
            NBTTagList pallete = blueprint.func_150295_c("palette", 10);
            NBTTagCompound bluePrintCompound = new NBTTagCompound();
            NBTTagList list = blueprint.func_150295_c("size", 3);
            int[] size = new int[]{list.func_186858_c(0), list.func_186858_c(1), list.func_186858_c(2)};
            bluePrintCompound.func_74777_a("size_x", (short)size[0]);
            bluePrintCompound.func_74777_a("size_y", (short)size[1]);
            bluePrintCompound.func_74777_a("size_z", (short)size[2]);
            boolean addStructureVoid = blocks.func_74745_c() != size[0] * size[1] * size[2];
            short structureVoidID = 0;
            if (addStructureVoid) {
                structureVoidID = (short)pallete.func_74745_c();
                pallete.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)Blocks.field_189881_dj.func_176223_P()));
            }
            HashSet<String> mods = new HashSet<String>();
            for (int i = 0; i < pallete.func_74745_c(); ++i) {
                NBTTagCompound blockState = (NBTTagCompound)pallete.func_179238_g(i);
                String modid = blockState.func_74779_i("Name").split(":")[0];
                mods.add(modid);
            }
            NBTTagList requiredMods = new NBTTagList();
            for (String str : mods) {
                requiredMods.func_74742_a((NBTBase)new NBTTagString(str));
            }
            bluePrintCompound.func_74782_a("palette", (NBTBase)pallete);
            bluePrintCompound.func_74782_a("required_mods", (NBTBase)requiredMods);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            short[][][] dataArray = new short[size[1]][size[2]][size[0]];
            if (addStructureVoid) {
                for (int i = 0; i < size[1]; ++i) {
                    for (int j = 0; j < size[2]; ++j) {
                        for (int k = 0; k < size[0]; ++k) {
                            dataArray[i][j][k] = structureVoidID;
                        }
                    }
                }
            }
            NBTTagList tileEntities = new NBTTagList();
            for (int i = 0; i < blocks.func_74745_c(); ++i) {
                NBTTagCompound comp = blocks.func_150305_b(i);
                UpdateSchematics.updatePos(pos, comp);
                dataArray[pos.func_177956_o()][pos.func_177952_p()][pos.func_177958_n()] = (short)comp.func_74762_e("state");
                if (!comp.func_74764_b("nbt")) continue;
                NBTTagCompound te = (NBTTagCompound)comp.func_74781_a("nbt");
                te.func_74777_a("x", (short)pos.func_177958_n());
                te.func_74777_a("y", (short)pos.func_177956_o());
                te.func_74777_a("z", (short)pos.func_177952_p());
                tileEntities.func_74742_a((NBTBase)te);
            }
            bluePrintCompound.func_74783_a("blocks", UpdateSchematics.convertBlocksToSaveData(dataArray, (short)size[0], (short)size[1], (short)size[2]));
            bluePrintCompound.func_74782_a("tile_entities", (NBTBase)tileEntities);
            bluePrintCompound.func_74782_a("architects", (NBTBase)new NBTTagList());
            bluePrintCompound.func_74782_a("name", (NBTBase)new NBTTagString(input.getName().replaceAll("\\.nbt", "")));
            bluePrintCompound.func_74768_a("version", 1);
            NBTTagList newEntities = new NBTTagList();
            if (blueprint.func_74764_b("entities")) {
                NBTTagList entities = blueprint.func_150295_c("entities", 10);
                for (int i = 0; i < entities.func_74745_c(); ++i) {
                    NBTTagCompound entityData = entities.func_150305_b(i);
                    NBTTagCompound entity = entityData.func_74775_l("nbt");
                    entity.func_74782_a("Pos", entityData.func_74781_a("pos"));
                    newEntities.func_74742_a((NBTBase)entity);
                }
            }
            bluePrintCompound.func_74782_a("entities", (NBTBase)newEntities);
            output.createNewFile();
            CompressedStreamTools.func_74799_a((NBTTagCompound)bluePrintCompound, (OutputStream)Files.newOutputStream(output.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void updatePos(BlockPos.MutableBlockPos pos, NBTTagCompound comp) {
        NBTTagList list = comp.func_150295_c("pos", 3);
        pos.func_181079_c(list.func_186858_c(0), list.func_186858_c(1), list.func_186858_c(2));
    }

    private static int[] convertBlocksToSaveData(short[][][] multDimArray, short sizeX, short sizeY, short sizeZ) {
        int currentInt;
        short[] oneDimArray = new short[sizeX * sizeY * sizeZ];
        int j = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    oneDimArray[j++] = multDimArray[y][z][x];
                }
            }
        }
        int[] ints = new int[(int)Math.ceil((float)oneDimArray.length / 2.0f)];
        for (int i = 1; i < oneDimArray.length; i += 2) {
            currentInt = oneDimArray[i - 1];
            ints[(int)Math.ceil((double)((double)((float)i / 2.0f))) - 1] = currentInt = currentInt << 16 | oneDimArray[i];
        }
        if (oneDimArray.length % 2 == 1) {
            ints[ints.length - 1] = currentInt = oneDimArray[oneDimArray.length - 1] << 16;
        }
        return ints;
    }

    public boolean func_184882_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender) {
        return true;
    }

    @NotNull
    public List<String> func_184883_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, BlockPos targetPos) {
        return Collections.emptyList();
    }

    public boolean func_82358_a(@NotNull String[] args, int index) {
        return false;
    }
}

