/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.DropDownList;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.LanguageHandler;
import com.ldtteam.structurize.api.util.Shape;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowReplaceBlock;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.GenerateAndPasteMessage;
import com.ldtteam.structurize.network.messages.UndoMessage;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowShapeTool
extends AbstractWindowSkeleton {
    private static final int POSSIBLE_ROTATIONS = 4;
    @NotNull
    private final List<String> sections = new ArrayList<String>();
    private DropDownList sectionsDropDownList;
    private TextField inputWidth;
    private TextField inputLength;
    private TextField inputHeight;
    private TextField inputFrequency;
    private int shapeWidth = 1;
    private int shapeLength = 1;
    private int shapeHeight = 1;
    private int shapeFrequency = 1;
    private int rotation = 0;
    @NotNull
    private BlockPos pos = new BlockPos(0, 0, 0);

    public WindowShapeTool(@Nullable BlockPos pos) {
        super("structurize:gui/windowshapetool.xml");
        if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            this.init(pos, false);
        }
    }

    public WindowShapeTool(@Nullable BlockPos pos, ItemStack stack, boolean mainBlock) {
        super("structurize:gui/windowshapetool.xml");
        if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            Settings.instance.setBlock(stack, mainBlock);
            this.init(pos, true);
        }
    }

    private void init(BlockPos pos, boolean shouldUpdate) {
        Structure structure = Settings.instance.getActiveStructure();
        if (structure != null) {
            this.rotation = Settings.instance.getRotation();
            this.shapeWidth = Settings.instance.getWidth();
            this.shapeLength = Settings.instance.getLength();
            this.shapeHeight = Settings.instance.getHeight();
            this.shapeFrequency = Settings.instance.getFrequency();
        } else if (pos != null) {
            this.pos = pos;
            Settings.instance.setPosition(pos);
            Settings.instance.setRotation(0);
        }
        this.findPaneOfTypeByID("resourceIconMain", ItemIcon.class).setItem(Settings.instance.getBlock(true));
        this.findPaneOfTypeByID("resourceIconFill", ItemIcon.class).setItem(Settings.instance.getBlock(false));
        this.registerButton("confirm", this::paste);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("mirror", WindowShapeTool::mirror);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
        this.registerButton("plus", WindowShapeTool::moveUpClicked);
        this.registerButton("minus", WindowShapeTool::moveDownClicked);
        this.registerButton("rotateRight", this::rotateRightClicked);
        this.registerButton("rotateLeft", this::rotateLeftClicked);
        this.registerButton("pickMainBlock", this::pickMainBlock);
        this.registerButton("pickFillBlock", this::pickFillBlock);
        this.registerButton("replaceBlocks", this::replaceBlocksToggle);
        this.registerButton("hollowShape", this::hollowShapeToggle);
        this.registerButton("undo", this::undoClicked);
        this.inputWidth = this.findPaneOfTypeByID("width", TextField.class);
        this.inputLength = this.findPaneOfTypeByID("length", TextField.class);
        this.inputHeight = this.findPaneOfTypeByID("height", TextField.class);
        this.inputFrequency = this.findPaneOfTypeByID("frequency", TextField.class);
        this.inputWidth.setText(Integer.toString(Settings.instance.getWidth()));
        this.inputLength.setText(Integer.toString(Settings.instance.getLength()));
        this.inputHeight.setText(Integer.toString(Settings.instance.getHeight()));
        this.inputFrequency.setText(Integer.toString(Settings.instance.getFrequency()));
        this.sections.clear();
        this.sections.addAll(Arrays.stream(Shape.values()).map(Enum::name).collect(Collectors.toList()));
        this.sectionsDropDownList = this.findPaneOfTypeByID("style", DropDownList.class);
        this.sectionsDropDownList.setHandler(this::onDropDownListChanged);
        this.sectionsDropDownList.setDataProvider(new SectionDropDownList());
        this.sectionsDropDownList.setSelectedIndex(Settings.instance.getShape().ordinal());
        this.disableInputIfNecessary();
        if (structure == null || shouldUpdate) {
            this.genShape();
        }
        this.findPaneOfTypeByID("hollowShape", Button.class).setLabel(Settings.instance.isHollow() ? LanguageHandler.format("com.ldtteam.structurize.gui.shapeTool.hollow", new Object[0]) : LanguageHandler.format("com.ldtteam.structurize.gui.shapeTool.solid", new Object[0]));
    }

    private void genShape() {
        Structure structure = new Structure((World)Minecraft.func_71410_x().field_71441_e);
        structure.setBluePrint(Manager.getStructureFromFormula(Settings.instance.getWidth(), Settings.instance.getLength(), Settings.instance.getHeight(), Settings.instance.getFrequency(), Settings.instance.getShape(), Settings.instance.getBlock(true), Settings.instance.getBlock(false), Settings.instance.isHollow()));
        structure.setPlacementSettings(new PlacementSettings(Mirror.NONE, Rotation.NONE));
        Settings.instance.setActiveSchematic(structure);
    }

    private void disableInputIfNecessary() {
        Shape shape = Settings.instance.getShape();
        Label heightLabel = this.findPaneOfTypeByID("heightLabel", Label.class);
        Label widthLabel = this.findPaneOfTypeByID("widthLabel", Label.class);
        Label lengthLabel = this.findPaneOfTypeByID("lengthLabel", Label.class);
        Label frequencyLabel = this.findPaneOfTypeByID("frequencyLabel", Label.class);
        this.inputHeight.show();
        this.inputWidth.show();
        this.inputLength.show();
        this.inputFrequency.show();
        heightLabel.show();
        widthLabel.show();
        lengthLabel.show();
        frequencyLabel.show();
        if (shape == Shape.SPHERE || shape == Shape.HALF_SPHERE || shape == Shape.BOWL || shape == Shape.PYRAMID || shape == Shape.UPSIDE_DOWN_PYRAMID || shape == Shape.DIAMOND) {
            this.inputWidth.hide();
            this.inputLength.hide();
            this.inputFrequency.hide();
            widthLabel.hide();
            lengthLabel.hide();
            frequencyLabel.hide();
        } else if (shape == Shape.CYLINDER) {
            this.inputLength.hide();
            lengthLabel.hide();
            this.inputFrequency.hide();
            frequencyLabel.hide();
        } else if (shape != Shape.WAVE && shape != Shape.WAVE_3D) {
            this.inputFrequency.hide();
            frequencyLabel.hide();
        }
    }

    private void pickMainBlock() {
        new WindowReplaceBlock(Settings.instance.getBlock(true), Settings.instance.getPosition(), true, (Window)this).open();
    }

    private void pickFillBlock() {
        new WindowReplaceBlock(Settings.instance.getBlock(false), Settings.instance.getPosition(), false, (Window)this).open();
    }

    private void replaceBlocksToggle() {
        Button replaceButton = this.findPaneOfTypeByID("replaceBlocks", Button.class);
        if (replaceButton.getLabel().equalsIgnoreCase(LanguageHandler.format("com.ldtteam.structurize.gui.shapeTool.replace", new Object[0]))) {
            replaceButton.setLabel(LanguageHandler.format("com.ldtteam.structurize.gui.shapeTool.ignore", new Object[0]));
        } else if (replaceButton.getLabel().equalsIgnoreCase(LanguageHandler.format("com.ldtteam.structurize.gui.shapeTool.ignore", new Object[0]))) {
            replaceButton.setLabel(LanguageHandler.format("com.ldtteam.structurize.gui.shapeTool.replace", new Object[0]));
        }
    }

    private void hollowShapeToggle() {
        Button replaceButton = this.findPaneOfTypeByID("hollowShape", Button.class);
        if (replaceButton.getLabel().equalsIgnoreCase(LanguageHandler.format("com.ldtteam.structurize.gui.shapeTool.hollow", new Object[0]))) {
            replaceButton.setLabel(LanguageHandler.format("com.ldtteam.structurize.gui.shapeTool.solid", new Object[0]));
            Settings.instance.setHollow(false);
        } else if (replaceButton.getLabel().equalsIgnoreCase(LanguageHandler.format("com.ldtteam.structurize.gui.shapeTool.solid", new Object[0]))) {
            replaceButton.setLabel(LanguageHandler.format("com.ldtteam.structurize.gui.shapeTool.hollow", new Object[0]));
            Settings.instance.setHollow(true);
        }
        this.genShape();
    }

    private void undoClicked() {
        Structurize.getNetwork().sendToServer((IMessage)new UndoMessage());
    }

    private void paste() {
        Structurize.getNetwork().sendToServer((IMessage)new GenerateAndPasteMessage(Settings.instance.getPosition(), Settings.instance.getLength(), Settings.instance.getWidth(), Settings.instance.getHeight(), Settings.instance.getFrequency(), Settings.instance.getShape(), Settings.instance.getBlock(true), Settings.instance.getBlock(false), Settings.instance.isHollow(), BlockUtils.getRotation(Settings.instance.getRotation()), Settings.instance.getMirror()));
    }

    private static void mirror() {
        Settings.instance.mirror();
    }

    @Override
    public void onOpened() {
        if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            this.close();
        }
        WindowShapeTool.updateRotation(this.rotation);
        this.findPaneOfTypeByID("undo", Button.class).setVisible(true);
    }

    private void onDropDownListChanged(DropDownList list) {
        if (list.isEnabled() && list == this.sectionsDropDownList) {
            this.updateStyle(this.sections.get(this.sectionsDropDownList.getSelectedIndex()));
        }
    }

    private void updateStyle(String s) {
        if (Shape.valueOf(this.sections.get(this.sectionsDropDownList.getSelectedIndex())) != Settings.instance.getShape()) {
            Settings.instance.setShape(s);
            this.genShape();
        }
        this.disableInputIfNecessary();
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        String widthText = this.inputWidth.getText();
        String lengthText = this.inputLength.getText();
        String heightText = this.inputHeight.getText();
        String frequencyText = this.inputFrequency.getText();
        if (!(widthText.isEmpty() || lengthText.isEmpty() || heightText.isEmpty())) {
            try {
                int localWidth = Integer.parseInt(widthText);
                int localHeight = Integer.parseInt(heightText);
                int localLength = Integer.parseInt(lengthText);
                int localFrequency = Integer.parseInt(frequencyText);
                if (this.shapeHeight != localHeight || this.shapeLength != localLength || this.shapeWidth != localWidth || this.shapeFrequency != localFrequency) {
                    this.shapeWidth = localWidth;
                    this.shapeLength = localLength;
                    this.shapeHeight = localHeight;
                    this.shapeFrequency = localFrequency;
                    Settings.instance.setWidth(localWidth);
                    Settings.instance.setLength(localLength);
                    Settings.instance.setHeight(localHeight);
                    Settings.instance.setFrequency(localFrequency);
                    this.genShape();
                }
            }
            catch (NumberFormatException e) {
                this.inputWidth.setText(Integer.toString(Settings.instance.getWidth()));
                this.inputLength.setText(Integer.toString(Settings.instance.getLength()));
                this.inputHeight.setText(Integer.toString(Settings.instance.getHeight()));
            }
        }
        return result;
    }

    private static void moveUpClicked() {
        Settings.instance.moveTo(new BlockPos(0, 1, 0));
    }

    private static void moveDownClicked() {
        Settings.instance.moveTo(new BlockPos(0, -1, 0));
    }

    private void moveLeftClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176735_f()));
    }

    private void moveRightClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176746_e()));
    }

    private void moveForwardClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO()));
    }

    private void moveBackClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176734_d()));
    }

    private void rotateRightClicked() {
        this.rotation = (this.rotation + 1) % 4;
        WindowShapeTool.updateRotation(this.rotation);
    }

    private void rotateLeftClicked() {
        this.rotation = (this.rotation + 3) % 4;
        WindowShapeTool.updateRotation(this.rotation);
    }

    private void cancelClicked() {
        Settings.instance.reset();
        this.close();
    }

    private static void updateRotation(int rotation) {
        PlacementSettings settings = new PlacementSettings();
        switch (rotation) {
            case 1: {
                settings.setRotation(Rotation.CLOCKWISE_90);
                break;
            }
            case 2: {
                settings.setRotation(Rotation.CLOCKWISE_180);
                break;
            }
            case 3: {
                settings.setRotation(Rotation.COUNTERCLOCKWISE_90);
                break;
            }
            default: {
                settings.setRotation(Rotation.NONE);
            }
        }
        Settings.instance.setRotation(rotation);
        settings.setMirror(Settings.instance.getMirror());
        if (Settings.instance.getActiveStructure() != null) {
            Settings.instance.getActiveStructure().setPlacementSettings(settings);
        }
    }

    private class SectionDropDownList
    implements DropDownList.DataProvider {
        private SectionDropDownList() {
        }

        @Override
        public int getElementCount() {
            return WindowShapeTool.this.sections.size();
        }

        @Override
        public String getLabel(int index) {
            return (String)WindowShapeTool.this.sections.get(index);
        }
    }
}

