/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.client;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.BlueprintBlockAccess;
import com.ldtteam.structures.client.BlueprintBlockInfoTransformHandler;
import com.ldtteam.structures.client.BlueprintTessellator;
import com.ldtteam.structures.lib.BlueprintUtils;
import com.ldtteam.structures.lib.RenderUtil;
import com.ldtteam.structurize.util.BlockInfo;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlueprintRenderer {
    private static final float HALF_PERCENT_SHRINK = 0.995f;
    private final BlueprintBlockAccess blockAccess;
    private final List<TileEntity> tileEntities;
    private final List<Entity> entities;
    private final BlueprintTessellator tessellator;
    private final BlockPos primaryBlockOffset;

    public static BlueprintRenderer buildRendererForBlueprint(Blueprint blueprint) {
        BlueprintBlockAccess blockAccess = new BlueprintBlockAccess(blueprint);
        List<TileEntity> tileEntities = BlueprintUtils.instantiateTileEntities(blueprint, blockAccess);
        List<Entity> entities = BlueprintUtils.instantiateEntities(blueprint, blockAccess);
        BlueprintTessellator blueprintTessellator = new BlueprintTessellator();
        BlockPos primaryBlockOffset = BlueprintUtils.getPrimaryBlockOffset(blueprint);
        return new BlueprintRenderer(blockAccess, tileEntities, entities, blueprintTessellator, primaryBlockOffset);
    }

    private BlueprintRenderer(BlueprintBlockAccess blockAccess, List<TileEntity> tileEntities, List<Entity> entities, BlueprintTessellator tessellator, BlockPos primaryBlockOffset) {
        this.blockAccess = blockAccess;
        this.tileEntities = tileEntities;
        this.entities = entities;
        this.tessellator = tessellator;
        this.primaryBlockOffset = primaryBlockOffset;
        this.setup();
    }

    private void setup() {
        this.tessellator.startBuilding();
        this.blockAccess.getBlueprint().getBlockInfoAsList().stream().map(b -> BlueprintBlockInfoTransformHandler.getInstance().Transform((BlockInfo)b)).forEach(b -> Minecraft.func_71410_x().func_175602_ab().func_175018_a(b.getState(), b.getPos(), (IBlockAccess)this.blockAccess, this.tessellator.getBuilder()));
        this.tessellator.finishBuilding();
    }

    public void draw(Rotation rotation, Mirror mirror, Vector3d drawingOffset) {
        BlueprintRenderer.preBlueprintDraw(rotation, mirror, drawingOffset, this.primaryBlockOffset);
        this.tessellator.draw();
        RenderHelper.func_74519_b();
        this.tileEntities.forEach(tileEntity -> {
            GlStateManager.func_179094_E();
            int combinedLight = tileEntity.func_145831_w().func_175626_b(tileEntity.func_174877_v(), 0);
            int lightMapX = combinedLight % 65536;
            int lightMapY = combinedLight / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapX, (float)lightMapY);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TileEntityRendererDispatcher.field_147556_a.func_192855_a(tileEntity, (double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p(), 0.0f, 1.0f);
            GlStateManager.func_179121_F();
        });
        RenderHelper.func_74518_a();
        this.entities.forEach(entity -> {
            GlStateManager.func_179094_E();
            int brightnessForRender = entity.func_70070_b();
            if (entity.func_70027_ad()) {
                brightnessForRender = 0xF000F0;
            }
            int lightMapX = brightnessForRender % 65536;
            int lightMapY = brightnessForRender / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapX, (float)lightMapY);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f, true);
            GlStateManager.func_179121_F();
        });
        BlueprintRenderer.postBlueprintDraw();
    }

    private static void preBlueprintDraw(Rotation rotation, Mirror mirror, Vector3d drawingOffset, BlockPos inBlueprintOffset) {
        TextureMap textureObject = Minecraft.func_71410_x().func_147117_R();
        GlStateManager.func_179144_i((int)textureObject.func_110552_b());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)drawingOffset.field_181059_a, (double)drawingOffset.field_181060_b, (double)drawingOffset.field_181061_c);
        BlockPos rotateInBlueprintOffset = inBlueprintOffset.func_190942_a(rotation);
        GlStateManager.func_179109_b((float)(-rotateInBlueprintOffset.func_177958_n()), (float)(-rotateInBlueprintOffset.func_177956_o()), (float)(-rotateInBlueprintOffset.func_177952_p()));
        RenderUtil.applyRotationToYAxis(rotation);
        RenderUtil.applyMirror(mirror, inBlueprintOffset);
        GlStateManager.func_179152_a((float)0.995f, (float)0.995f, (float)0.995f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179117_G();
        GlStateManager.func_179094_E();
    }

    private static void postBlueprintDraw() {
        GlStateManager.func_179121_F();
        GlStateManager.func_179117_G();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public BlueprintBlockAccess getBlockAccess() {
        return this.blockAccess;
    }

    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    public BlueprintTessellator getTessellator() {
        return this.tessellator;
    }

    public BlockPos getPrimaryBlockOffset() {
        return this.primaryBlockOffset;
    }
}

