/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BlueprintEntityInfoTransformHandler {
    private static BlueprintEntityInfoTransformHandler ourInstance = new BlueprintEntityInfoTransformHandler();
    private Map<Predicate<Tuple<BlockPos, NBTTagCompound>>, Function<Tuple<BlockPos, NBTTagCompound>, Tuple<BlockPos, NBTTagCompound>>> entityInfoTransformHandler = new HashMap<Predicate<Tuple<BlockPos, NBTTagCompound>>, Function<Tuple<BlockPos, NBTTagCompound>, Tuple<BlockPos, NBTTagCompound>>>();

    public static BlueprintEntityInfoTransformHandler getInstance() {
        return ourInstance;
    }

    private BlueprintEntityInfoTransformHandler() {
    }

    public void AddTransformHandler(@NotNull Predicate<Tuple<BlockPos, NBTTagCompound>> transformPredicate, @NotNull Function<Tuple<BlockPos, NBTTagCompound>, Tuple<BlockPos, NBTTagCompound>> transformHandler) {
        this.entityInfoTransformHandler.put(transformPredicate, transformHandler);
    }

    public Tuple<BlockPos, NBTTagCompound> Transform(@NotNull Tuple<BlockPos, NBTTagCompound> entityInfo) {
        return this.getTransformHandler(entityInfo).apply(entityInfo);
    }

    private Function<Tuple<BlockPos, NBTTagCompound>, Tuple<BlockPos, NBTTagCompound>> getTransformHandler(@NotNull Tuple<BlockPos, NBTTagCompound> entityInfo) {
        return this.entityInfoTransformHandler.keySet().stream().filter(p -> p.test(entityInfo)).findFirst().map(p -> this.entityInfoTransformHandler.get(p)).orElse(Function.identity());
    }
}

