/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.amulet.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.ConfigDataAdapter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class WeightedAmuletEnchantment
extends WeightedRandom.Item
implements ConfigDataAdapter.DataSet {
    private final Enchantment enchantment;

    public WeightedAmuletEnchantment(Enchantment ench, int weight) {
        super(weight);
        this.enchantment = ench;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    @Override
    @Nonnull
    public String serialize() {
        return this.enchantment.getRegistryName().toString() + ":" + this.field_76292_a;
    }

    @Nullable
    public static WeightedAmuletEnchantment deserialize(String str) {
        int w;
        String[] spl = str.split(":");
        if (spl.length < 3) {
            return null;
        }
        String domain = spl[0];
        String weight = spl[spl.length - 1];
        StringBuilder path = new StringBuilder();
        for (int i = 1; i < spl.length - 1; ++i) {
            if (path.length() > 0) {
                path.append(":");
            }
            path.append(spl[i]);
        }
        Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(domain, path.toString()));
        if (ench == null) {
            AstralSorcery.log.info("Ignoring whitelist entry " + str + " for amulet enchantments - Enchantment does not exist!");
            return null;
        }
        try {
            w = Integer.parseInt(weight);
        }
        catch (NumberFormatException exc) {
            AstralSorcery.log.info("Ignoring whitelist entry " + str + " for amulet enchantments - last :-separated argument is not a number!");
            return null;
        }
        return new WeightedAmuletEnchantment(ench, w);
    }
}

