/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.IFormula;
import mcjty.rftools.shapes.PacketReturnShapeData;
import mcjty.rftools.shapes.ShapeID;
import mcjty.rftools.shapes.StatePalette;
import mcjty.rftools.varia.RLE;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ShapeDataManagerServer {
    private static final Map<ShapeID, WorkQueue> workQueues = new HashMap<ShapeID, WorkQueue>();

    public static void pushWork(ShapeID shapeID, ItemStack stack, int offsetY, IFormula formula, EntityPlayerMP player) {
        WorkQueue queue = workQueues.get(shapeID);
        if (queue == null) {
            queue = new WorkQueue();
            workQueues.put(shapeID, queue);
        }
        if (queue.workingOn.containsKey(offsetY)) {
            ((WorkUnit)queue.workingOn.get(offsetY)).update(stack, offsetY, formula, player);
        } else {
            WorkUnit unit = new WorkUnit(stack, offsetY, formula, player);
            queue.workQueue.addLast(unit);
            queue.workingOn.put(offsetY, unit);
        }
    }

    public static void handleWork() {
        HashSet<ShapeID> toRemove = new HashSet<ShapeID>();
        for (Map.Entry<ShapeID, WorkQueue> entry : workQueues.entrySet()) {
            ShapeID shapeID = entry.getKey();
            WorkQueue queue = entry.getValue();
            int pertick = ScannerConfiguration.planeSurfacePerTick;
            while (!queue.workQueue.isEmpty()) {
                WorkUnit unit = (WorkUnit)queue.workQueue.removeFirst();
                queue.workingOn.remove(unit.getOffsetY());
                ItemStack card = unit.getStack();
                boolean solid = ShapeCardItem.isSolid(card);
                BlockPos dimension = ShapeCardItem.getDimension(card);
                RLE positions = new RLE();
                StatePalette statePalette = new StatePalette();
                int cnt = ShapeCardItem.getRenderPositions(card, solid, positions, statePalette, unit.getFormula(), unit.getOffsetY());
                for (EntityPlayerMP player : unit.getPlayers()) {
                    RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketReturnShapeData(shapeID, positions, statePalette, dimension, cnt, unit.getOffsetY(), ""), player);
                }
                if (cnt <= 0 || (pertick -= dimension.func_177958_n() * dimension.func_177952_p()) > 0) continue;
                break;
            }
            if (!queue.workQueue.isEmpty()) continue;
            toRemove.add(shapeID);
        }
        for (ShapeID id : toRemove) {
            workQueues.remove(id);
        }
    }

    private static class WorkQueue {
        private final ArrayDeque<WorkUnit> workQueue = new ArrayDeque();
        private final Map<Integer, WorkUnit> workingOn = new HashMap<Integer, WorkUnit>();

        private WorkQueue() {
        }
    }

    private static class WorkUnit {
        private final List<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();
        private ItemStack stack;
        private int offsetY;
        private IFormula formula;

        public WorkUnit(ItemStack stack, int offsetY, IFormula formula, EntityPlayerMP player) {
            this.stack = stack;
            this.offsetY = offsetY;
            this.formula = formula;
            this.players.add(player);
        }

        public void update(ItemStack stack, int offsetY, IFormula formula, EntityPlayerMP player) {
            this.stack = stack;
            this.offsetY = offsetY;
            this.formula = formula;
            if (!this.players.contains(player)) {
                this.players.add(player);
            }
        }

        public List<EntityPlayerMP> getPlayers() {
            return this.players;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public IFormula getFormula() {
            return this.formula;
        }
    }
}

