/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.utility;

import ca.wescook.nutrition.effects.Effect;
import ca.wescook.nutrition.effects.JsonEffect;
import ca.wescook.nutrition.nutrients.JsonNutrient;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.nutrients.NutrientUtils;
import ca.wescook.nutrition.utility.Config;
import ca.wescook.nutrition.utility.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DataParser {
    public static List<Nutrient> parseNutrients(List<JsonNutrient> jsonNutrients) {
        ArrayList<Nutrient> nutrients = new ArrayList<Nutrient>();
        for (JsonNutrient nutrientRaw : jsonNutrients) {
            if (nutrientRaw.enabled != null && !nutrientRaw.enabled.booleanValue()) continue;
            Nutrient nutrient = new Nutrient();
            try {
                nutrient.name = nutrientRaw.name;
                nutrient.icon = new ItemStack(Item.func_111206_d((String)nutrientRaw.icon));
                nutrient.color = Integer.parseUnsignedInt("ff" + nutrientRaw.color, 16);
            }
            catch (NullPointerException e) {
                Log.fatal("Missing or invalid JSON.  A name, icon, and color are required.");
                throw e;
            }
            if (nutrientRaw.decay == null) {
                nutrient.decay = Config.decayMultiplier;
            } else if (nutrientRaw.decay.floatValue() >= -100.0f && nutrientRaw.decay.floatValue() <= 100.0f) {
                nutrient.decay = nutrientRaw.decay.floatValue();
            } else {
                nutrient.decay = 0.0f;
                Log.error("Decay rate must be between -100 and 100 (" + nutrient.name + ").");
                continue;
            }
            boolean bl = nutrient.visible = nutrientRaw.visible == null || nutrientRaw.visible != false;
            if (nutrientRaw.food.oredict != null) {
                nutrient.foodOreDict = nutrientRaw.food.oredict;
            }
            if (nutrientRaw.food.items != null) {
                Iterator<String> iterator = nutrientRaw.food.items.iterator();
                while (iterator.hasNext()) {
                    Item item;
                    String fullName;
                    String name = fullName = iterator.next();
                    int metadata = 0;
                    if (name == null) {
                        Log.fatal("There is a null item in the '" + nutrient.name + "' JSON.  Check for a trailing comma in the file.");
                        throw new NullPointerException("There is a null item in the '" + nutrient.name + "' JSON.  Check for a trailing comma in the file.");
                    }
                    if (StringUtils.countMatches((CharSequence)fullName, (CharSequence)":") == 2) {
                        name = StringUtils.substringBeforeLast((String)fullName, (String)":");
                        String metaString = StringUtils.substringAfterLast((String)fullName, (String)":");
                        if (NumberUtils.isCreatable((String)metaString)) {
                            metadata = Integer.decode(metaString);
                        } else {
                            Log.warn(fullName + " does not contain valid metadata");
                            continue;
                        }
                    }
                    if ((item = Item.func_111206_d((String)name)) == null) {
                        String modid = fullName.substring(0, fullName.indexOf(":"));
                        if (!Config.logMissingFood || !Loader.isModLoaded((String)modid)) continue;
                        Log.warn("Food with nutrients doesn't exist: " + fullName + " (" + nutrient.name + ")");
                        continue;
                    }
                    ItemStack itemStack = new ItemStack(item, 1, metadata);
                    if (NutrientUtils.isValidFood(itemStack)) {
                        nutrient.foodItems.add(itemStack);
                        continue;
                    }
                    Log.warn(name + " is not a valid food (" + fullName + ")");
                }
            }
            nutrients.add(nutrient);
        }
        return nutrients;
    }

    public static List<Effect> parseEffects(List<JsonEffect> jsonEffects) {
        ArrayList<Effect> effects = new ArrayList<Effect>();
        for (JsonEffect effectRaw : jsonEffects) {
            if (effectRaw.enabled != null && !effectRaw.enabled.booleanValue()) continue;
            Potion potion = Potion.func_180142_b((String)effectRaw.potion);
            if (potion == null) {
                Log.error("Potion '" + effectRaw.potion + "' is not valid (" + effectRaw.name + ").");
                continue;
            }
            Effect effect = new Effect();
            effect.name = effectRaw.name;
            effect.potion = potion;
            effect.minimum = effectRaw.minimum;
            effect.maximum = effectRaw.maximum;
            effect.detect = effectRaw.detect;
            effect.amplifier = effectRaw.amplifier != null ? effectRaw.amplifier : 0;
            int n = effect.cumulativeModifier = effectRaw.cumulative_modifier != null ? effectRaw.cumulative_modifier : 1;
            if (effectRaw.nutrients.size() == 0) {
                effect.nutrients.addAll(NutrientList.get());
            } else {
                for (String nutrientName : effectRaw.nutrients) {
                    Nutrient nutrient = NutrientList.getByName(nutrientName);
                    if (nutrient != null) {
                        effect.nutrients.add(nutrient);
                        continue;
                    }
                    Log.error("Nutrient " + nutrientName + " not found (" + effectRaw.name + ").");
                }
            }
            effects.add(effect);
        }
        return effects;
    }
}

