/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.events;

import ca.wescook.nutrition.capabilities.INutrientManager;
import ca.wescook.nutrition.effects.EffectsManager;
import ca.wescook.nutrition.gui.ModGuiHandler;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.proxy.ClientProxy;
import ca.wescook.nutrition.utility.Config;
import com.google.common.primitives.Floats;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class EventPlayerUpdate {
    @CapabilityInject(value=INutrientManager.class)
    private static final Capability<INutrientManager> NUTRITION_CAPABILITY = null;
    private Map<Pair<EntityPlayer, Boolean>, Integer> playerFoodLevels = new HashMap<Pair<EntityPlayer, Boolean>, Integer>();
    private int potionCounter = 0;

    @SubscribeEvent
    public void PlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        if (Config.enableDecay) {
            this.nutritionDecay(player);
        }
        if (!event.player.func_130014_f_().field_72995_K) {
            this.potionTicking(player);
        }
    }

    private void nutritionDecay(EntityPlayer player) {
        ImmutablePair playerSidedID = new ImmutablePair((Object)player, (Object)player.func_130014_f_().field_72995_K);
        int foodLevelNew = player.func_71024_bL().func_75116_a();
        Integer foodLevelOld = this.playerFoodLevels.get(playerSidedID);
        if (foodLevelOld != null && foodLevelNew < foodLevelOld) {
            int difference = foodLevelOld - foodLevelNew;
            if (!player.func_130014_f_().field_72995_K) {
                Map<Nutrient, Float> playerNutrition = ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).get();
                playerNutrition = this.calculateDecay(playerNutrition, difference);
                ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).set(playerNutrition);
            } else {
                Map<Nutrient, Float> playerNutrition = ClientProxy.localNutrition.get();
                playerNutrition = this.calculateDecay(playerNutrition, difference);
                ClientProxy.localNutrition.set(playerNutrition);
                GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
                if (currentScreen != null && currentScreen.equals((Object)ModGuiHandler.nutritionGui)) {
                    ModGuiHandler.nutritionGui.redrawLabels();
                }
            }
        }
        this.playerFoodLevels.put((Pair<EntityPlayer, Boolean>)playerSidedID, foodLevelNew);
    }

    private Map<Nutrient, Float> calculateDecay(Map<Nutrient, Float> playerNutrition, int difference) {
        for (Map.Entry<Nutrient, Float> entry : playerNutrition.entrySet()) {
            float decay = (float)((double)difference * 0.075 * (double)entry.getKey().decay);
            entry.setValue(Float.valueOf(Floats.constrainToRange((float)(entry.getValue().floatValue() - decay), (float)0.0f, (float)100.0f)));
        }
        return playerNutrition;
    }

    private void potionTicking(EntityPlayer player) {
        if (this.potionCounter > 110) {
            EffectsManager.reapplyEffects(player);
            this.potionCounter = 0;
        }
        ++this.potionCounter;
    }
}

