/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.factory;

import com.rwtema.funkylocomotion.api.IMoveFactory;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class DefaultMoveFactory
implements IMoveFactory {
    public static NBTTagCompound getBBTag(AxisAlignedBB bb, BlockPos pos) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("x1", bb.field_72340_a - (double)pos.func_177958_n());
        tag.func_74780_a("y1", bb.field_72338_b - (double)pos.func_177956_o());
        tag.func_74780_a("z1", bb.field_72339_c - (double)pos.func_177952_p());
        tag.func_74780_a("x2", bb.field_72336_d - (double)pos.func_177958_n());
        tag.func_74780_a("y2", bb.field_72337_e - (double)pos.func_177956_o());
        tag.func_74780_a("z2", bb.field_72334_f - (double)pos.func_177952_p());
        return tag;
    }

    @Override
    public NBTTagCompound destroyBlock(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        IBlockState state = chunk.func_177435_g(pos);
        Block b = state.func_177230_c();
        int meta = b.func_176201_c(state);
        NBTTagCompound tag = new NBTTagCompound();
        if (b == Blocks.field_150350_a) {
            return tag;
        }
        String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)b)).toString();
        tag.func_74778_a("Block", name);
        if (meta != 0) {
            tag.func_74774_a("Meta", (byte)meta);
        }
        this.saveTile(pos, chunk, tag);
        BlockHelper.silentClear(chunk, pos);
        return tag;
    }

    protected NBTTagCompound saveTile(BlockPos pos, Chunk chunk, NBTTagCompound tag) {
        TileEntity tile = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        if (tile != null) {
            NBTTagCompound tileTag = new NBTTagCompound();
            tile.func_189515_b(tileTag);
            tag.func_74782_a("Tile", (NBTBase)tileTag);
            chunk.func_177425_e(pos);
            return tileTag;
        }
        return null;
    }

    @Override
    public boolean recreateBlock(World world, BlockPos pos, NBTTagCompound tag) {
        Block block = Block.func_149684_b((String)tag.func_74779_i("Block"));
        if (block == null) {
            block = Blocks.field_150350_a;
        }
        byte meta = tag.func_74771_c("Meta");
        Chunk chunk = world.func_175726_f(pos);
        BlockHelper.silentSetBlock(chunk, pos, block, meta);
        this.loadTile(pos, tag, chunk);
        return true;
    }

    protected TileEntity loadTile(BlockPos pos, NBTTagCompound tag, Chunk chunk) {
        if (tag.func_150297_b("Tile", 10)) {
            NBTTagCompound tileTag = tag.func_74775_l("Tile");
            tileTag.func_74768_a("x", pos.func_177958_n());
            tileTag.func_74768_a("y", pos.func_177956_o());
            tileTag.func_74768_a("z", pos.func_177952_p());
            TileEntity tile = TileEntity.func_190200_a((World)chunk.func_177412_p(), (NBTTagCompound)tileTag);
            if (tile != null) {
                chunk.func_150813_a(tile);
                return tile;
            }
        }
        return null;
    }
}

