/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.item.ItemMod;
import vazkii.arl.network.NetworkHandler;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.CADStatEvent;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADAssembly;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.ISpellContainer;
import vazkii.psi.api.spell.ISpellSettable;
import vazkii.psi.api.spell.PreSpellCastEvent;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCastEvent;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.client.core.helper.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.BlockProgrammer;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.core.PsiCreativeTab;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.core.handler.capability.CADData;
import vazkii.psi.common.core.handler.capability.CapabilityCAD;
import vazkii.psi.common.core.handler.capability.ICADData;
import vazkii.psi.common.crafting.recipe.AssemblyScavengeRecipe;
import vazkii.psi.common.item.base.IPsiItem;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.network.message.MessageCADDataSync;
import vazkii.psi.common.network.message.MessageVisualEffect;

public class ItemCAD
extends ItemMod
implements ICAD,
ISpellSettable,
IItemColorProvider,
IPsiItem {
    private static final String TAG_COMPONENT_PREFIX = "component";
    private static final String TAG_BULLET_PREFIX = "bullet";
    private static final String TAG_SELECTED_SLOT = "selectedSlot";
    private static final String TAG_TIME_LEGACY = "time";
    private static final String TAG_STORED_PSI_LEGACY = "storedPsi";
    private static final String TAG_X_LEGACY = "x";
    private static final String TAG_Y_LEGACY = "y";
    private static final String TAG_Z_LEGACY = "z";
    private static final Pattern VECTOR_PREFIX_PATTERN = Pattern.compile("^storedVector(\\d+)$");
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*])|(?:ComputerCraft)$");

    public ItemCAD() {
        super("cad", new String[0]);
        this.func_77625_d(1);
        new AssemblyScavengeRecipe();
        this.func_77637_a(PsiCreativeTab.INSTANCE);
    }

    private ICADData getCADData(ItemStack stack) {
        ICADData data;
        if (stack.hasCapability(CapabilityCAD.CAPABILITY, null) && (data = (ICADData)stack.getCapability(CapabilityCAD.CAPABILITY, null)) != null) {
            return data;
        }
        return new CADData();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new CADData();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ICADData data;
        NBTTagCompound compound = ItemNBTHelper.getNBT((ItemStack)stack);
        if (stack.hasCapability(CapabilityCAD.CAPABILITY, null) && (data = (ICADData)stack.getCapability(CapabilityCAD.CAPABILITY, null)) != null) {
            if (compound.func_150297_b(TAG_TIME_LEGACY, 99)) {
                data.setTime(compound.func_74762_e(TAG_TIME_LEGACY));
                data.markDirty(true);
                compound.func_82580_o(TAG_TIME_LEGACY);
            }
            if (compound.func_150297_b(TAG_STORED_PSI_LEGACY, 99)) {
                data.setBattery(compound.func_74762_e(TAG_STORED_PSI_LEGACY));
                data.markDirty(true);
                compound.func_82580_o(TAG_STORED_PSI_LEGACY);
            }
            for (String key : compound.func_150296_c()) {
                Matcher matcher = VECTOR_PREFIX_PATTERN.matcher(key);
                if (!matcher.find()) continue;
                NBTTagCompound vec = compound.func_74775_l(key);
                int memory = Integer.parseInt(matcher.group(1));
                Vector3 vector = new Vector3(vec.func_74769_h(TAG_X_LEGACY), vec.func_74769_h(TAG_Y_LEGACY), vec.func_74769_h(TAG_Z_LEGACY));
                data.setSavedVector(memory, vector);
            }
            if (entityIn instanceof EntityPlayerMP && data.isDirty()) {
                NetworkHandler.INSTANCE.sendTo((IMessage)new MessageCADDataSync(data), (EntityPlayerMP)entityIn);
                data.markDirty(false);
            }
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block == ModBlocks.programmer ? ((BlockProgrammer)block).setSpell(worldIn, pos, playerIn, stack) : EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(playerIn);
        ItemStack playerCad = PsiAPI.getPlayerCAD(playerIn);
        if (playerCad != itemStackIn) {
            if (!worldIn.field_72995_K) {
                playerIn.func_145747_a(new TextComponentTranslation("psimisc.multipleCads", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        ItemStack bullet = this.getBulletInSocket(itemStackIn, this.getSelectedSlot(itemStackIn));
        boolean did = ItemCAD.cast(worldIn, playerIn, data, bullet, itemStackIn, 40, 25, 0.5f, ctx -> {
            ctx.castFrom = hand;
        });
        if (!data.overflowed && bullet.func_190926_b() && ItemCAD.craft(playerIn, "dustRedstone", new ItemStack((Item)ModItems.material))) {
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, PsiSoundHandler.cadShoot, SoundCategory.PLAYERS, 0.5f, (float)(0.5 + Math.random() * 0.5));
            data.deductPsi(100, 60, true);
            if (data.level == 0) {
                data.levelUp();
            }
            did = true;
        }
        return new ActionResult(did ? EnumActionResult.SUCCESS : EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public void setSpell(EntityPlayer player, ItemStack stack, Spell spell) {
        int slot = this.getSelectedSlot(stack);
        ItemStack bullet = this.getBulletInSocket(stack, slot);
        if (!bullet.func_190926_b() && bullet.func_77973_b() instanceof ISpellSettable) {
            ((ISpellSettable)bullet.func_77973_b()).setSpell(player, bullet, spell);
            this.setBulletInSocket(stack, slot, bullet);
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 10);
        }
    }

    public static boolean cast(World world, EntityPlayer player, PlayerDataHandler.PlayerData data, ItemStack bullet, ItemStack cad, int cd, int particles, float sound, Consumer<SpellContext> predicate) {
        ISpellContainer spellContainer;
        if (!data.overflowed && data.getAvailablePsi() > 0 && !cad.func_190926_b() && !bullet.func_190926_b() && bullet.func_77973_b() instanceof ISpellContainer && ItemCAD.isTruePlayer((Entity)player) && (spellContainer = (ISpellContainer)bullet.func_77973_b()).containsSpell(bullet)) {
            Spell spell = spellContainer.getSpell(bullet);
            SpellContext context = new SpellContext().setPlayer(player).setSpell(spell);
            if (predicate != null) {
                predicate.accept(context);
            }
            if (context.isValid()) {
                if (context.cspell.metadata.evaluateAgainst(cad)) {
                    int cost = ItemCAD.getRealCost(cad, bullet, context.cspell.metadata.stats.get((Object)EnumSpellStat.COST));
                    PreSpellCastEvent event = new PreSpellCastEvent(cost, sound, particles, cd, spell, context, player, data, cad, bullet);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        String cancelMessage = event.getCancellationMessage();
                        if (cancelMessage != null && !cancelMessage.isEmpty()) {
                            player.func_145747_a(new TextComponentTranslation(cancelMessage, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        }
                        return false;
                    }
                    cd = event.getCooldown();
                    particles = event.getParticles();
                    sound = event.getSound();
                    cost = event.getCost();
                    spell = event.getSpell();
                    context = event.getContext();
                    if (cost > 0) {
                        data.deductPsi(cost, cd, true);
                    }
                    if (cost != 0 && sound > 0.0f) {
                        if (!world.field_72995_K) {
                            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PsiSoundHandler.cadShoot, SoundCategory.PLAYERS, sound, (float)(0.5 + Math.random() * 0.5));
                        } else {
                            int color = Psi.proxy.getColorForCAD(cad);
                            float r = (float)PsiRenderHelper.r(color) / 255.0f;
                            float g = (float)PsiRenderHelper.g(color) / 255.0f;
                            float b = (float)PsiRenderHelper.b(color) / 255.0f;
                            for (int i = 0; i < particles; ++i) {
                                double x = player.field_70165_t + (Math.random() - 0.5) * 2.1 * (double)player.field_70130_N;
                                double y = player.field_70163_u - player.func_70033_W();
                                double z = player.field_70161_v + (Math.random() - 0.5) * 2.1 * (double)player.field_70130_N;
                                float grav = -0.15f - (float)Math.random() * 0.03f;
                                Psi.proxy.sparkleFX(x, y, z, r, g, b, grav, 0.25f, 15);
                            }
                            double x = player.field_70165_t;
                            double y = player.field_70163_u + (double)player.func_70047_e() - 0.1;
                            double z = player.field_70161_v;
                            Vector3 lookOrig = new Vector3(player.func_70040_Z());
                            for (int i = 0; i < 25; ++i) {
                                Vector3 look = lookOrig.copy();
                                double spread = 0.25;
                                look.x += (Math.random() - 0.5) * spread;
                                look.y += (Math.random() - 0.5) * spread;
                                look.z += (Math.random() - 0.5) * spread;
                                look.normalize().multiply(0.15);
                                Psi.proxy.sparkleFX(x, y, z, r, g, b, (float)look.x, (float)look.y, (float)look.z, 0.3f, 5);
                            }
                        }
                    }
                    if (!world.field_72995_K) {
                        spellContainer.castSpell(bullet, context);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent(spell, context, player, data, cad, bullet));
                    return true;
                }
                if (!world.field_72995_K) {
                    player.func_145747_a(new TextComponentTranslation("psimisc.weakCad", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
        }
        return false;
    }

    public static boolean craft(EntityPlayer player, ItemStack in, ItemStack out) {
        return ItemCAD.craft(player, CraftingHelper.getIngredient((Object)in), out);
    }

    public static boolean craft(EntityPlayer player, String in, ItemStack out) {
        return ItemCAD.craft(player, CraftingHelper.getIngredient((Object)in), out);
    }

    public static boolean craft(EntityPlayer player, Ingredient in, ItemStack out) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        List items = player.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(player.field_70165_t - 8.0, player.field_70163_u - 8.0, player.field_70161_v - 8.0, player.field_70165_t + 8.0, player.field_70163_u + 8.0, player.field_70161_v + 8.0));
        boolean did = false;
        for (EntityItem item : items) {
            ItemStack stack = item.func_92059_d();
            if (!in.test((Object)stack)) continue;
            ItemStack outCopy = out.func_77946_l();
            outCopy.func_190920_e(stack.func_190916_E());
            item.func_92058_a(outCopy);
            did = true;
            NetworkHandler.INSTANCE.sendToAllAround((IMessage)new MessageVisualEffect(1295871, item.field_70165_t, item.field_70163_u, item.field_70161_v, item.field_70130_N, item.field_70131_O, item.func_70033_W(), 0), new NetworkRegistry.TargetPoint(item.field_70170_p.field_73011_w.getDimension(), item.field_70165_t, item.field_70163_u, item.field_70161_v, 32.0));
        }
        return did;
    }

    public static int getRealCost(ItemStack stack, ItemStack bullet, int cost) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ICAD) {
            int eff = ((ICAD)stack.func_77973_b()).getStatValue(stack, EnumCADStat.EFFICIENCY);
            if (eff == -1) {
                return -1;
            }
            if (eff == 0) {
                return cost;
            }
            double effPercentile = (double)eff / 100.0;
            double procCost = (double)cost / effPercentile;
            if (!bullet.func_190926_b()) {
                procCost *= ((ISpellContainer)bullet.func_77973_b()).getCostModifier(bullet);
            }
            return (int)procCost;
        }
        return cost;
    }

    public static boolean isTruePlayer(Entity e) {
        if (!(e instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)e;
        String name = player.func_70005_c_();
        return !(player instanceof FakePlayer) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    public static void setComponent(ItemStack stack, ItemStack componentStack) {
        if (!componentStack.func_190926_b() && componentStack.func_77973_b() instanceof ICADComponent) {
            ICADComponent component = (ICADComponent)componentStack.func_77973_b();
            EnumCADComponent componentType = component.getComponentType(componentStack);
            String name = TAG_COMPONENT_PREFIX + componentType.name();
            NBTTagCompound cmp = new NBTTagCompound();
            componentStack.func_77955_b(cmp);
            ItemNBTHelper.setCompound((ItemStack)stack, (String)name, (NBTTagCompound)cmp);
        }
    }

    public static ItemStack makeCAD(ItemStack ... components) {
        return ItemCAD.makeCAD(Arrays.asList(components));
    }

    public static ItemStack makeCAD(List<ItemStack> components) {
        ItemStack stack = new ItemStack((Item)ModItems.cad);
        for (ItemStack component : components) {
            ItemCAD.setComponent(stack, component);
        }
        return stack;
    }

    @Override
    public ItemStack getComponentInSlot(ItemStack stack, EnumCADComponent type) {
        String name = TAG_COMPONENT_PREFIX + type.name();
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)name, (boolean)true);
        if (cmp == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(cmp);
    }

    @Override
    public int getStatValue(ItemStack stack, EnumCADStat stat) {
        int statValue = 0;
        ItemStack componentStack = this.getComponentInSlot(stack, stat.getSourceType());
        if (!componentStack.func_190926_b() && componentStack.func_77973_b() instanceof ICADComponent) {
            ICADComponent component = (ICADComponent)componentStack.func_77973_b();
            statValue = component.getCADStatValue(componentStack, stat);
        }
        CADStatEvent event = new CADStatEvent(stat, stack, componentStack, statValue);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getStatValue();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getSpellColor(ItemStack stack) {
        ItemStack dye = this.getComponentInSlot(stack, EnumCADComponent.DYE);
        if (!dye.func_190926_b() && dye.func_77973_b() instanceof ICADColorizer) {
            return ((ICADColorizer)dye.func_77973_b()).getColor(dye);
        }
        return 1295871;
    }

    @Override
    public boolean isSocketSlotAvailable(ItemStack stack, int slot) {
        int sockets = this.getStatValue(stack, EnumCADStat.SOCKETS);
        if (sockets == -1 || sockets > 12) {
            sockets = 12;
        }
        return slot < sockets;
    }

    @Override
    public ItemStack getBulletInSocket(ItemStack stack, int slot) {
        String name = TAG_BULLET_PREFIX + slot;
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)name, (boolean)true);
        if (cmp == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(cmp);
    }

    @Override
    public void setBulletInSocket(ItemStack stack, int slot, ItemStack bullet) {
        String name = TAG_BULLET_PREFIX + slot;
        NBTTagCompound cmp = new NBTTagCompound();
        if (!bullet.func_190926_b()) {
            bullet.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound((ItemStack)stack, (String)name, (NBTTagCompound)cmp);
    }

    @Override
    public int getSelectedSlot(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SELECTED_SLOT, (int)0);
    }

    @Override
    public void setSelectedSlot(ItemStack stack, int slot) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_SELECTED_SLOT, (int)slot);
    }

    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return (stack, tintIndex) -> tintIndex == 1 ? this.getSpellColor(stack) : 0xFFFFFF;
    }

    @Override
    public int getTime(ItemStack stack) {
        return this.getCADData(stack).getTime();
    }

    @Override
    public void incrementTime(ItemStack stack) {
        ICADData data = this.getCADData(stack);
        data.setTime(data.getTime() + 1);
    }

    @Override
    public int getStoredPsi(ItemStack stack) {
        int maxPsi = this.getStatValue(stack, EnumCADStat.OVERFLOW);
        return Math.min(this.getCADData(stack).getBattery(), maxPsi);
    }

    @Override
    public void regenPsi(ItemStack stack, int psi) {
        int maxPsi = this.getStatValue(stack, EnumCADStat.OVERFLOW);
        int currPsi = this.getStoredPsi(stack);
        int endPsi = Math.min(currPsi + psi, maxPsi);
        if (endPsi != currPsi) {
            ICADData data = this.getCADData(stack);
            data.setBattery(endPsi);
            data.markDirty(true);
        }
    }

    @Override
    public int consumePsi(ItemStack stack, int psi) {
        if (psi == 0) {
            return 0;
        }
        int currPsi = this.getStoredPsi(stack);
        if (currPsi == -1) {
            return 0;
        }
        ICADData data = this.getCADData(stack);
        if (currPsi >= psi) {
            data.setBattery(currPsi - psi);
            data.markDirty(true);
            return 0;
        }
        data.setBattery(0);
        data.markDirty(true);
        return psi - currPsi;
    }

    @Override
    public int getMemorySize(ItemStack stack) {
        int sockets = this.getStatValue(stack, EnumCADStat.SOCKETS);
        if (sockets == -1) {
            return 255;
        }
        return sockets / 3;
    }

    @Override
    public void setStoredVector(ItemStack stack, int memorySlot, Vector3 vec) throws SpellRuntimeException {
        int size = this.getMemorySize(stack);
        if (memorySlot < 0 || memorySlot >= size) {
            throw new SpellRuntimeException("psi.spellerror.memoryoutofbounds");
        }
        this.getCADData(stack).setSavedVector(memorySlot, vec);
    }

    @Override
    public Vector3 getStoredVector(ItemStack stack, int memorySlot) throws SpellRuntimeException {
        int size = this.getMemorySize(stack);
        if (memorySlot < 0 || memorySlot >= size) {
            throw new SpellRuntimeException("psi.spellerror.memoryoutofbounds");
        }
        return this.getCADData(stack).getSavedVector(memorySlot);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 0)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 0), new ItemStack((Item)ModItems.cadCore, 1, 0), new ItemStack((Item)ModItems.cadSocket, 1, 0), new ItemStack((Item)ModItems.cadBattery, 1, 0)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 1), new ItemStack((Item)ModItems.cadCore, 1, 0), new ItemStack((Item)ModItems.cadSocket, 1, 0), new ItemStack((Item)ModItems.cadBattery, 1, 0)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 2), new ItemStack((Item)ModItems.cadCore, 1, 1), new ItemStack((Item)ModItems.cadSocket, 1, 1), new ItemStack((Item)ModItems.cadBattery, 1, 1)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 3), new ItemStack((Item)ModItems.cadCore, 1, 3), new ItemStack((Item)ModItems.cadSocket, 1, 3), new ItemStack((Item)ModItems.cadBattery, 1, 2)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 4), new ItemStack((Item)ModItems.cadCore, 1, 3), new ItemStack((Item)ModItems.cadSocket, 1, 3), new ItemStack((Item)ModItems.cadBattery, 1, 2)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 5), new ItemStack((Item)ModItems.cadCore, 1, 3), new ItemStack((Item)ModItems.cadSocket, 1, 3), new ItemStack((Item)ModItems.cadBattery, 1, 2)));
    }

    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        ItemCAD.tooltipIfShift(tooltip, () -> {
            String componentName = ItemCAD.local((String)ISocketable.getSocketedItemName(stack, "psimisc.none"));
            ItemCAD.addToTooltip((List)tooltip, (String)"psimisc.spellSelected", (Object[])new Object[]{componentName});
            for (EnumCADComponent componentType : (EnumCADComponent[])EnumCADComponent.class.getEnumConstants()) {
                ItemStack componentStack = this.getComponentInSlot(stack, componentType);
                String name = "psimisc.none";
                if (!componentStack.func_190926_b()) {
                    name = componentStack.func_82833_r();
                }
                name = ItemCAD.local((String)name);
                String line = TextFormatting.GREEN + ItemCAD.local((String)componentType.getName()) + TextFormatting.GRAY + ": " + name;
                ItemCAD.addToTooltip((List)tooltip, (String)line, (Object[])new Object[0]);
                for (EnumCADStat stat : (EnumCADStat[])EnumCADStat.class.getEnumConstants()) {
                    if (stat.getSourceType() != componentType) continue;
                    String shrt = stat.getName();
                    int statVal = this.getStatValue(stack, stat);
                    String statValStr = statVal == -1 ? "\u221e" : "" + statVal;
                    line = " " + TextFormatting.AQUA + ItemCAD.local((String)shrt) + TextFormatting.GRAY + ": " + statValStr;
                    if (line.isEmpty()) continue;
                    ItemCAD.addToTooltip((List)tooltip, (String)line, (Object[])new Object[0]);
                }
            }
        });
    }

    @Override
    public boolean requiresSneakForSpellSet(ItemStack stack) {
        return true;
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getCustomMeshDefinition() {
        return stack -> {
            ICAD cad = (ICAD)stack.func_77973_b();
            ItemStack assemblyStack = cad.getComponentInSlot(stack, EnumCADComponent.ASSEMBLY);
            if (assemblyStack.func_190926_b()) {
                return new ModelResourceLocation("missingno");
            }
            ICADAssembly assembly = (ICADAssembly)assemblyStack.func_77973_b();
            return assembly.getCADModel(assemblyStack, stack);
        };
    }
}

