/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile.container;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.inventory.InventorySocketable;
import vazkii.psi.api.spell.ISpellSettable;
import vazkii.psi.common.block.tile.TileCADAssembler;
import vazkii.psi.common.block.tile.container.slot.InventoryAssemblerOutput;
import vazkii.psi.common.block.tile.container.slot.SlotCADOutput;
import vazkii.psi.common.block.tile.container.slot.SlotSocketable;
import vazkii.psi.common.block.tile.container.slot.ValidatorSlot;

public class ContainerCADAssembler
extends Container {
    private static final EntityEquipmentSlot[] equipmentSlots = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public final TileCADAssembler assembler;
    private final int cadComponentStart;
    private final int socketableStart;
    private final int socketableEnd;
    private final int bulletStart;
    private final int bulletEnd;
    private final int playerStart;
    private final int playerEnd;
    private final int hotbarStart;
    private final int hotbarEnd;
    private final int armorStart;

    public ContainerCADAssembler(final EntityPlayer player, TileCADAssembler assembler) {
        InventoryPlayer playerInventory = player.field_71071_by;
        int playerSize = playerInventory.func_70302_i_();
        this.assembler = assembler;
        assembler.clearCachedCAD();
        InventoryAssemblerOutput output = new InventoryAssemblerOutput(player, assembler);
        InventorySocketable bullets = new InventorySocketable(assembler.getSocketableStack());
        this.func_75146_a(new SlotCADOutput(output, assembler, 120, 35));
        this.cadComponentStart = this.field_75151_b.size();
        this.func_75146_a(new ValidatorSlot((IInventory)assembler, assembler.getComponentSlot(EnumCADComponent.ASSEMBLY), 120, 91));
        this.func_75146_a(new ValidatorSlot((IInventory)assembler, assembler.getComponentSlot(EnumCADComponent.CORE), 100, 91));
        this.func_75146_a(new ValidatorSlot((IInventory)assembler, assembler.getComponentSlot(EnumCADComponent.SOCKET), 140, 91));
        this.func_75146_a(new ValidatorSlot((IInventory)assembler, assembler.getComponentSlot(EnumCADComponent.BATTERY), 110, 111));
        this.func_75146_a(new ValidatorSlot((IInventory)assembler, assembler.getComponentSlot(EnumCADComponent.DYE), 130, 111));
        this.socketableStart = this.field_75151_b.size();
        this.func_75146_a(new SlotSocketable((IInventory)assembler, bullets, 0, 35, 21));
        this.socketableEnd = this.field_75151_b.size();
        this.bulletStart = this.field_75151_b.size();
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.func_75146_a(new ValidatorSlot(bullets, col + row * 3, 17 + col * 18, 57 + row * 18));
            }
        }
        this.bulletEnd = this.field_75151_b.size();
        int xs = 48;
        int ys = 143;
        this.playerStart = this.field_75151_b.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, xs + col * 18, ys + row * 18));
            }
        }
        this.playerEnd = this.field_75151_b.size();
        this.hotbarStart = this.field_75151_b.size();
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInventory, col, xs + col * 18, ys + 58));
        }
        this.hotbarEnd = this.field_75151_b.size();
        this.armorStart = this.field_75151_b.size();
        for (int armorSlot = 0; armorSlot < 4; ++armorSlot) {
            final EntityEquipmentSlot slot = equipmentSlots[armorSlot];
            this.func_75146_a(new Slot((IInventory)playerInventory, playerSize - 2 - armorSlot, xs - 27, ys + 18 * armorSlot){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return !stack.func_190926_b() && stack.func_77973_b().isValidArmor(stack, slot, (Entity)player);
                }

                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[slot.func_188454_b()];
                }
            });
        }
        this.func_75146_a(new Slot((IInventory)playerInventory, playerSize - 1, 219, 143){

            @SideOnly(value=Side.CLIENT)
            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return this.assembler.func_70300_a(playerIn);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int from) {
        ItemStack mergeStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(from);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            mergeStack = stackInSlot.func_77946_l();
            if (from >= this.playerStart) {
                EnumCADComponent componentType;
                int componentSlot;
                if (stackInSlot.func_77973_b() instanceof ICADComponent ? !this.func_75135_a(stackInSlot, componentSlot = this.cadComponentStart + (componentType = ((ICADComponent)stackInSlot.func_77973_b()).getComponentType(stackInSlot)).ordinal(), componentSlot + 1, false) : (stackInSlot.func_77973_b() instanceof ISocketable ? !this.func_75135_a(stackInSlot, this.socketableStart, this.socketableEnd, false) : (stackInSlot.func_77973_b() instanceof ISpellSettable ? !this.func_75135_a(stackInSlot, this.bulletStart, this.bulletEnd, false) : (from < this.hotbarStart ? !this.func_75135_a(stackInSlot, this.hotbarStart, this.hotbarEnd, true) : !this.func_75135_a(stackInSlot, this.playerStart, this.playerEnd, false))))) {
                    return ItemStack.field_190927_a;
                }
            } else if (stackInSlot.func_77973_b() instanceof ItemArmor) {
                ItemArmor armor = (ItemArmor)stackInSlot.func_77973_b();
                int armorSlot = this.armorStart + armor.field_77881_a.func_188452_c() - 1;
                if (!this.func_75135_a(stackInSlot, armorSlot, armorSlot + 1, true) && !this.func_75135_a(stackInSlot, this.playerStart, this.hotbarEnd, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(stackInSlot, this.playerStart, this.hotbarEnd, true)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else if (stackInSlot.func_190916_E() == mergeStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stackInSlot);
        }
        return mergeStack;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        this.assembler.clearCachedCAD();
    }
}

